% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_describe_analysis_schemes}
\alias{cloudsearch_describe_analysis_schemes}
\title{Gets the analysis schemes configured for a domain}
\usage{
cloudsearch_describe_analysis_schemes(
  DomainName,
  AnalysisSchemeNames = NULL,
  Deployed = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the domain you want to describe.}

\item{AnalysisSchemeNames}{The analysis schemes you want to describe.}

\item{Deployed}{Whether to display the deployed configuration (\code{true}) or include any
pending changes (\code{false}). Defaults to \code{false}.}
}
\description{
Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing options for a \code{text} field. Can be limited to specific analysis schemes by name. By default, shows all analysis schemes and includes any pending changes to the configuration. Set the \code{Deployed} option to \code{true} to show the active configuration and exclude pending changes. For more information, see \if{html}{\out{<a href="https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html" target="_blank">}}Configuring Analysis Schemes\if{html}{\out{</a>}} in the \emph{Amazon CloudSearch Developer Guide}.

See \url{https://www.paws-r-sdk.com/docs/cloudsearch_describe_analysis_schemes/} for full documentation.
}
\keyword{internal}
