# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon HealthLake
#'
#' @description
#' Amazon HealthLake is a HIPAA eligibile service that allows customers to
#' store, transform, query, and analyze their FHIR-formatted data in a
#' consistent fashion in the cloud.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- healthlake(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- healthlake()
#' svc$create_fhir_datastore(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=healthlake_create_fhir_datastore]{create_fhir_datastore} \tab Creates a Data Store that can ingest and export FHIR formatted data\cr
#'  \link[=healthlake_delete_fhir_datastore]{delete_fhir_datastore} \tab Deletes a Data Store\cr
#'  \link[=healthlake_describe_fhir_datastore]{describe_fhir_datastore} \tab Gets the properties associated with the FHIR Data Store, including the Data Store ID, Data Store ARN, Data Store name, Data Store status, created at, Data Store type version, and Data Store endpoint\cr
#'  \link[=healthlake_describe_fhir_export_job]{describe_fhir_export_job} \tab Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job\cr
#'  \link[=healthlake_describe_fhir_import_job]{describe_fhir_import_job} \tab Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job\cr
#'  \link[=healthlake_list_fhir_datastores]{list_fhir_datastores} \tab Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status\cr
#'  \link[=healthlake_list_fhir_export_jobs]{list_fhir_export_jobs} \tab Lists all FHIR export jobs associated with an account and their statuses\cr
#'  \link[=healthlake_list_fhir_import_jobs]{list_fhir_import_jobs} \tab Lists all FHIR import jobs associated with an account and their statuses\cr
#'  \link[=healthlake_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of all existing tags associated with a Data Store\cr
#'  \link[=healthlake_start_fhir_export_job]{start_fhir_export_job} \tab Begins a FHIR export job\cr
#'  \link[=healthlake_start_fhir_import_job]{start_fhir_import_job} \tab Begins a FHIR Import job\cr
#'  \link[=healthlake_tag_resource]{tag_resource} \tab Adds a user specified key and value tag to a Data Store\cr
#'  \link[=healthlake_untag_resource]{untag_resource} \tab Removes tags from a Data Store
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname healthlake
#' @export
healthlake <- function(config = list()) {
  svc <- .healthlake$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.healthlake <- list()

.healthlake$operations <- list()

.healthlake$metadata <- list(
  service_name = "healthlake",
  endpoints = list("*" = list(endpoint = "healthlake.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "healthlake.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "healthlake.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "healthlake.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "HealthLake",
  api_version = "2017-07-01",
  signing_name = "healthlake",
  json_version = "1.0",
  target_prefix = "HealthLake"
)

.healthlake$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.healthlake$metadata, handlers, config)
}
