% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_put_schema_version_metadata}
\alias{glue_put_schema_version_metadata}
\title{Puts the metadata key value pair for a specified schema version ID}
\usage{
glue_put_schema_version_metadata(SchemaId, SchemaVersionNumber,
  SchemaVersionId, MetadataKeyValue)
}
\arguments{
\item{SchemaId}{The unique ID for the schema.}

\item{SchemaVersionNumber}{The version number of the schema.}

\item{SchemaVersionId}{The unique version ID of the schema version.}

\item{MetadataKeyValue}{[required] The metadata key's corresponding value.}
}
\description{
Puts the metadata key value pair for a specified schema version ID. A
maximum of 10 key value pairs will be allowed per schema version. They
can be added over one or more calls.
}
\section{Request syntax}{
\preformatted{svc$put_schema_version_metadata(
  SchemaId = list(
    SchemaArn = "string",
    SchemaName = "string",
    RegistryName = "string"
  ),
  SchemaVersionNumber = list(
    LatestVersion = TRUE|FALSE,
    VersionNumber = 123
  ),
  SchemaVersionId = "string",
  MetadataKeyValue = list(
    MetadataKey = "string",
    MetadataValue = "string"
  )
)
}
}

\keyword{internal}
