% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_list_delivery_streams}
\alias{firehose_list_delivery_streams}
\title{Lists your delivery streams in alphabetical order of their names}
\usage{
firehose_list_delivery_streams(Limit, DeliveryStreamType,
  ExclusiveStartDeliveryStreamName)
}
\arguments{
\item{Limit}{The maximum number of delivery streams to list. The default value is 10.}

\item{DeliveryStreamType}{The delivery stream type. This can be one of the following values:
\itemize{
\item \code{DirectPut}: Provider applications access the delivery stream
directly.
\item \code{KinesisStreamAsSource}: The delivery stream uses a Kinesis data
stream as a source.
}

This parameter is optional. If this parameter is omitted, delivery
streams of all types are returned.}

\item{ExclusiveStartDeliveryStreamName}{The list of delivery streams returned by this call to
\code{ListDeliveryStreams} will start with the delivery stream whose name
comes alphabetically immediately after the name you specify in
\code{ExclusiveStartDeliveryStreamName}.}
}
\description{
Lists your delivery streams in alphabetical order of their names.

The number of delivery streams might be too large to return using a
single call to \code{ListDeliveryStreams}. You can limit the number of
delivery streams returned, using the \code{Limit} parameter. To determine
whether there are more delivery streams to list, check the value of
\code{HasMoreDeliveryStreams} in the output. If there are more delivery
streams to list, you can request them by calling this operation again
and setting the \code{ExclusiveStartDeliveryStreamName} parameter to the name
of the last delivery stream returned in the last call.
}
\section{Request syntax}{
\preformatted{svc$list_delivery_streams(
  Limit = 123,
  DeliveryStreamType = "DirectPut"|"KinesisStreamAsSource",
  ExclusiveStartDeliveryStreamName = "string"
)
}
}

\keyword{internal}
