% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datapipeline_operations.R
\name{datapipeline_put_pipeline_definition}
\alias{datapipeline_put_pipeline_definition}
\title{Adds tasks, schedules, and preconditions to the specified pipeline}
\usage{
datapipeline_put_pipeline_definition(pipelineId, pipelineObjects,
  parameterObjects, parameterValues)
}
\arguments{
\item{pipelineId}{[required] The ID of the pipeline.}

\item{pipelineObjects}{[required] The objects that define the pipeline. These objects overwrite the
existing pipeline definition.}

\item{parameterObjects}{The parameter objects used with the pipeline.}

\item{parameterValues}{The parameter values used with the pipeline.}
}
\description{
Adds tasks, schedules, and preconditions to the specified pipeline. You
can use \code{PutPipelineDefinition} to populate a new pipeline.

\code{PutPipelineDefinition} also validates the configuration as it adds it
to the pipeline. Changes to the pipeline are saved unless one of the
following three validation errors exists in the pipeline.
\enumerate{
\item An object is missing a name or identifier field.
\item A string or reference field is empty.
\item The number of objects in the pipeline exceeds the maximum allowed
objects.
\item The pipeline is in a FINISHED state.
}

Pipeline object definitions are passed to the \code{PutPipelineDefinition}
action and returned by the GetPipelineDefinition action.
}
\section{Request syntax}{
\preformatted{svc$put_pipeline_definition(
  pipelineId = "string",
  pipelineObjects = list(
    list(
      id = "string",
      name = "string",
      fields = list(
        list(
          key = "string",
          stringValue = "string",
          refValue = "string"
        )
      )
    )
  ),
  parameterObjects = list(
    list(
      id = "string",
      attributes = list(
        list(
          key = "string",
          stringValue = "string"
        )
      )
    )
  ),
  parameterValues = list(
    list(
      id = "string",
      stringValue = "string"
    )
  )
)
}
}

\keyword{internal}
