% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_describe_analysis_schemes}
\alias{cloudsearch_describe_analysis_schemes}
\title{Gets the analysis schemes configured for a domain}
\usage{
cloudsearch_describe_analysis_schemes(DomainName, AnalysisSchemeNames,
  Deployed)
}
\arguments{
\item{DomainName}{[required] The name of the domain you want to describe.}

\item{AnalysisSchemeNames}{The analysis schemes you want to describe.}

\item{Deployed}{Whether to display the deployed configuration (\code{true}) or include any
pending changes (\code{false}). Defaults to \code{false}.}
}
\description{
Gets the analysis schemes configured for a domain. An analysis scheme
defines language-specific text processing options for a \code{text} field.
Can be limited to specific analysis schemes by name. By default, shows
all analysis schemes and includes any pending changes to the
configuration. Set the \code{Deployed} option to \code{true} to show the active
configuration and exclude pending changes. For more information, see
\href{https://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html}{Configuring Analysis Schemes}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_analysis_schemes(
  DomainName = "string",
  AnalysisSchemeNames = list(
    "string"
  ),
  Deployed = TRUE|FALSE
)
}
}

\keyword{internal}
