% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{ds_write_parquet}
\alias{ds_write_parquet}
\title{Write FHIR data to Parquet files}
\usage{
ds_write_parquet(ds, path, save_mode = SaveMode$ERROR)
}
\arguments{
\item{ds}{The DataSource object.}

\item{path}{The URI of the directory to write the files to.}

\item{save_mode}{The save mode to use when writing the data.}
}
\value{
No return value, called for side effects only.
}
\description{
Writes the data from a data source to a directory of Parquet files.
}
\examples{
\dontshow{if (pathling_is_spark_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples('ndjson'))

# Write the data to a directory of Parquet files.
data_source \%>\% ds_write_parquet(file.path(tempdir(), 'parquet'))

pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/fhirpath-query#parquet-1}{Pathling documentation - Writing Parquet}

Other data sink functions: 
\code{\link{ds_write_delta}()},
\code{\link{ds_write_ndjson}()},
\code{\link{ds_write_tables}()}
}
\concept{data sink functions}
