% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{hierarchical_pw_clustering}
\alias{hierarchical_pw_clustering}
\title{Hierarchical Clustering of Pathways}
\usage{
hierarchical_pw_clustering(kappa_mat, enrichment_res, use_names = FALSE,
  clu_method = "average", plot_hmap = FALSE, plot_dend = TRUE)
}
\arguments{
\item{kappa_mat}{matrix of kappa statistics (output of `create_kappa_matrix`)}

\item{enrichment_res}{data frame of pathway enrichment results}

\item{use_names}{boolean to indicate whether to use pathway names instead of IDs (default = FALSE, i.e. use IDs)}

\item{clu_method}{the agglomeration method to be used (default = "average", see `?hclust`)}

\item{plot_hmap}{boolean to indicate whether to plot the kappa statistics
heatmap or not (default = FALSE)}

\item{plot_dend}{boolean to indicate whether to plot the clustering dendrogram
partitioned into the optimal number of clusters (default = TRUE)}
}
\value{
a vector of clusters for each term in the enrichment results.
}
\description{
Hierarchical Clustering of Pathways
}
\details{
The function initially performs hierarchical clustering
of the terms in `enrichment_res` using the kappa statistics
(defining the distance as `-kappa_statistic`). Next,
the clustering dendrogram is cut into k = 2, 3, ..., n - 1 clusters (where
n is the number of terms). The optimal number of clusters is determined as the
k value which yields the highest average silhouette width.
}
\examples{
\dontrun{
hierarchical_pw_clustering(kappa_mat, enrichment_res)
hierarchical_pw_clustering(kappa_mat, enrichment_res, method = "complete")
}
}
