% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-tdc.R
\name{combine_cut}
\alias{combine_cut}
\title{Extract unique cut points when time-dependent covariates present}
\usage{
combine_cut(event_df, tdc_df, time_var, status_var, tz_var, cens_value = 0)
}
\arguments{
\item{tdc_df}{A data frame containing information on time-dependent variables
in long format. Needs to contain a "time" variable indicating when the
TDCs change their value. Must have same name as variable indicating event
times in \code{event_df}.}

\item{time_var}{A character, specifies the column of the event or
censoring time in \code{event_df} and the time of measurement for
the time-dependent covariates in \code{tdc_df}.}

\item{status_var}{As \code{time_var}, but specifies column containing the
event indicator. Can be missing in the \code{tdc_df}.}

\item{cens_value}{The value that indicates censoring in the
\code{status_var} column.}
}
\description{
Given a data frame with one row per subject containing event times and
a data frame containing time points at which a time-dependent covariate changes
its value, returns the unique time at which either event occurs or a
time-dependent covariate changes its value.
}
\keyword{internal}
