% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closest_weekday.R
\name{closest_weekday}
\alias{closest_weekday}
\title{Retrieve the closest given weekday}
\usage{
closest_weekday(x, wday = 1, direction = c("down", "up"))
}
\arguments{
\item{x}{A vector of class \code{Date}, \code{POSIXct}, or \code{POSIXlt}.}

\item{wday}{Integer in the range 0-6 specifying the desired weekday start
(0 = Sun, 1 = Mon, 2 = Tue, 3 = Wed, 4 = Thu, 5 = Fri, 6 = Sat).}

\item{direction}{The first desired weekday before ("down") or after ("up")
the first day in \code{x}.}
}
\value{
Object of class \code{Date}, reflecting the closest desired weekday
to \code{x}.
}
\description{
Find the closest instance of the requested weekday to \code{min(x)}.
Helper function for \code{thicken} with the interval "week", when the user
desires the start day of the weeks to be different from Sundays.
}
\examples{
closest_weekday(coffee$time_stamp)
closest_weekday(coffee$time_stamp, 5)
closest_weekday(coffee$time_stamp, 1, direction = "up")
closest_weekday(coffee$time_stamp, 5, direction = "up")
}
