% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{infect}
\alias{infect}
\title{Adjust a Package}
\usage{
infect(path, fakemake = "check", git_add_and_commit = TRUE, ...)
}
\arguments{
\item{path}{Path to the package directory (see
\code{\link[devtools:as.package]{devtools::as.package}}).}

\item{fakemake}{The \code{name} for a
\code{\link[packager:get_package_makelist]{makelist}} for \pkg{fakemake}.
Set to \code{\link{NULL}} or \code{\link{FALSE}} to disable running 
\code{\link[fakemake:make]{fakemake::make}}.}

\item{git_add_and_commit}{Add and commit changes in git?}

\item{...}{Arguments to be passed to \code{\link{set_package_info}}.}
}
\value{
\code{\link[base:invisible]{Invisibly}}
\code{\link[base:NULL]{NULL}}.
}
\description{
Add a variety of extensions to a package (skeleton) and run
\code{\link[fakemake:make]{fakemake::make}} on
it.
}
\examples{
\dontrun{
if (require("roxygen2")) { 
path <- file.path(tempdir(), "mySecondPackage")
usethis::create_package(path = path, open = FALSE)
l1 <- list.files(path, recursive = TRUE)
packager::infect(path = path, fakemake = "roxygen2", fakemake = FALSE)
l2 <- list.files(path, recursive = TRUE)
print(l1); print(l2)
unlink(path, recursive = TRUE)
}
}
}
\seealso{
\code{\link{create}}
}
