#' Precipitation summary plot
#'
#' Function for plotting precipitation summary (line, matrix, box, and density)
#'
#' @import ggplot2
#' @importFrom ggpubr ggarrange
#' @param dummie a csv generated by \code{\link{make_ts}}
#' @return ggplot object
#' @export

plot_summary <- function(dummie){
  p01 <- plot_line(dummie)
  p02 <- plot_heatmap(dummie)
  p03 <- plot_box(dummie)
  p04 <- plot_density(dummie)
  p05 <- ggarrange(p01, p02, ncol = 1)
  p06 <- ggarrange(p03, p04, ncol = 2)
  p00 <- ggarrange(p05, p06, ncol = 1, heights = c(2, 1))
  return(p00)
}

