% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPSCapabilities.R
\docType{class}
\name{WPSCapabilities}
\alias{WPSCapabilities}
\title{WPSCapabilities}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing an OGC
Web Processing Service (WPS) Get Capabilities document.
}
\description{
WPSCapabilities

WPSCapabilities
}
\note{
Class used to read a \code{WPSCapabilities} document. The use of \code{WPSClient} is
recommended instead to benefit from the full set of capabilities associated to a WPS server.
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Capabilities}
\keyword{OGC}
\keyword{WPS}
\section{Super classes}{
\code{\link[ows4R:OGCAbstractObject]{ows4R::OGCAbstractObject}} -> \code{\link[ows4R:OWSCapabilities]{ows4R::OWSCapabilities}} -> \code{WPSCapabilities}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WPSCapabilities-new}{\code{WPSCapabilities$new()}}
\item \href{#method-WPSCapabilities-getProcesses}{\code{WPSCapabilities$getProcesses()}}
\item \href{#method-WPSCapabilities-describeProcess}{\code{WPSCapabilities$describeProcess()}}
\item \href{#method-WPSCapabilities-execute}{\code{WPSCapabilities$execute()}}
\item \href{#method-WPSCapabilities-clone}{\code{WPSCapabilities$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="ERROR"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-ERROR'><code>ows4R::OGCAbstractObject$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="INFO"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-INFO'><code>ows4R::OGCAbstractObject$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="WARN"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-WARN'><code>ows4R::OGCAbstractObject$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="encode"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-encode'><code>ows4R::OGCAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClass"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClass'><code>ows4R::OGCAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClassName"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClassName'><code>ows4R::OGCAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getNamespaceDefinition"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getNamespaceDefinition'><code>ows4R::OGCAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="isFieldInheritedFrom"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-isFieldInheritedFrom'><code>ows4R::OGCAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="logger"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-logger'><code>ows4R::OGCAbstractObject$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getClient"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getClient'><code>ows4R::OWSCapabilities$getClient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getOWSVersion"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getOWSVersion'><code>ows4R::OWSCapabilities$getOWSVersion()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getOperationsMetadata"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getOperationsMetadata'><code>ows4R::OWSCapabilities$getOperationsMetadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getRequest"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getRequest'><code>ows4R::OWSCapabilities$getRequest()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getService"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getService'><code>ows4R::OWSCapabilities$getService()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceIdentification"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceIdentification'><code>ows4R::OWSCapabilities$getServiceIdentification()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceProvider"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceProvider'><code>ows4R::OWSCapabilities$getServiceProvider()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceVersion"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceVersion'><code>ows4R::OWSCapabilities$getServiceVersion()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getUrl"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getUrl'><code>ows4R::OWSCapabilities$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="setClient"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-setClient'><code>ows4R::OWSCapabilities$setClient()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WPSCapabilities-new"></a>}}
\if{latex}{\out{\hypertarget{method-WPSCapabilities-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{WPSCapabilities} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WPSCapabilities$new(url, version, client = NULL, logger = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{version}}{version}

\item{\code{client}}{an object of class \link{WPSClient}}

\item{\code{logger}}{logger type \code{NULL}, "INFO" or "DEBUG"}

\item{\code{...}}{any other parameter to pass to \link{OWSGetCapabilities} service request}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WPSCapabilities-getProcesses"></a>}}
\if{latex}{\out{\hypertarget{method-WPSCapabilities-getProcesses}{}}}
\subsection{Method \code{getProcesses()}}{
Get the list of processes offered by the service capabilities. \code{pretty} allows to control
   the type output. If \code{TRUE}, a \code{data.frame} will be returned. When prettified output, it
   is also possible to get a 'full' description of the process by setting \code{full = TRUE} in which 
   case a the WPS client will request a process description (with more information about the process) for
   each process listed in the capabilities.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WPSCapabilities$getProcesses(pretty = FALSE, full = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pretty}}{pretty}

\item{\code{full}}{full}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{list} of \link{WPSProcessDescription} or a \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WPSCapabilities-describeProcess"></a>}}
\if{latex}{\out{\hypertarget{method-WPSCapabilities-describeProcess}{}}}
\subsection{Method \code{describeProcess()}}{
Get the description of a process, given its \code{identifier}, returning an object of class \code{WPSProcessDescription}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WPSCapabilities$describeProcess(identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{process identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{WPSProcessDescription}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WPSCapabilities-execute"></a>}}
\if{latex}{\out{\hypertarget{method-WPSCapabilities-execute}{}}}
\subsection{Method \code{execute()}}{
Execute a process, given its \code{identifier}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WPSCapabilities$execute(
  identifier,
  dataInputs = list(),
  responseForm = NULL,
  storeExecuteResponse = FALSE,
  lineage = NULL,
  status = NULL,
  update = FALSE,
  updateInterval = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{process identifier}

\item{\code{dataInputs}}{a named list of data inputs, objects of class \link{WPSLiteralData}, \link{WPSComplexData} or \link{WPSBoundingBoxData}}

\item{\code{responseForm}}{response form, object of class \link{WPSResponseDocument}}

\item{\code{storeExecuteResponse}}{store execute response? object of class \code{logical}. \code{FALSE} by default}

\item{\code{lineage}}{lineage, object of class \code{logical}}

\item{\code{status}}{status, object of class \code{logical}}

\item{\code{update}}{update, object of class \code{logical}. For asynchronous requests}

\item{\code{updateInterval}}{update interval, object of class \code{integer}. For asynchronous requests}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WPSCapabilities-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WPSCapabilities-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WPSCapabilities$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
