% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{orderly_graph}
\alias{orderly_graph}
\title{Print the dependency tree for a given report using orderly log}
\usage{
orderly_graph(
  name,
  id = "latest",
  root = NULL,
  locate = TRUE,
  direction = "downstream",
  propagate = TRUE,
  max_depth = Inf,
  recursion_limit = 100,
  show_all = FALSE,
  use = "archive"
)
}
\arguments{
\item{name}{the name of the report}

\item{id}{the id of the report, if omitted, use the id of the
latest report}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{direction}{A string indicating if we want to move up or down
the tree permitted values are upstream, downstream}

\item{propagate}{A boolean indicating if we want to propagate out
of date through the tree}

\item{max_depth}{A numeric, how far back should the tree go, this
can be useful to truncate a very large tree. (default = Inf)}

\item{recursion_limit}{A numeric, limit for depth of tree, if the tree
goes beyond this then an error is thrown. (default = 100)}

\item{show_all}{A boolean, should we show all reports in the tree,
not just the latest.}

\item{use}{Character string indicating what we read to infer the
dependency tree.  Current valid values are \code{archive} (the
default), which reads from archive reports and \code{src} which
reads from the source reports.}
}
\value{
An orderly tree object with the root corresponding to the given
report.
}
\description{
Investigate the dependency structure in a set of orderly reports.
This function allows the dependency graph to be created for set of
reports that have been run and committed (the archive) or of a set
of reports that could be run (the src) to be discovered and
printed to screen.  \emph{This is experimental and somewhat subject to
change and improvement.}
}
\details{
orderly allows a report to rely on the artefacts of one or more
other orderly reports. This allows users to develop a network of
interconnected reports where the output from report becomes the
source of data for another.  There are two natural questions that
can develop around this workflow:
\enumerate{
\item We have updated a report; what are the reports that depend on
this so that we can re-run them?
\item We have a report that we want to re-run to ensure uses the
latest information. Which other reports are used (directly or
indirectly) by this report?
}

This function displays this information in an easily readable
format.  Allowing users to see the dependency tree and which
reports are out of date and need to be re-run.
}
\section{Remark}{


By default the tree is built using data from the local report
database (see \link{orderly_commit},
\link{orderly_db}). This means that it will not find changes
from a report that has not be run and committed. That is, if a
user changes a report to use or create different artefacts this
will not be picked up by the function until the reports are
re-run and committed to the archive.

It is possible to generate a tree from the source reports by using
\code{use = "src"} - this generates the "theoretical tree", and has
no concept of being "up to date" or of ids.
}

\section{Warning}{


\emph{This interface is considered experimental and may change without
notice}.  Please do not depend on it in scripts as it may break
things.  Consider this a (hopefully) useful way of exploring the
dependencies in your reports \emph{interactively} - let us know what
is missing and we'll try and build it out.
}

\examples{
path <- orderly::orderly_example("demo")

id <- orderly::orderly_run("other", root = path, parameters=list(nmin=0))
orderly::orderly_commit(id, root = path)
id <- orderly::orderly_run("use_dependency", root = path)
orderly::orderly_commit(id, root = path)
id <- orderly::orderly_run("use_dependency_2", root = path)
orderly::orderly_commit(id, root = path)
orderly::orderly_graph("other", root = path)
orderly::orderly_graph("use_dependency_2", root = path,
                                 direction = "upstream")
}
