!  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!        IMPLICIT INTEGER(I-N)
!        IMPLICIT DOUBLE PRECISION(A-H,O-Z)
        SUBROUTINE OC(VOTES,NUMMEMBERS,NUMVOTES,DIMS,       &
          POLARITY,CLASSIFY,FITS,VOLUME,                       &
          IDEALPOINTS,MIDPOINTS,NORMALVECTORS,EIGENVALUES,     &
          EXITSTATUS)
!
        IMPLICIT DOUBLE PRECISION(A-H,O-Z)
        INTEGER VOTES(NUMMEMBERS*NUMVOTES),DIMS,POLARITY(DIMS), &
     &          EXITSTATUS
        DOUBLE PRECISION EIGENVALUES(NUMMEMBERS), &
     &          CLASSIFY((NUMMEMBERS+NUMVOTES)*4), &
     &          FITS(2),MIDPOINTS(NUMVOTES), &
     &          NORMALVECTORS(NUMVOTES*DIMS), &
     &          IDEALPOINTS(NUMMEMBERS*DIMS),VOLUME(NUMMEMBERS)
!
      INTEGER, ALLOCATABLE :: LDATA(:,:)
      INTEGER, ALLOCATABLE :: KAV(:)
      INTEGER, ALLOCATABLE :: KAY(:)
      INTEGER, ALLOCATABLE :: KAN(:)
      INTEGER, ALLOCATABLE :: MCUTS(:,:)
      INTEGER, ALLOCATABLE :: LERROR(:,:)
      INTEGER, ALLOCATABLE :: LLEGERR(:,:)
      INTEGER, ALLOCATABLE :: KCUTTER(:)
      INTEGER, ALLOCATABLE :: LCUTTER(:)
      INTEGER, ALLOCATABLE :: LLL(:)
      INTEGER, ALLOCATABLE :: MDATA(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ZMAT2(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: WVEC2(:)
      DOUBLE PRECISION, ALLOCATABLE :: DSTAR(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XDATA(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XXX(:)
      DOUBLE PRECISION, ALLOCATABLE :: SSS(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZMID(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: DYN(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XSAVE(:,:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ZSAVE(:,:,:)
      DOUBLE PRECISION, ALLOCATABLE :: CSAVE(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XMAT0(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XMAT(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ZVEC(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: WS(:)
      DOUBLE PRECISION, ALLOCATABLE :: XONE(:)
      DOUBLE PRECISION, ALLOCATABLE :: XPT(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZPT(:)
      DOUBLE PRECISION, ALLOCATABLE :: XPROJ(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ZS(:)
      DOUBLE PRECISION, ALLOCATABLE :: YRANK(:)
      DOUBLE PRECISION, ALLOCATABLE :: FV1(:)
      ALLOCATE(LDATA(NUMMEMBERS,NUMVOTES))
      ALLOCATE(KAV(NUMVOTES))
      ALLOCATE(KAY(NUMVOTES))
      ALLOCATE(KAN(NUMVOTES))
      ALLOCATE(MCUTS(NUMVOTES,2))
      ALLOCATE(LERROR(NUMMEMBERS,NUMVOTES))
      ALLOCATE(LLEGERR(NUMMEMBERS,2))
      ALLOCATE(KCUTTER(NUMVOTES))
      ALLOCATE(LCUTTER(NUMVOTES))
      ALLOCATE(LLL(NUMVOTES))
      ALLOCATE(MDATA(6,NUMVOTES))
      ALLOCATE(ZMAT2(NUMMEMBERS,NUMMEMBERS))
      ALLOCATE(WVEC2(NUMMEMBERS))
      ALLOCATE(DSTAR(NUMMEMBERS,NUMMEMBERS))
      ALLOCATE(XDATA(NUMMEMBERS,25))
      ALLOCATE(XXX(NUMMEMBERS))
      ALLOCATE(SSS(100))
      ALLOCATE(ZMID(NUMVOTES,25))
      ALLOCATE(DYN(NUMVOTES,25))
      ALLOCATE(XSAVE(NUMMEMBERS,2,2))
      ALLOCATE(ZSAVE(NUMVOTES,2,2))
      ALLOCATE(CSAVE(NUMVOTES,2))
      ALLOCATE(XMAT0(NUMMEMBERS,25))
      ALLOCATE(XMAT(NUMMEMBERS,25))
      ALLOCATE(ZVEC(NUMVOTES,25))
      ALLOCATE(WS(2*NUMMEMBERS+2*NUMVOTES+111))
      ALLOCATE(XONE(2*NUMMEMBERS+2*NUMVOTES+111))
      ALLOCATE(XPT(2*NUMMEMBERS+2*NUMVOTES+111))
      ALLOCATE(ZPT(NUMVOTES))
      ALLOCATE(XPROJ(2,NUMVOTES))
      ALLOCATE(ZS(NUMVOTES))
      ALLOCATE(YRANK(NUMMEMBERS))
      ALLOCATE(FV1(NUMMEMBERS))
!
!  100 FORMAT(6I6)
!  150 FORMAT(I5,75F10.4)
!  304 FORMAT(1X,78('*'))
! 1095 FORMAT(' L-PERMUTATIONS',I3,2I8,8F9.5)
! 1096 FORMAT(3I5,25F10.4)
! 1097 FORMAT(2I5,6I4,2I2,25F10.4)
! 1098 FORMAT(' R-SQUARE BEFORE AND AFTER EDITH',F10.4)
! 1099 FORMAT(' MACHINE PREC. ',I3,2I8,3F9.5)
!
!    SET VARIABLES AND ARRAYS PASSED IN FROM R TO THEIR NAMES
!        USED IN THE ORIGINAL NOMINATE AND W-NOMINATE FORTRAN
!        CODE
!
!  SET PRINTER SWITCH FOR DEBUGGING PURPOSES -- 1=PRINT, 0=NO PRINT
!
      IPRINT=0
!
!  INITIALIZE RANDOM NUMBER GENERATOR
!
!      CALL RNDSTART()
      NS=DIMS
      NP=NUMMEMBERS
      NRCALL=NUMVOTES
!
      NDUAL=2*(NP+NRCALL)+111
!
      XVMIN=0.005
      KVMIN=10
!
!  INITIALIZE CLASSIFY
!
      KK=0
      DO 1 I=1,4
      DO 11 J=1,NRCALL+NP
      KK=KK+1
      CLASSIFY(KK)=0.0
  11  CONTINUE
  1   CONTINUE
!
      DO 8990 I=1,NP
      XXX(I)=0.0
 8990 CONTINUE
!
!  UN-TRANSPOSED CODE
!
      DO 1881 J=1,NRCALL
      NORMALVECTORS(J)=0.0
      DO 191 I=1,NP
      LDATA(I,J)=VOTES(I+(J-1)*NP)
      LERROR(I,J)=0
  191 CONTINUE
 1881 CONTINUE
!
!      IF(IPRINT.EQ.1)THEN
!         WRITE(11,100)NS,NP,NRCALL,NDUAL
!         DO 291 I=1,NP
!         WRITE(11,200)I,(LDATA(I,J),J=1,NRCALL)
!  291    CONTINUE
!      ENDIF
!
!  SUBROUTINE KPCLEAN--THROWS OUT ALL VOTES WITH LESS THAN XVMIN MAJ. AND
!    ALL LEGISLATORS VOTING LESS THAN KVMIN TIMES
!
      CALL KPCLEAN(NP,NRCALL,XVMIN,KVMIN,IPRINT,KPTSUM,LDATA, &
                 KAV,KAY,KAN)
!
!  RESET NUMBER OF DIMENSIONS IF IT EXCEEDS NP-1
!
      IF(NS.GT.NP-1)THEN
         NS=NP-1
      ENDIF
!
      DO 69 J=1,NRCALL
      DO 68 L=1,NS
      ZMID(J,L)=0.0
      DYN(J,L)=0.0
  68  CONTINUE
  69  CONTINUE
!
!
!  CALCULATE AGREEMENT SCORE MATRIX, DOUBLE-CENTER IT, AND
!     EXTRACT EIGENVECTORS TO OBTAIN LEGISLATOR STARTS
!
      CALL KPASCORE(NP,NRCALL,NS,NDUAL,11,IPRINT, &
                        ZMAT2,WVEC2,DSTAR,LDATA)
!
      DO 44 I=1,NP
      VOLUME(I)=0.0
      EIGENVALUES(I)=WVEC2(NP+1-I)
      DO 58 K=1,NS
      XDATA(I,K)=ZMAT2(I,NP+1-K)*SQRT(ABS(WVEC2(NP+1-K)))
      IF(NS.EQ.1)XXX(I)=XDATA(I,1)
  58  CONTINUE
!      IF(IPRINT.EQ.1)WRITE(11,150)I,EIGENVALUES(I), &
!                     (XDATA(I,K),K=1,NS)
  44  CONTINUE
!
!  NORMALIZE ESTIMATES OF LEGISLATORS TO BE WITHIN THE
!   UNIT HYPERSPHERE WITH CENTROID = 0
!
!
!  PERFORM METRIC SCALING TO INCREASE PRECISION OF STARTING COORDINATES
!
      CALL KPWHOOPE(NP,NS,DSTAR,XXX,XDATA,SSE1,SSE2,KTP,IPRINT)
      DO 71 K=1,NS
      SUM=0.0
      BB=-99.0
      DO 70 I=1,NP
      IF(NS.EQ.1)XDATA(I,1)=XXX(I)
  70  SUM=SUM+XDATA(I,K)
      DO 72 I=1,NP
      XDATA(I,K)=XDATA(I,K)-SUM/FLOAT(NP)
  72  BB=AMAX1(BB,XDATA(I,K))
      DO 73 I=1,NP
  73  XDATA(I,K)=XDATA(I,K)/BB
  71  CONTINUE
!
!  NORMALIZE ESTIMATES OF LEGISLATORS TO BE WITHIN THE
!   UNIT HYPERSPHERE WITH CENTROID = 0
!
      DO 51 K=1,NS
      SUM=0.0
      DO 50 I=1,NP
  50  SUM=SUM+XDATA(I,K)
      DO 52 I=1,NP
      XDATA(I,K)=XDATA(I,K)-SUM/FLOAT(NP)
  52  CONTINUE
  51  CONTINUE
      BB=-99.0
      DO 56 I=1,NP
      SUM=0.0
      DO 54 K=1,NS
      SUM=SUM+XDATA(I,K)**2
  54  CONTINUE
      BB=AMAX1(BB,SUM)
  56  CONTINUE
      DO 55 I=1,NP
      DO 57 K=1,NS
      XDATA(I,K)=XDATA(I,K)*(1.0/SQRT(BB))
  57  CONTINUE
  55  CONTINUE
!
!  WRITE OUT METRIC SCALING COORDINATES USED AS STARTS
!
      DO 713 I=1,NP
      DO 714 K=1,NS
      XMAT0(I,K)=XDATA(I,K)
!      XMAT0(I,K)=ZMAT2(I,NP+1-K)
  714 CONTINUE
  713 CONTINUE
!
!  CHECK POLARITY OF OC COORDINATES
!
      KLSEN=POLARITY(1)
      KLSEN2=POLARITY(2)
      XLEFT=XMAT0(KLSEN,1)
      XUP=XMAT0(KLSEN2,2)
      DO 1949 I=1,NP
      IF(XLEFT.LT.0.0)THEN
         XMAT0(I,1)=-XMAT0(I,1)
      ENDIF
      IF(XUP.LT.0.0)THEN
         XMAT0(I,2)=-XMAT0(I,2)
      ENDIF
      XONE(I)=XMAT0(I,1)
      XDATA(I,1)=XMAT0(I,1)
      XDATA(I,2)=XMAT0(I,2)
 1949 CONTINUE
!
!  INITIALIZE NORMAL VECTORS TO SQRT(1/S)
!
      DO 618 JJ=1,NRCALL
      DO 619 K=1,NS
      ZVEC(JJ,K)=SQRT(1.0/FLOAT(NS))
  619 CONTINUE
  618 CONTINUE
!
      CALL KPZVECSTRT(NP,NRCALL,NS,NDUAL,XMAT0,ZVEC,LDATA,IPRINT)
!
!    RUN EDITH TO GET OPTIMAL CLASSIFICATIONS FOR S=1
!
      CALL KPEDITH(NP,NRCALL,NS,NDUAL,XMAT0,XONE,XPT,ZPT,XCLASS,KTOTC, &
                 KCUTTER,LCUTTER,LERROR,LDATA,MSUM,IPRINT)
!
!  TOTAL CHOICES IN MINORITY
!
      MPRE=KTOTC-MSUM
!
!
!  COMPUTE R-SQUARE BETWEEN EDITH COORDINATES AND COORDINATES FROM
!    MATRIX DECOMPOSITION
!
      ASUM=0.0
      BSUM=0.0
      CSUM=0.0
      DSUM=0.0
      ESUM=0.0
      DO 131 I=1,NP
      ASUM=ASUM+XMAT0(I,1)
      BSUM=BSUM+XPT(I)
      CSUM=CSUM+XMAT0(I,1)**2
      DSUM=DSUM+XPT(I)**2
      ESUM=ESUM+XMAT0(I,1)*XPT(I)
!
      XMAT0(I,1)=XPT(I)
!
  131 CONTINUE
      AA=FLOAT(NP)*ESUM-ASUM*BSUM
      AB=FLOAT(NP)*CSUM-ASUM*ASUM
      AC=FLOAT(NP)*DSUM-BSUM*BSUM
      RSQR=(AA*AA)/(AB*AC)
!      IF(IPRINT.EQ.1)WRITE(23,1098)RSQR
!
!
      IF(NS.EQ.1)THEN
!
!  DO PERMUTATIONS OF ALL 5-ADJACENT LEGISLATOR BLOCKS TO SHARPEN
!       RANK ORDERING
!
!
      CALL ECHOEVENT(15)
      CALL FLUSHCON()
      CALL PROCEVENT()
         NNPERM=2
         CALL KPSHARPEN(NNPERM,NP,NRCALL,NS,NDUAL,KCUTTER,LCUTTER, &
                       XMAT0,ZPT,WS,LDATA,LERROR,IPRINT)
      CALL ECHOEVENT(16)
      CALL FLUSHCON()
      CALL PROCEVENT()
         NNPERM=3
         CALL KPSHARPEN(NNPERM,NP,NRCALL,NS,NDUAL,KCUTTER,LCUTTER, &
                       XMAT0,ZPT,WS,LDATA,LERROR,IPRINT)
!         NNPERM=4
!         CALL KPSHARPEN(NNPERM,NP,NRCALL,NS,NDUAL,KCUTTER,LCUTTER,
!     C                 XMAT0,ZPT,WS,LDATA,LERROR,IPRINT)
!
!  CALCULATE ERRORS
!
         DO 6999 I=1,NP
         KITOT=0
         KIERR=0
         DO 6998 JX=1,NRCALL
         IF(LDATA(I,JX).NE.0)KITOT=KITOT+1
         IF(LERROR(I,JX).EQ.1)KIERR=KIERR+1
 6998    CONTINUE
         LLEGERR(I,1)=KIERR
         LLEGERR(I,2)=KITOT
 6999    CONTINUE
!
!  RANK ORDER THE LEGISLATORS
!
         DO 6701 I=1,NP
         XXX(I)=XMAT0(I,1)
         LLL(I)=I
 6701    CONTINUE
         CALL KPRSORT(XXX,NP,LLL)
!
         DO 6702 I=1,NP
         YRANK(I)=0.0
         KK=0
         LL=0
         JJ=0
         DO 6703 J=1,NP
         JJ=JJ+1
         IF(ABS(XXX(I)-XXX(J)).LE..00001)THEN
            KK=KK+1
            LL=LL+JJ
         ENDIF
 6703    CONTINUE
         YRANK(I)=FLOAT(LL)/FLOAT(KK)
 6702    CONTINUE
!
!
!  WRITE OUT LEGISLATOR COORDINATES -- SORTED AND UNSORTED BY RANK
!
         DO 887 I=1,NP
         FV1(LLL(I))=YRANK(I)
         BPER=FLOAT(LLEGERR(LLL(I),2)-LLEGERR(LLL(I),1))/ &
                                         FLOAT(LLEGERR(LLL(I),2))
!         IF(IPRINT.EQ.1)WRITE(25,1096)I, &
!                         LLEGERR(LLL(I),1),LLEGERR(LLL(I),2), &
!                                  BPER,YRANK(I)
  887    CONTINUE
!         IF(IPRINT.EQ.1)WRITE(25,304)
         DO 888 I=1,NP
         BPER=FLOAT(LLEGERR(I,2)-LLEGERR(I,1))/ &
                                         FLOAT(LLEGERR(I,2))
!         IF(IPRINT.EQ.1)WRITE(25,1096)I, &
!                         LLEGERR(I,1),LLEGERR(I,2), &
!                                  BPER,FV1(I)
!
!  TRANSFER OC COORDINATES TO OUTPUT VECTOR
!
         IDEALPOINTS(I)=FV1(I)
  888    CONTINUE
!
!  WRITE OUT ROLL CALL CLASSIFICATIONS
!
!         IF(IPRINT.EQ.1)WRITE(25,304)
         KTSUM=0
         NMISS=0
         DO 811 J=1,NRCALL
         KSUM=0
         KYES=0
         KNO=0
         KYEAYEA=0
         KNAYNAY=0
         KYEANAY=0
         KNAYYEA=0
         DO 812 I=1,NP
         IF(LDATA(I,J).EQ.0)NMISS=NMISS+1
         IF(LDATA(I,J).EQ.1)KYES=KYES+1
         IF(LDATA(I,J).EQ.6)KNO=KNO+1
         IF(LERROR(I,J).EQ.0)THEN
!
!  CORRECT CHOICE -- YEA
!
            IF(LDATA(I,J).EQ.1)THEN
               KYEAYEA=KYEAYEA+1
               CLASSIFY((I-1)*4 + 1)=CLASSIFY((I-1)*4 + 1)+1
            ENDIF
!
!  CORRECT CHOICE -- NAY
!
            IF(LDATA(I,J).EQ.6)THEN
               KNAYNAY=KNAYNAY+1
               CLASSIFY((I-1)*4 + 4)=CLASSIFY((I-1)*4 + 4)+1
            ENDIF
         ENDIF
         IF(LERROR(I,J).EQ.1)THEN
            KSUM=KSUM+1
!
!  INCORRECT CHOICE -- VOTED YEA INSTEAD OF NAY
!
            IF(LDATA(I,J).EQ.1)THEN
               KYEANAY=KYEANAY+1
               CLASSIFY((I-1)*4 + 3)=CLASSIFY((I-1)*4 + 3)+1
            ENDIF
!
!  INCORRECT CHOICE -- VOTED NAY INSTEAD OF YEA
!
            IF(LDATA(I,J).EQ.6)THEN
               KNAYYEA=KNAYYEA+1
               CLASSIFY((I-1)*4 + 2)=CLASSIFY((I-1)*4 + 2)+1
            ENDIF
         ENDIF
         IF(ZPT(J).LT.XXX(1))THEN
            ZDOWN=YRANK(1)
            ZUP=YRANK(1)
            go to 812
         ENDIF
         IF(ZPT(J).GT.XXX(NP))THEN
            ZDOWN=YRANK(NP)
            ZUP=YRANK(NP)
            go to 812
         ENDIF
         IF(ZPT(J).GT.XXX(I).AND.ZPT(J).LT.XXX(I+1))THEN
            ZDOWN=YRANK(I)
            ZUP=YRANK(I+1)
         ENDIF
  812    CONTINUE
         KTSUM=KTSUM+KSUM
         KYESNO=AMIN0(KYES,KNO)
         XCLASS=FLOAT(KYEAYEA+KNAYNAY)/ &
                    FLOAT(KYEAYEA+KNAYNAY+KYEANAY+KNAYYEA)
         XPRE=FLOAT(KYESNO-KSUM)/FLOAT(KYESNO)
!
!  COMPUTE CUTTING POINT ON NORMAL VECTOR
!
!         IF(IPRINT.EQ.1)WRITE(25,1097)J,KAV(J),KYES,KNO, &
!                      KYEAYEA,KNAYYEA,KYEANAY,KNAYNAY, &
!                      KCUTTER(J),LCUTTER(J), &
!                      XCLASS,XPRE,(ZDOWN+ZUP)/2.0
         CLASSIFY(NP*4 + (J-1)*4 + 1)=KYEAYEA
         CLASSIFY(NP*4 + (J-1)*4 + 2)=KNAYYEA
         CLASSIFY(NP*4 + (J-1)*4 + 3)=KYEANAY
         CLASSIFY(NP*4 + (J-1)*4 + 4)=KNAYNAY
         LLL(J)=J
         MDATA(1,J)=KYES
         MDATA(2,J)=KNO
         MDATA(3,J)=KYEAYEA
         MDATA(4,J)=KYEAYEA
         MDATA(5,J)=KYEAYEA
         MDATA(6,J)=KYEAYEA
         XPROJ(1,J)=XCLASS
         XPROJ(2,J)=XPRE
         ZS(J)=(ZDOWN+ZUP)/2.0
         MIDPOINTS(J)=ZS(J)
  811    CONTINUE
         CALL KPRSORT(ZS,NRCALL,LLL)
!         IF(IPRINT.EQ.1)WRITE(25,304)
         DO 814 J=1,NRCALL
!         IF(IPRINT.EQ.1)WRITE(25,1097)LLL(J),KAV(LLL(J)), &
!                       (MDATA(JJ,LLL(J)),JJ=1,6), &
!                       KCUTTER(LLL(J)),LCUTTER(LLL(J)), &
!                       XPROJ(1,LLL(J)), &
!                       XPROJ(2,LLL(J)),ZS(J)
  814    CONTINUE
         XHECK=1.0-(FLOAT(KTSUM)/FLOAT(NP*NRCALL-NMISS))
         XPRE=FLOAT(MPRE-KTSUM)/FLOAT(MPRE)
!         IF(IPRINT.EQ.1)WRITE(21,1095)NNPERM,KTSUM, &
!                       NP*NRCALL-NMISS,1.0-XHECK,XHECK,XPRE
         FITS(1)=XHECK
         FITS(2)=XPRE
      ENDIF
!
!  RETURN IF ONE DIMENSION
!
      EXITSTATUS=1
      IF(NS.EQ.1) THEN
        DEALLOCATE(LDATA)
        DEALLOCATE(KAV)
        DEALLOCATE(KAY)
        DEALLOCATE(KAN)
        DEALLOCATE(MCUTS)
        DEALLOCATE(LERROR)
        DEALLOCATE(LLEGERR)
        DEALLOCATE(KCUTTER)
        DEALLOCATE(LCUTTER)
        DEALLOCATE(LLL)
        DEALLOCATE(MDATA)
        DEALLOCATE(ZMAT2)
        DEALLOCATE(WVEC2)
        DEALLOCATE(DSTAR)
        DEALLOCATE(XDATA)
        DEALLOCATE(XXX)
        DEALLOCATE(SSS)
        DEALLOCATE(ZMID)
        DEALLOCATE(DYN)
        DEALLOCATE(XSAVE)
        DEALLOCATE(ZSAVE)
        DEALLOCATE(CSAVE)
        DEALLOCATE(XMAT0)
        DEALLOCATE(XMAT)
        DEALLOCATE(ZVEC)
        DEALLOCATE(WS)
        DEALLOCATE(XONE)
        DEALLOCATE(XPT)
        DEALLOCATE(ZPT)
        DEALLOCATE(XPROJ)
        DEALLOCATE(ZS)
        DEALLOCATE(YRANK)
        DEALLOCATE(FV1)
        RETURN
      ENDIF
!
!  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!    TWO OR MORE DIMENSIONS BELOW
!  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
!
!
!  TRANSFER METRIC SCALING STARTING COORDINATES BACK INTO XMAT0(.,.)
!
      DO 613 I=1,NP
      DO 614 K=1,NS
      XMAT0(I,K)=XDATA(I,K)
  614 CONTINUE
  613 CONTINUE
!
      IFIXX=1
      DO 620 JJJ=1,10
      CALL KPCUTPLANE(JJJ,NP,NRCALL,NS,NDUAL,XMAT0,ZVEC,WS, &
                      MCUTS,LERROR,IFIXX,KTT,KT,LDATA,IPRINT)
!
      CALL KPLEGIS(JJJ,NP,NRCALL,NS,NDUAL,XMAT0,LLEGERR, &
                        ZVEC,WS,MCUTS,LERROR,LTOTAL,MWRONG, &
                        LDATA,IPRINT)
!
  620 CONTINUE
      KTSAVE=KT
!
!  TRANSFER OC COORDINATES TO OUTPUT VECTOR
!
      DO 1849 I=1,NP
      DO 1849 K=1,NS
      IDEALPOINTS(I+(K-1)*NP)=XMAT0(I,K)
 1849 CONTINUE
!
!  CALCULATE VOLUME FOR LEGISLATORS
!
!
      DO 785 I=1,NP
      IX=I
!
      CALL KPVOLUME2(IX,NS,NP,NRCALL,NDUAL,XMAT0,ZVEC,WS,LDATA,BMAX, &
                    KBMAX,IPRINT)
!
      BPER=FLOAT(LLEGERR(I,2)-LLEGERR(I,1))/FLOAT(LLEGERR(I,2))
!      IF(IPRINT.EQ.1)WRITE(25,1096)I,LLEGERR(I,1),LLEGERR(I,2), &
!                                   BPER,BMAX,(XMAT0(I,K),K=1,NS)
      VOLUME(I)=BMAX
!
  785 CONTINUE
!
!  PLACE NORMAL VECTOR IN POSITIVE SIDE OF HYPERSPHERE
!    AND COMPUTE REDUNDANCY CHECK
!
      MPRE=0
      KCHECK4=0
      DO 438 JX=1,NRCALL
      KCUT=MCUTS(JX,1)
      LCUT=MCUTS(JX,2)
!
!  CHECK SIGN HERE
!
      IF(ZVEC(JX,1).LT.0.0)THEN
         DO 995 K=1,NS
         ZVEC(JX,K)=-ZVEC(JX,K)
  995    CONTINUE
         WS(JX)=-WS(JX)
         KCUT=MCUTS(JX,2)
         LCUT=MCUTS(JX,1)
         MCUTS(JX,1)=KCUT
         MCUTS(JX,2)=LCUT
      ENDIF
!
      KSUM=0
      KYES=0
      KNO=0
      KLOW=0
      KHIGH=0
      KYEAYEA=0
      KNAYNAY=0
      KYEANAY=0
      KNAYYEA=0
      DO 439 I=1,NP
      IF(LDATA(I,JX).EQ.1)KYES=KYES+1
      IF(LDATA(I,JX).EQ.6)KNO=KNO+1
      IF(LERROR(I,JX).EQ.1)KSUM=KSUM+1
!
!      CALCULATE PREDICTED MARGIN
!
      SUM=0.0
      DO 994 K=1,NS
      SUM=SUM+XMAT0(I,K)*ZVEC(JX,K)
  994 CONTINUE
      IF(LDATA(I,JX).EQ.0)GO TO 993
      IF(SUM.LE.WS(JX))THEN
!
!  INCORRECT CHOICE
!
         IF(LDATA(I,JX).NE.KCUT)THEN
            KCHECK4=KCHECK4+1
!
!  INCORRECT CHOICE -- VOTED YEA INSTEAD OF NAY
!
            IF(LDATA(I,JX).EQ.1)THEN
               KYEANAY=KYEANAY+1
               CLASSIFY((I-1)*4 + 3)=CLASSIFY((I-1)*4 + 3)+1
            ENDIF
!
!  INCORRECT CHOICE -- VOTED NAY INSTEAD OF YEA
!
            IF(LDATA(I,JX).EQ.6)THEN
               KNAYYEA=KNAYYEA+1
               CLASSIFY((I-1)*4 + 2)=CLASSIFY((I-1)*4 + 2)+1
            ENDIF
         ENDIF
!
!  CORRECT CHOICE -- YEA
!
         IF(LDATA(I,JX).EQ.KCUT.AND.LDATA(I,JX).EQ.1)THEN
            KYEAYEA=KYEAYEA+1
            CLASSIFY((I-1)*4 + 1)=CLASSIFY((I-1)*4 + 1)+1
         ENDIF
!
!  CORRECT CHOICE -- NAY
!
         IF(LDATA(I,JX).EQ.KCUT.AND.LDATA(I,JX).EQ.6)THEN
            KNAYNAY=KNAYNAY+1
            CLASSIFY((I-1)*4 + 4)=CLASSIFY((I-1)*4 + 4)+1
         ENDIF
      ENDIF
      IF(SUM.GT.WS(JX))THEN
         IF(LDATA(I,JX).NE.LCUT)THEN
            KCHECK4=KCHECK4+1
!
!  INCORRECT CHOICE -- VOTED YEA INSTEAD OF NAY
!
            IF(LDATA(I,JX).EQ.1)THEN
               KYEANAY=KYEANAY+1
               CLASSIFY((I-1)*4 + 3)=CLASSIFY((I-1)*4 + 3)+1
            ENDIF
!
!  INCORRECT CHOICE -- VOTED NAY INSTEAD OF YEA
!
            IF(LDATA(I,JX).EQ.6)THEN
               KNAYYEA=KNAYYEA+1
               CLASSIFY((I-1)*4 + 2)=CLASSIFY((I-1)*4 + 2)+1
            ENDIF
         ENDIF
!
!  CORRECT CHOICE -- YEA
!
         IF(LDATA(I,JX).EQ.LCUT.AND.LDATA(I,JX).EQ.1)THEN
            KYEAYEA=KYEAYEA+1
            CLASSIFY((I-1)*4 + 1)=CLASSIFY((I-1)*4 + 1)+1
         ENDIF
!
!  CORRECT CHOICE -- NAY
!
         IF(LDATA(I,JX).EQ.LCUT.AND.LDATA(I,JX).EQ.6)THEN
            KNAYNAY=KNAYNAY+1
            CLASSIFY((I-1)*4 + 4)=CLASSIFY((I-1)*4 + 4)+1
         ENDIF
      ENDIF
  993 CONTINUE
!
      IF(SUM.LT.WS(JX))THEN
         KLOW=KLOW+1
      ENDIF
      IF(SUM.GT.WS(JX))THEN
         KHIGH=KHIGH+1
      ENDIF
  439 CONTINUE
      KYESNO=AMIN0(KYES,KNO)
      MPRE=MPRE+KYESNO
      XCLASS=FLOAT(KYEAYEA+KNAYNAY)/ &
                    FLOAT(KYEAYEA+KNAYNAY+KYEANAY+KNAYYEA)
      XPRE=FLOAT(KYESNO-KSUM)/FLOAT(KYESNO)
!
!      IF(IPRINT.EQ.1)WRITE(25,1097)JX,KAV(JX),KYES,KNO, &
!                      KYEAYEA,KNAYYEA,KYEANAY,KNAYNAY, &
!                      KCUT,LCUT,XCLASS,XPRE,WS(JX), &
!                      (ZVEC(JX,K),K=1,NS)
      CLASSIFY(NP*4 + (JX-1)*4 + 1)=KYEAYEA
      CLASSIFY(NP*4 + (JX-1)*4 + 2)=KNAYYEA
      CLASSIFY(NP*4 + (JX-1)*4 + 3)=KYEANAY
      CLASSIFY(NP*4 + (JX-1)*4 + 4)=KNAYNAY
      MIDPOINTS(JX)=WS(JX)
      DO 440 K=1,NS
      NORMALVECTORS(JX+(K-1)*NRCALL)=ZVEC(JX,K)
  440 CONTINUE
  438 CONTINUE
!
      XERROR=FLOAT(KCHECK4)/FLOAT(KTSAVE)
      YERROR=1.0-XERROR
      XPRE=FLOAT(MPRE-KCHECK4)/FLOAT(MPRE)
!      IF(IPRINT.EQ.1)WRITE(21,1099)NS,KCHECK4,KTSAVE,XERROR,YERROR,XPRE
      FITS(1)=YERROR
      FITS(2)=XPRE
!
      EXITSTATUS=1
      DEALLOCATE(LDATA)
      DEALLOCATE(KAV)
      DEALLOCATE(KAY)
      DEALLOCATE(KAN)
      DEALLOCATE(MCUTS)
      DEALLOCATE(LERROR)
      DEALLOCATE(LLEGERR)
      DEALLOCATE(KCUTTER)
      DEALLOCATE(LCUTTER)
      DEALLOCATE(LLL)
      DEALLOCATE(MDATA)
      DEALLOCATE(ZMAT2)
      DEALLOCATE(WVEC2)
      DEALLOCATE(DSTAR)
      DEALLOCATE(XDATA)
      DEALLOCATE(XXX)
      DEALLOCATE(SSS)
      DEALLOCATE(ZMID)
      DEALLOCATE(DYN)
      DEALLOCATE(XSAVE)
      DEALLOCATE(ZSAVE)
      DEALLOCATE(CSAVE)
      DEALLOCATE(XMAT0)
      DEALLOCATE(XMAT)
      DEALLOCATE(ZVEC)
      DEALLOCATE(WS)
      DEALLOCATE(XONE)
      DEALLOCATE(XPT)
      DEALLOCATE(ZPT)
      DEALLOCATE(XPROJ)
      DEALLOCATE(ZS)
      DEALLOCATE(YRANK)
      DEALLOCATE(FV1)
      RETURN
        END
!
! ****************************************************************************
!  SUBROUTINE KPCLEAN----CALLED BY MAIN.  THROWS OUT ALL ROLLCALLS BELOW A
!     CUTOFF POINT (XVMIN)--USUALLY .05 OR .025.  THROWS OUT ALL LEGISLATORS
!     WHO HAVE VOTED KVMIN TIMES OR LESS (KVMIN=10 USUALLY).  KNAME(,)--
!     CHARACTER ARRAY HOLDING INFORMATION ON LEGISLATORS IS REARRANGED TO
!     HOLD ONLY INCLUDED LEGISLATORS.  LDATA( , ) IS THEN FILLED WITH THE
!     INCLUDED ROLL CALL VOTES.
! ****************************************************************************
!
      SUBROUTINE KPCLEAN(NP,NRCALL,XVMIN,KVMIN,IPRINT,KPTSUM,LDATA, &
                       KAV,KAY,KAN)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION KAV(NRCALL),KAY(NRCALL),KAN(NRCALL),LDATA(NP,NRCALL)   
!
      INTEGER, ALLOCATABLE :: KD(:)
      INTEGER, ALLOCATABLE :: KMARG(:)
      INTEGER, ALLOCATABLE :: KKSUM(:)
      INTEGER, ALLOCATABLE :: LLSUM(:)
      INTEGER, ALLOCATABLE :: MMSUM(:)
      INTEGER, ALLOCATABLE :: NNSUM(:)
      CHARACTER, ALLOCATABLE :: LMARG(:)
      ALLOCATE(KD(NRCALL))
      ALLOCATE(KMARG(50))
      ALLOCATE(KKSUM(NRCALL))
      ALLOCATE(LLSUM(NRCALL))
      ALLOCATE(MMSUM(NP))
      ALLOCATE(NNSUM(NP))
      ALLOCATE(LMARG(10))
!
      DO 34 I=1,NRCALL
      KKSUM(I)=0
      LLSUM(I)=0
  34  CONTINUE
      DO 35 I=1,50
      KMARG(I)=0
  35  CONTINUE
!
      LMARG(1)= '50 - 55   '
      LMARG(2)= '56 - 60   '
      LMARG(3)= '61 - 65   '
      LMARG(4)= '66 - 70   '
      LMARG(5)= '71 - 75   '
      LMARG(6)= '76 - 80   '
      LMARG(7)= '81 - 85   '
      LMARG(8)= '86 - 90   '
      LMARG(9)= '91 - 95   '
      LMARG(10)='96 - 99.5 '
      KPTSUM=0
      NAS=0
      NRS=0
      NOB=0
      NMOB=0
      DO 1 I=1,NP
      ISUM=0
      JSUM=0
      DO 2 J=1,NRCALL
      KD(J)=LDATA(I,J)
      IF(KD(J).EQ.1.OR.KD(J).EQ.2.OR.KD(J).EQ.3)KKSUM(J)=KKSUM(J)+1
      IF(KD(J).EQ.1.OR.KD(J).EQ.2.OR.KD(J).EQ.3)ISUM=ISUM+1
      IF(KD(J).EQ.4.OR.KD(J).EQ.5.OR.KD(J).EQ.6)LLSUM(J)=LLSUM(J)+1
  2   IF(KD(J).EQ.4.OR.KD(J).EQ.5.OR.KD(J).EQ.6)JSUM=JSUM+1
      MMSUM(I)=ISUM
  1   NNSUM(I)=JSUM
      DO 3 I=1,NP
      LL=MMSUM(I)+NNSUM(I)
      IF(LL.GT.KVMIN)NOB=NOB+1
      IF(LL.LE.KVMIN)NMOB=NMOB+1
      IF(LL.LE.KVMIN)GO TO 3
      NAS=0
      NRS=0
      DO 33 J=1,NRCALL
      KD(J)=LDATA(I,J)
      KK=KKSUM(J)+LLSUM(J)
      LL=MIN0(KKSUM(J),LLSUM(J))
      AA=0.0
      IF(KK.GT.0)AA=FLOAT(LL)/FLOAT(KK)
      IF(AA.GT.XVMIN)NAS=NAS+1
      IF(AA.LE.XVMIN)NRS=NRS+1
      IF(AA.GT.XVMIN)KAV(NAS)=J
      IF(AA.GT.XVMIN)KAY(NAS)=KKSUM(J)
      IF(AA.GT.XVMIN)KAN(NAS)=LLSUM(J)
      IF(AA.LE.XVMIN)GO TO 33
      IF(KD(J).EQ.2.OR.KD(J).EQ.3)KD(J)=1
      IF(KD(J).EQ.4.OR.KD(J).EQ.5)KD(J)=6
      IF(KD(J).EQ.7.OR.KD(J).EQ.8.OR.KD(J).EQ.9)KD(J)=0
      LDATA(NOB,NAS)=KD(J)
      IF(KD(J).NE.0)KPTSUM=KPTSUM+1
 33   CONTINUE
  3   CONTINUE
!      IF(IPRINT.EQ.1)WRITE(23,1000)NRCALL,NRS,NAS,XVMIN
! 1000 FORMAT(' ROLL-CALLS READ=',I4,2X,'NUMBER REJECTED=',I4,2X, &
!      'NUMBER ACCEPTED=',I4,2X,'CUTOFF=',F6.3)
!      IF(IPRINT.EQ.1)WRITE(23,1001)NP,NMOB,NOB,KVMIN
! 1001 FORMAT(' LEGISLATORS READ=',I4,2X,'NUMBER REJECTED=',I4,2X, &
!      'NUMBER ACCEPTED=',I4,2X,'CUTOFF=',I4)
      NRCALL=NAS
      NP=NOB
!
!   CALCULATE DISTRIBUTION OF ROLL CALL MARGINS
!
      DO 40 J=1,NRCALL
      KAY(J)=0
      KAN(J)=0
      DO 41 I=1,NP
      IF(LDATA(I,J).EQ.1)KAY(J)=KAY(J)+1
      IF(LDATA(I,J).EQ.6)KAN(J)=KAN(J)+1
  41  CONTINUE
  40  CONTINUE
      LLTOT=0
      LLALL=0
      DO 4 J=1,NRCALL
      LL=MAX0(KAY(J),KAN(J))
      LLTOT=LLTOT+LL
      AA=FLOAT(LL)/FLOAT(KAY(J)+KAN(J))
      LLALL=LLALL+KAY(J)+KAN(J)
      IF(AA.GE..50.AND.AA.LE..55)KMARG(1)=KMARG(1)+1
      IF(AA.GT..55.AND.AA.LE..60)KMARG(2)=KMARG(2)+1
      IF(AA.GT..60.AND.AA.LE..65)KMARG(3)=KMARG(3)+1
      IF(AA.GT..65.AND.AA.LE..70)KMARG(4)=KMARG(4)+1
      IF(AA.GT..70.AND.AA.LE..75)KMARG(5)=KMARG(5)+1
      IF(AA.GT..75.AND.AA.LE..80)KMARG(6)=KMARG(6)+1
      IF(AA.GT..80.AND.AA.LE..85)KMARG(7)=KMARG(7)+1
      IF(AA.GT..85.AND.AA.LE..90)KMARG(8)=KMARG(8)+1
      IF(AA.GT..90.AND.AA.LE..95)KMARG(9)=KMARG(9)+1
      IF(AA.GT..95.AND.AA.LE..995)KMARG(10)=KMARG(10)+1
  4   CONTINUE
!      IF(IPRINT.EQ.1)WRITE(23,1003)
! 1003 FORMAT('  DISTRIBUTION OF SCALABLE ROLL CALLS')
      DO 5 I=1,10
      AA=FLOAT(KMARG(I))/FLOAT(NRCALL)
!      IF(IPRINT.EQ.1)WRITE(23,1002)I,LMARG(I),KMARG(I),AA
  5   CONTINUE
! 1002 FORMAT(I4,1X,A10,I5,F7.3)
      XSUM=FLOAT(LLTOT)/FLOAT(LLALL)
!      IF(IPRINT.EQ.1)WRITE(23,1004)LLTOT,LLALL,XSUM
! 1004 FORMAT(' AVERAGE MAJORITY MARGIN= ',2I8,F9.5)
      DEALLOCATE(KD)
      DEALLOCATE(KMARG)
      DEALLOCATE(KKSUM)
      DEALLOCATE(LLSUM)
      DEALLOCATE(MMSUM)
      DEALLOCATE(NNSUM)
      DEALLOCATE(LMARG)
      RETURN
      END
!
! **************************************************************************
!
!  SUBROUTINE KPASCORE -- PERFORMS EIGENVALUE-EIGENVECTOR DECOMPOSITION OF
!                       THE MATRIX OF LEGISLATOR BY LEGISLATOR AGREEMENT
!                       SCORES
!
! **************************************************************************
!
      SUBROUTINE KPASCORE(NP,NRCALL,NS,NDUAL,KIO,IPRINT, &
                        ZMAT2,WVEC2,DSTAR,LDATA)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION WVEC2(NP),ZMAT2(NP,NP),DSTAR(NP,NP),LDATA(NP,NRCALL)
!
      DOUBLE PRECISION, ALLOCATABLE :: XCOL(:)
      DOUBLE PRECISION, ALLOCATABLE :: XROW(:)
      INTEGER, ALLOCATABLE :: KROW(:)
      DOUBLE PRECISION, ALLOCATABLE :: FV1(:)
      DOUBLE PRECISION, ALLOCATABLE :: FV2(:)
      DOUBLE PRECISION, ALLOCATABLE :: XAGREE(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ROWMEAN(:)
      DOUBLE PRECISION, ALLOCATABLE :: YCENTER(:,:)
      ALLOCATE(XCOL(NRCALL))
      ALLOCATE(XROW(NP))
      ALLOCATE(KROW(NP))
      ALLOCATE(FV1(NP))
      ALLOCATE(FV2(NP))
      ALLOCATE(XAGREE(NP,NP))
      ALLOCATE(ROWMEAN(NP))
      ALLOCATE(YCENTER(NP,NP))
!
!  101 FORMAT(' PERFORMANCE INDEX EIGENVALUE/VECTOR ROUTINE=' &
!             ,3I5,I6)
!  102 FORMAT(I4,9F10.4)
! 1000 FORMAT(3F10.4)
      CALL ECHOEVENT(9)
      CALL FLUSHCON()
      CALL PROCEVENT()
      DO 3 I=1,NRCALL
      XCOL(I)=0.0
  3   CONTINUE
      DO 30 I=1,NP
      XROW(I)=0.0
      KROW(I)=0
      ROWMEAN(I)=0.0
  30  CONTINUE
!
!  PERFORM THE PSEUDO-DOUBLE CENTER
!
!  CALCULATE THE ROLL CALL MEANS (#YEAS/#VOTING)
!
      XMAT=0.0
      KMAT=0
      XCHK1=0.0
      DO 1 J=1,NRCALL
      SUM=0.0
      KK=0
      DO 2 I=1,NP
      IF(LDATA(I,J).NE.0)THEN
         KK=KK+1
         KROW(I)=KROW(I)+1
      ENDIF
      IF(LDATA(I,J).EQ.1)THEN
         SUM=SUM+1.0
         XROW(I)=XROW(I)+1.0
      ENDIF
  2   CONTINUE
      XMAT=XMAT+SUM
      KMAT=KMAT+KK
      XCOL(J)=SUM/FLOAT(KK)
      XCHK1=XCHK1+XCOL(J)
  1   CONTINUE
      XCHK2=0.0
      DO 4 I=1,NP
      XROW(I)=XROW(I)/FLOAT(KROW(I))
      XCHK2=XCHK2+XROW(I)
  4   CONTINUE
!
!  MATRIX MEAN
!
      XCHK1=XCHK1/FLOAT(NRCALL)
      XCHK2=XCHK2/FLOAT(NP)
      XMAT=XMAT/FLOAT(KMAT)
!      IF(IPRINT.EQ.1)WRITE(23,1000)XCHK1,XCHK2,XMAT
!
!  COMPUTE HECKMAN-SNYDER COVARIANCE MATRIX
!
      ALLMEAN=0.0
      KZERO=0
      DO 7 I=1,NP
      RSUM=0.0
      DO 8 J=1,NP
      SUM=0.0
      KK=0
      KKK=0
      DO 9 K=1,NRCALL
      IF(LDATA(I,K).EQ.0)GO TO 9
      IF(LDATA(J,K).EQ.0)GO TO 9
      KK=KK+1
!
!  SET UP SYMMETRIC MATRIX OF AGREEMENT SCORES
!
      IF(LDATA(I,K).EQ.LDATA(J,K))THEN
         KKK=KKK+1
      ENDIF
  9   CONTINUE
      IF(KK.EQ.0)THEN
         XAGREE(I,J)=0.25
         DSTAR(I,J)=1.0
         GO TO 88
      ENDIF
      XAGREE(I,J)=(1.0 - (FLOAT(KKK)/FLOAT(KK)))**2
      DSTAR(I,J)=(100.0 - (FLOAT(KKK)/FLOAT(KK))*100.0)/50.0
  88  CONTINUE
      RSUM=RSUM+XAGREE(I,J)
  8   CONTINUE
      ROWMEAN(I)=RSUM/FLOAT(NP)
      ALLMEAN=ALLMEAN+ROWMEAN(I)
  7   CONTINUE
      ALLMEAN=ALLMEAN/FLOAT(NP)
!
!  SETUP DOUBLE-CENTERED AGREEMENT SCORE MATRIX
!
      DO 33 I=1,NP
      DO 34 J=1,NP
      YCENTER(I,J)=(XAGREE(I,J)-ROWMEAN(I)-ROWMEAN(J)+ALLMEAN)/(-2.0)
  34  CONTINUE
  33  CONTINUE
!
!
!  EIGENVECTOR-EIGENVALUE DECOMPOSITION DOUBLE-CENTERED AGREEMENT
!     SCORE MATRIX
!
      CALL KPRS(NP,NP,YCENTER,WVEC2,1,ZMAT2,FV1,FV2,IER)
!      IF(IPRINT.EQ.1)WRITE(23,101)NS,NP,IER,KZERO
      SUM2=0.0
      DO 20 I=1,NP
      SUM2=SUM2+ABS(WVEC2(I))
  20  CONTINUE
      YPER2=0.0
      IZULU=MIN(NP,20)
      DO 10 I=1,IZULU
      XPER2=(ABS(WVEC2(NP+1-I))/SUM2)*100.0
      YPER2=YPER2+XPER2
!      IF(IPRINT.EQ.1)WRITE(23,102)I,WVEC2(NP+1-I),XPER2,YPER2
  10  CONTINUE
      DEALLOCATE(XCOL)
      DEALLOCATE(XROW)
      DEALLOCATE(KROW)
      DEALLOCATE(FV1)
      DEALLOCATE(FV2)
      DEALLOCATE(XAGREE)
      DEALLOCATE(ROWMEAN)
      DEALLOCATE(YCENTER)
      RETURN
      END
!
!
!  *************************************************************************
!   SUBROUTINE KPWHOOPE---IMPLEMENTS THE CONDITIONAL GLOBAL MINIMUM ALGORITHM
!   DEVELOPED BY POOLE, "LEAST SQUARES METRIC, UNIDIMENSIONAL UNFOLDING,"
!   PSYCHOMETRIKA, 1984.
!  *************************************************************************
!
!
      SUBROUTINE KPWHOOPE(NP,NS,DSTAR,ZZZ,XX,SSE1,SSE2,KTP,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION DSTAR(NP,NP),ZZZ(NP),XX(NP,25)
      DOUBLE PRECISION SUM
!
      DOUBLE PRECISION, ALLOCATABLE :: DAT(:)
      DOUBLE PRECISION, ALLOCATABLE :: SAVEZ(:)
      DOUBLE PRECISION, ALLOCATABLE :: SAVED(:)
      DOUBLE PRECISION, ALLOCATABLE :: XXXX(:,:)
      ALLOCATE(SAVEZ(NP))
      ALLOCATE(SAVED(NP))
      ALLOCATE(XXXX(NP,25))
      ALLOCATE(DAT(20))
!
!  100 FORMAT(I4,3F12.5,I8)
      KTP=1
      NPQ=NP-1
      CALL STATKP(NP,NS,DSTAR,ZZZ,XX,SSE1,RRSQ,KK)
      DAT(1)=SSE1
      II=0
      AKKK=0.0
!      IF(IPRINT.EQ.1)WRITE(23,100)II,SSE1,RRSQ,AKKK,KK
      IF(SSE1.LE.0.001)SSE2=0.0
      IF(SSE1.LE.0.001) THEN
        DEALLOCATE(SAVEZ)
        DEALLOCATE(SAVED)
        DEALLOCATE(XXXX)
        DEALLOCATE(DAT)      
        RETURN
      ENDIF
      DO 99 II=1,10
      KTP=II
      DO 98 J=1,NP
      NPJ=J
      KK=0
      DO 918 JJ=1,NP
      IF(JJ.EQ.NPJ)GO TO 918
      KK=KK+1
      DO 919 K=1,NS
      XXXX(KK,K)=XX(JJ,K)
  919 CONTINUE
      SAVEZ(KK)=ZZZ(JJ)
      SAVED(KK)=DSTAR(NPJ,JJ)
  918 CONTINUE
      IF(NS.EQ.1)CALL KPFOCUSW(NP,NPQ,NPJ,SAVED,SAVEZ,ZZZ)
      IF(NS.GT.1)CALL KPFOCUS(NP,NPQ,NS,NPJ,SAVED,XX,XXXX)
  98  CONTINUE
      CALL STATKP(NP,NS,DSTAR,ZZZ,XX,SSE2,RRSQ,KK)
      DAT(II+1)=SSE2
      IF(SSE2.EQ.0.0)GO TO 9998
      AKKK=(DAT(II)-DAT(II+1))/DAT(II)
!      IF(IPRINT.EQ.1)WRITE(23,100)II,SSE2,RRSQ,AKKK,KK
      IF(AKKK.LE..001)GO TO 9998
  99  CONTINUE
 9998 CONTINUE
      SUM=0.0
      DO 1 I=1,NP
  1   SUM=SUM+ZZZ(I)
      DO 2 I=1,NP
  2   ZZZ(I)=ZZZ(I)-(SUM/FLOAT(NP))
      DEALLOCATE(SAVEZ)
      DEALLOCATE(SAVED)
      DEALLOCATE(XXXX)
      DEALLOCATE(DAT)
      RETURN
      END
!
!
!  *********************************************************************
!    SUBROUTINE KPFOCUSW---PERFORMS LEAST SQUARES METRIC SIMILARITIES
!    ANALYSIS USING THE CONDITIONAL GLOBAL MINIMUM ALGORITHM
!  *********************************************************************
!
!
      SUBROUTINE KPFOCUSW(NPT,NP,II,D,X,Z)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION D(NPT),X(NPT),Z(NPT)
!
      INTEGER, ALLOCATABLE :: LL(:)
      DOUBLE PRECISION, ALLOCATABLE :: Q(:)
      DOUBLE PRECISION, ALLOCATABLE :: XX(:,:)      
      ALLOCATE ( LL(NPT) )
      ALLOCATE ( Q(NPT) )
      ALLOCATE ( XX(NPT,2) )
!
      DO 303 I=1,NP
      LL(I)=I
  303 Q(I)=X(I)
      CALL KPRSORT(Q,NP,LL)
      ASUM=0.0
      BSUM=0.0
      WWSUM=0.0
      DO 66 I=1,NP
      IF(D(LL(I)).EQ.99.0)GO TO 66
      XX(I,1)=Q(I)-D(LL(I))
      XX(I,2)=Q(I)+D(LL(I))
      WWSUM=WWSUM+1.0
      ASUM=ASUM+XX(I,1)
      BSUM=BSUM+XX(I,1)**2
  66  CONTINUE
      AA=WWSUM*BSUM-ASUM*ASUM
      KK=1
      DO 77 I=1,NP
      IF(D(LL(I)).EQ.99.0)GO TO 77
      ASUM=ASUM-XX(I,1)+XX(I,2)
      BSUM=BSUM-XX(I,1)**2+XX(I,2)**2
      BB=WWSUM*BSUM-ASUM*ASUM
      CC=AMIN1(AA,BB)
      IF(ABS(CC-AA).LE..00001.AND.KK.GT.1)GO TO 88
      IF(ABS(CC-AA).LE..00001.AND.KK.EQ.1)Z(II)= &
                           (ASUM+XX(I,1)-XX(I,2))/WWSUM
      IF(ABS(CC-BB).LE..00001)Z(II)=ASUM/WWSUM
  88  AA=CC
      KK=KK+1
  77  CONTINUE
      DEALLOCATE (LL)
      DEALLOCATE (Q)
      DEALLOCATE (XX)
      RETURN
      END
!
!
!
!  **********************************************************************
!     SUBROUTINE STATKP--COMPUTES THE SUM OF SQUARED ERROR BETWEEN THE
!         THE INPUT DISTANCE MATRIX AND THE CURRENT DISTANCE MATRIX.
!  **********************************************************************
!
!
      SUBROUTINE STATKP(NP,NS,DSTAR,ZZZ,XX,SSE,RRSQ,KK)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION DSTAR(NP,NP),ZZZ(NP),XX(NP,25)
!
!  100 FORMAT(2I5)
!  125 FORMAT(I4,10F7.3)
      SSE=0.0
      ASUM=0.0
      BSUM=0.0
      CSUM=0.0
      DSUM=0.0
      ESUM=0.0
      KK=0
      DO 1 I=1,NP
      DO 2 J=1,I
      IF(I.EQ.J)GO TO 2
      IF(DSTAR(I,J).EQ.99.0)GO TO 2
      KK=KK+1
      IF(NS.EQ.1)AA=ABS(ZZZ(I)-ZZZ(J))
      IF(NS.EQ.1)GO TO 10
      SSUMS=0.0
      DO 11 K=1,NS
  11  SSUMS=SSUMS+(XX(I,K)-XX(J,K))**2
      SSUMS=SQRT(SSUMS)
      AA=SSUMS
  10  CONTINUE
      ASUM=ASUM+AA
      BSUM=BSUM+DSTAR(I,J)
      CSUM=CSUM+AA*AA
      DSUM=DSUM+DSTAR(I,J)**2
      ESUM=ESUM+AA*DSTAR(I,J)
      SSE=SSE+(DSTAR(I,J)-AA)**2
  2   CONTINUE
  1   CONTINUE
      AA=FLOAT(KK)*ESUM-ASUM*BSUM
      BB=FLOAT(KK)*CSUM-ASUM*ASUM
      CC=FLOAT(KK)*DSUM-BSUM*BSUM
      RRSQ=(AA*AA)/(BB*CC)
      RETURN
      END
!
!
!  *********************************************************************
!    SUBROUTINE KPFOCUS IS A QUASI-GRADIENT ALGORITHM.  IT COMPUTES THE
!    COORDINATES
!  *********************************************************************
!
!
      SUBROUTINE KPFOCUS(NP,NPQ,NS,II,D,XX,XXXX)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION D(NP),XX(NP,25),XXXX(NP,25),ZZZ(100)
      DO 2 J=1,NS
      ZZZ(J)=0.0
  2   CONTINUE
      KK=0
      DO 4 J=1,NPQ
      IF(D(J).EQ.99.0)GO TO 4
      KK=KK+1
      SUM=0.0
      DO 7 K=1,NS
  7   SUM=SUM+(XXXX(J,K)-XX(II,K))**2
      IF(SUM.LE..00001)THEN
         XC=1.0
         GO TO 52
      ENDIF
      XC=D(J)/SQRT(SUM)
  52  CONTINUE
      DO 8 K=1,NS
  8   ZZZ(K)=ZZZ(K)+XXXX(J,K)+XC*(XX(II,K)-XXXX(J,K))
  4   CONTINUE
!      IF(KK.EQ.0)WRITE(23,310)II
      IF(KK.EQ.0)STOP
!  310 FORMAT(' THIS IS YOUR PROBLEM STUPID!!!',I6)
      DO 1 K=1,NS
  1   XX(II,K)=ZZZ(K)/FLOAT(KK)
      RETURN
      END
!
!
!
!  ************************************************************************
!    SUBROUTINE KPRSORT --SORTS A VECTOR 'A' OF REAL ELEMENTS INTO ASCENDING
!    ORDER.  'LA' IS THE NUMBER OF ELEMENTS TO BE SORTED AND 'IR' IS A
!    VECTOR OF INTEGERS THAT RECORDS THE PERMUTATIONS--USUALLY SET TO
!    1,2,3,4,...
!  ************************************************************************
!
!
      SUBROUTINE KPRSORT(A,LA,IR)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION A(LA),IU(21),IL(21),IR(LA)
      IF (LA.LE.0) RETURN
      M = 1
      I = 1
      J = LA
      R = .375
    5 IF (I.EQ.J) GO TO 45
      IF (R.GT..5898437) GO TO 10
      R = R+3.90625E-2
      GO TO 15
   10 R = R-.21875
   15 K = I
!
! SELECT A CENTRAL ELEMENT OF THE
! ARRAY AND SAVE IT IN LOCATION T
!
      IJ = I+(J-I)*R
      T = A(IJ)
      IT = IR(IJ)
!
! FIRST ELEMENT OF ARRAY IS GREATER
! THAN T, INTERCHANGE WITH T
!
      IF (A(I).LE.T) GO TO 20
      A(IJ) = A(I)
      A(I) = T
      T = A(IJ)
      IR(IJ) = IR(I)
      IR(I) = IT
      IT = IR(IJ)
   20 L = J
!
! IF LAST ELEMENT OF ARRAY IS LESS THAN
! T, INTERCHANGE WITH T
!
      IF (A(J).GE.T) GO TO 30
      A(IJ) = A(J)
      A(J) = T
      T = A(IJ)
      IR(IJ) = IR(J)
      IR(J) = IT
      IT = IR(IJ)
!
! IF FIRST ELEMENT OF ARRAY IS GREATER
! THAN T, INTERCHANGE WITH T
!
      IF (A(I).LE.T) GO TO 30
      A(IJ) = A(I)
      A(I) = T
      T = A(IJ)
      IR(IJ) = IR(I)
      IR(I) = IT
      IT = IR(IJ)
      GO TO 30
   25 IF (A(L).EQ.A(K)) GO TO 30
      TT = A(L)
      A(L) = A(K)
      A(K) = TT
      ITT = IR(L)
      IR(L) = IR(K)
      IR(K) = ITT
!
! FIND AN ELEMENT IN THE SECOND HALF OF
! THE ARRAY WHICH IS SMALLER THAN T
!
   30 L = L-1
      IF (A(L).GT.T) GO TO 30
!
! FIND AN ELEMENT IN THE FIRST HALF OF
! THE ARRAY WHICH IS GREATER THAN T
!
   35 K = K+1
      IF (A(K).LT.T) GO TO 35
!
! INTERCHANGE THESE ELEMENTS
!
      IF (K.LE.L) GO TO 25
!
! SAVE UPPER AND LOWER SUBSCRIPTS OF
! THE ARRAY YET TO BE SORTED
!
      IF (L-I.LE.J-K) GO TO 40
      IL(M) = I
      IU(M) = L
      I = K
      M = M+1
      GO TO 50
   40 IL(M) = K
      IU(M) = J
      J = L
      M = M+1
      GO TO 50
!
! BEGIN AGAIN ON ANOTHER PORTION OF
! THE UNSORTED ARRAY
!
   45 M = M-1
      IF (M.EQ.0) RETURN
      I = IL(M)
      J = IU(M)
   50 IF (J-I.GE.11) GO TO 15
      IF (I.EQ.1) GO TO 5
      I = I-1
   55 I = I+1
      IF (I.EQ.J) GO TO 45
      T = A(I+1)
      IT = IR(I+1)
      IF (A(I).LE.T) GO TO 55
      K = I
   60 A(K+1) = A(K)
      IR(K+1) = IR(K)
      K = K-1
      IF (T.LT.A(K)) GO TO 60
      A(K+1) = T
      IR(K+1) = IT
      GO TO 55
      END
!
!
!  **************************************************************************
!    EIGENVECTOR/EIGENVALUE DECOMPOSITION SUBROUTINES FOR A SYMMETRIC MATRIX
!    SUBROUTINES ARE FROM EISPACK
!  **************************************************************************
!
      SUBROUTINE KPRS(NM,N,A,W,MATZ,Z,FV1,FV2,IERR)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
!
      INTEGER N,NM,IERR,MATZ
      DOUBLE PRECISION A(NM,N),W(N),Z(NM,N),FV1(N),FV2(N)
!
!     THIS SUBROUTINE CALLS THE RECOMMENDED SEQUENCE OF
!     SUBROUTINES FROM THE EIGENSYSTEM SUBROUTINE PACKAGE (EISPACK)
!     TO FIND THE EIGENVALUES AND EIGENVECTORS (IF DESIRED)
!     OF A REAL SYMMETRIC MATRIX.
!
!     ON INPUT
!
!        NM  MUST BE SET TO THE ROW DIMENSION OF THE TWO-DIMENSIONAL
!        ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
!        DIMENSION STATEMENT.
!
!        N  IS THE ORDER OF THE MATRIX  A.
!
!        A  CONTAINS THE REAL SYMMETRIC MATRIX.
!
!        MATZ  IS AN INTEGER VARIABLE SET EQUAL TO ZERO IF
!        ONLY EIGENVALUES ARE DESIRED.  OTHERWISE IT IS SET TO
!        ANY NON-ZERO INTEGER FOR BOTH EIGENVALUES AND EIGENVECTORS.
!
!     ON OUTPUT
!
!        W  CONTAINS THE EIGENVALUES IN ASCENDING ORDER.
!
!        Z  CONTAINS THE EIGENVECTORS IF MATZ IS NOT ZERO.
!
!        IERR  IS AN INTEGER OUTPUT VARIABLE SET EQUAL TO AN ERROR
!           COMPLETION CODE DESCRIBED IN THE DOCUMENTATION FOR KPTQLRAT
!           AND KPTQL2.  THE NORMAL COMPLETION CODE IS ZERO.
!
!        FV1  AND  FV2  ARE TEMPORARY STORAGE ARRAYS.
!
!     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
!     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
!
!     THIS VERSION DATED AUGUST 1983.
!
!     ------------------------------------------------------------------
!
      IF (N .LE. NM) GO TO 10
      IERR = 10 * N
      GO TO 50
!
   10 IF (MATZ .NE. 0) GO TO 20
!     .......... FIND EIGENVALUES ONLY ..........
      CALL  KPTRED1(NM,N,A,W,FV1,FV2)
      CALL  KPTQLRAT(N,W,FV2,IERR)
      GO TO 50
!     .......... FIND BOTH EIGENVALUES AND EIGENVECTORS ..........
   20 CALL  KPTRED2(NM,N,A,W,FV1,Z)
      CALL  KPTQL2(NM,N,W,FV1,Z,IERR)
   50 RETURN
      END
!
!
      SUBROUTINE KPTRED1(NM,N,A,D,E,E2)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
!
      INTEGER I,J,K,L,N,II,NM,JP1
      DOUBLE PRECISION A(NM,N),D(N),E(N),E2(N)
      DOUBLE PRECISION F,G,H,SCALE
!
!     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE TRED1,
!     NUM. MATH. 11, 181-195(1968) BY MARTIN, REINSCH, AND WILKINSON.
!     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 212-226(1971).
!
!     THIS SUBROUTINE REDUCES A REAL SYMMETRIC MATRIX
!     TO A SYMMETRIC TRIDIAGONAL MATRIX USING
!     ORTHOGONAL SIMILARITY TRANSFORMATIONS.
!
!     ON INPUT
!
!        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
!          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
!          DIMENSION STATEMENT.
!
!        N IS THE ORDER OF THE MATRIX.
!
!        A CONTAINS THE REAL SYMMETRIC INPUT MATRIX.  ONLY THE
!          LOWER TRIANGLE OF THE MATRIX NEED BE SUPPLIED.
!
!     ON OUTPUT
!
!        A CONTAINS INFORMATION ABOUT THE ORTHOGONAL TRANS-
!          FORMATIONS USED IN THE REDUCTION IN ITS STRICT LOWER
!          TRIANGLE.  THE FULL UPPER TRIANGLE OF A IS UNALTERED.
!
!        D CONTAINS THE DIAGONAL ELEMENTS OF THE TRIDIAGONAL MATRIX.
!
!        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE TRIDIAGONAL
!          MATRIX IN ITS LAST N-1 POSITIONS.  E(1) IS SET TO ZERO.
!
!        E2 CONTAINS THE SQUARES OF THE CORRESPONDING ELEMENTS OF E.
!          E2 MAY COINCIDE WITH E IF THE SQUARES ARE NOT NEEDED.
!
!     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
!     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
!
!     THIS VERSION DATED AUGUST 1983.
!
!     ------------------------------------------------------------------
!
      DO 100 I = 1, N
         D(I) = A(N,I)
         A(N,I) = A(I,I)
  100 CONTINUE
!     .......... FOR I=N STEP -1 UNTIL 1 DO -- ..........
      DO 300 II = 1, N
         I = N + 1 - II
         L = I - 1
         H = 0.0E0
         SCALE = 0.0E0
         IF (L .LT. 1) GO TO 130
!     .......... SCALE ROW (ALGOL TOL THEN NOT NEEDED) ..........
         DO 120 K = 1, L
  120    SCALE = SCALE + ABS(D(K))
!
         IF (SCALE .NE. 0.0E0) GO TO 140
!
         DO 125 J = 1, L
            D(J) = A(L,J)
            A(L,J) = A(I,J)
            A(I,J) = 0.0E0
  125    CONTINUE
!
  130    E(I) = 0.0E0
         E2(I) = 0.0E0
         GO TO 300
!
  140    DO 150 K = 1, L
            D(K) = D(K) / SCALE
            H = H + D(K) * D(K)
  150    CONTINUE
!
         E2(I) = SCALE * SCALE * H
         F = D(L)
         G = -SIGN(SQRT(H),F)
         E(I) = SCALE * G
         H = H - F * G
         D(L) = F - G
         IF (L .EQ. 1) GO TO 285
!     .......... FORM A*U ..........
         DO 170 J = 1, L
  170    E(J) = 0.0E0
!
         DO 240 J = 1, L
            F = D(J)
            G = E(J) + A(J,J) * F
            JP1 = J + 1
            IF (L .LT. JP1) GO TO 220
!
            DO 200 K = JP1, L
               G = G + A(K,J) * D(K)
               E(K) = E(K) + A(K,J) * F
  200       CONTINUE
!
  220       E(J) = G
  240    CONTINUE
!     .......... FORM P ..........
         F = 0.0E0
!
         DO 245 J = 1, L
            E(J) = E(J) / H
            F = F + E(J) * D(J)
  245    CONTINUE
!
         H = F / (H + H)
!     .......... FORM Q ..........
         DO 250 J = 1, L
  250    E(J) = E(J) - H * D(J)
!     .......... FORM REDUCED A ..........
         DO 280 J = 1, L
            F = D(J)
            G = E(J)
!
            DO 260 K = J, L
  260       A(K,J) = A(K,J) - F * E(K) - G * D(K)
!
  280    CONTINUE
!
  285    DO 290 J = 1, L
            F = D(J)
            D(J) = A(L,J)
            A(L,J) = A(I,J)
            A(I,J) = F * SCALE
  290    CONTINUE
!
  300 CONTINUE
!
      RETURN
      END
!
!
      SUBROUTINE KPTRED2(NM,N,A,D,E,Z)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
!
      INTEGER I,J,K,L,N,II,NM,JP1
      DOUBLE PRECISION A(NM,N),D(N),E(N),Z(NM,N)
      DOUBLE PRECISION F,G,H,HH,SCALE
!
!     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE TRED2,
!     NUM. MATH. 11, 181-195(1968) BY MARTIN, REINSCH, AND WILKINSON.
!     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 212-226(1971).
!
!     THIS SUBROUTINE REDUCES A REAL SYMMETRIC MATRIX TO A
!     SYMMETRIC TRIDIAGONAL MATRIX USING AND ACCUMULATING
!     ORTHOGONAL SIMILARITY TRANSFORMATIONS.
!
!     ON INPUT
!
!        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
!          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
!          DIMENSION STATEMENT.
!
!        N IS THE ORDER OF THE MATRIX.
!
!        A CONTAINS THE REAL SYMMETRIC INPUT MATRIX.  ONLY THE
!          LOWER TRIANGLE OF THE MATRIX NEED BE SUPPLIED.
!
!     ON OUTPUT
!
!        D CONTAINS THE DIAGONAL ELEMENTS OF THE TRIDIAGONAL MATRIX.
!
!        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE TRIDIAGONAL
!          MATRIX IN ITS LAST N-1 POSITIONS.  E(1) IS SET TO ZERO.
!
!        Z CONTAINS THE ORTHOGONAL TRANSFORMATION MATRIX
!          PRODUCED IN THE REDUCTION.
!
!        A AND Z MAY COINCIDE.  IF DISTINCT, A IS UNALTERED.
!
!     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
!     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
!
!     THIS VERSION DATED AUGUST 1983.
!
!     ------------------------------------------------------------------
!
      DO 100 I = 1, N
!
         DO 80 J = I, N
   80    Z(J,I) = A(J,I)
!
         D(I) = A(N,I)
  100 CONTINUE
!
      IF (N .EQ. 1) GO TO 510
!     .......... FOR I=N STEP -1 UNTIL 2 DO -- ..........
      DO 300 II = 2, N
         I = N + 2 - II
         L = I - 1
         H = 0.0E0
         SCALE = 0.0E0
         IF (L .LT. 2) GO TO 130
!     .......... SCALE ROW (ALGOL TOL THEN NOT NEEDED) ..........
         DO 120 K = 1, L
  120    SCALE = SCALE + ABS(D(K))
!
         IF (SCALE .NE. 0.0E0) GO TO 140
  130    E(I) = D(L)
!
         DO 135 J = 1, L
            D(J) = Z(L,J)
            Z(I,J) = 0.0E0
            Z(J,I) = 0.0E0
  135    CONTINUE
!
         GO TO 290
!
  140    DO 150 K = 1, L
            D(K) = D(K) / SCALE
            H = H + D(K) * D(K)
  150    CONTINUE
!
         F = D(L)
         G = -SIGN(SQRT(H),F)
         E(I) = SCALE * G
         H = H - F * G
         D(L) = F - G
!     .......... FORM A*U ..........
         DO 170 J = 1, L
  170    E(J) = 0.0E0
!
         DO 240 J = 1, L
            F = D(J)
            Z(J,I) = F
            G = E(J) + Z(J,J) * F
            JP1 = J + 1
            IF (L .LT. JP1) GO TO 220
!
            DO 200 K = JP1, L
               G = G + Z(K,J) * D(K)
               E(K) = E(K) + Z(K,J) * F
  200       CONTINUE
!
  220       E(J) = G
  240    CONTINUE
!     .......... FORM P ..........
         F = 0.0E0
!
         DO 245 J = 1, L
            E(J) = E(J) / H
            F = F + E(J) * D(J)
  245    CONTINUE
!
         HH = F / (H + H)
!     .......... FORM Q ..........
         DO 250 J = 1, L
  250    E(J) = E(J) - HH * D(J)
!     .......... FORM REDUCED A ..........
         DO 280 J = 1, L
            F = D(J)
            G = E(J)
!
            DO 260 K = J, L
  260       Z(K,J) = Z(K,J) - F * E(K) - G * D(K)
!
            D(J) = Z(L,J)
            Z(I,J) = 0.0E0
  280    CONTINUE
!
  290    D(I) = H
  300 CONTINUE
!     .......... ACCUMULATION OF TRANSFORMATION MATRICES ..........
      DO 500 I = 2, N
         L = I - 1
         Z(N,L) = Z(L,L)
         Z(L,L) = 1.0E0
         H = D(I)
         IF (H .EQ. 0.0E0) GO TO 380
!
         DO 330 K = 1, L
  330    D(K) = Z(K,I) / H
!
         DO 360 J = 1, L
            G = 0.0E0
!
            DO 340 K = 1, L
  340       G = G + Z(K,I) * Z(K,J)
!
            DO 360 K = 1, L
               Z(K,J) = Z(K,J) - G * D(K)
  360    CONTINUE
!
  380    DO 400 K = 1, L
  400    Z(K,I) = 0.0E0
!
  500 CONTINUE
!
  510 DO 520 I = 1, N
         D(I) = Z(N,I)
         Z(N,I) = 0.0E0
  520 CONTINUE
!
      Z(N,N) = 1.0E0
      E(1) = 0.0E0
      RETURN
      END
!
!
      SUBROUTINE KPTQL2(NM,N,D,E,Z,IERR)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
!
      INTEGER I,J,K,L,M,N,II,L1,L2,NM,MML,IERR
      DOUBLE PRECISION D(N),E(N),Z(NM,N)
      DOUBLE PRECISION C,C2,C3,DL1,EL1,F,G,H,P,R,S,S2,TST1, &
        TST2,PYTHAG
!
!     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE TQL2,
!     NUM. MATH. 11, 293-306(1968) BY BOWDLER, MARTIN, REINSCH, AND
!     WILKINSON.
!     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 227-240(1971).
!
!     THIS SUBROUTINE FINDS THE EIGENVALUES AND EIGENVECTORS
!     OF A SYMMETRIC TRIDIAGONAL MATRIX BY THE QL METHOD.
!     THE EIGENVECTORS OF A FULL SYMMETRIC MATRIX CAN ALSO
!     BE FOUND IF  KPTRED2  HAS BEEN USED TO REDUCE THIS
!     FULL MATRIX TO TRIDIAGONAL FORM.
!
!     ON INPUT
!
!        NM MUST BE SET TO THE ROW DIMENSION OF TWO-DIMENSIONAL
!          ARRAY PARAMETERS AS DECLARED IN THE CALLING PROGRAM
!          DIMENSION STATEMENT.
!
!        N IS THE ORDER OF THE MATRIX.
!
!        D CONTAINS THE DIAGONAL ELEMENTS OF THE INPUT MATRIX.
!
!        E CONTAINS THE SUBDIAGONAL ELEMENTS OF THE INPUT MATRIX
!          IN ITS LAST N-1 POSITIONS.  E(1) IS ARBITRARY.
!
!        Z CONTAINS THE TRANSFORMATION MATRIX PRODUCED IN THE
!          REDUCTION BY  KPTRED2, IF PERFORMED.  IF THE EIGENVECTORS
!          OF THE TRIDIAGONAL MATRIX ARE DESIRED, Z MUST CONTAIN
!          THE IDENTITY MATRIX.
!
!      ON OUTPUT
!
!        D CONTAINS THE EIGENVALUES IN ASCENDING ORDER.  IF AN
!          ERROR EXIT IS MADE, THE EIGENVALUES ARE CORRECT BUT
!          UNORDERED FOR INDICES 1,2,...,IERR-1.
!
!        E HAS BEEN DESTROYED.
!
!        Z CONTAINS ORTHONORMAL EIGENVECTORS OF THE SYMMETRIC
!          TRIDIAGONAL (OR FULL) MATRIX.  IF AN ERROR EXIT IS MADE,
!          Z CONTAINS THE EIGENVECTORS ASSOCIATED WITH THE STORED
!          EIGENVALUES.
!
!        IERR IS SET TO
!          ZERO       FOR NORMAL RETURN,
!          J          IF THE J-TH EIGENVALUE HAS NOT BEEN
!                     DETERMINED AFTER 30 ITERATIONS.
!
!     CALLS PYTHAG FOR  SQRT(A*A + B*B) .
!
!     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
!     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
!
!     THIS VERSION DATED AUGUST 1983.
!
!     ------------------------------------------------------------------
!
      IERR = 0
      IF (N .EQ. 1) GO TO 1001
!
      DO 100 I = 2, N
  100 E(I-1) = E(I)
!
      F = 0.0E0
      TST1 = 0.0E0
      E(N) = 0.0E0
!
      DO 240 L = 1, N
         J = 0
         H = ABS(D(L)) + ABS(E(L))
         IF (TST1 .LT. H) TST1 = H
!     .......... LOOK FOR SMALL SUB-DIAGONAL ELEMENT ..........
         DO 110 M = L, N
            TST2 = TST1 + ABS(E(M))
            IF (TST2 .EQ. TST1) GO TO 120
!     .......... E(N) IS ALWAYS ZERO, SO THERE IS NO EXIT
!                THROUGH THE BOTTOM OF THE LOOP ..........
  110    CONTINUE
!
  120    IF (M .EQ. L) GO TO 220
  130    IF (J .EQ. 30) GO TO 1000
         J = J + 1
!     .......... FORM SHIFT ..........
         L1 = L + 1
         L2 = L1 + 1
         G = D(L)
         P = (D(L1) - G) / (2.0E0 * E(L))
         R = PYTHAG(P,1.0E0)
         D(L) = E(L) / (P + SIGN(R,P))
         D(L1) = E(L) * (P + SIGN(R,P))
         DL1 = D(L1)
         H = G - D(L)
         IF (L2 .GT. N) GO TO 145
!
         DO 140 I = L2, N
  140    D(I) = D(I) - H
!
  145    F = F + H
!     .......... QL TRANSFORMATION ..........
         P = D(M)
         C = 1.0E0
         C2 = C
         EL1 = E(L1)
         S = 0.0E0
         MML = M - L
!     .......... FOR I=M-1 STEP -1 UNTIL L DO -- ..........
         DO 200 II = 1, MML
            C3 = C2
            C2 = C
            S2 = S
            I = M - II
            G = C * E(I)
            H = C * P
            R = PYTHAG(P,E(I))
            E(I+1) = S * R
            S = E(I) / R
            C = P / R
            P = C * D(I) - S * G
            D(I+1) = H + S * (C * G + S * D(I))
!     .......... FORM VECTOR ..........
            DO 180 K = 1, N
               H = Z(K,I+1)
               Z(K,I+1) = S * Z(K,I) + C * H
               Z(K,I) = C * Z(K,I) - S * H
  180       CONTINUE
!
  200    CONTINUE
!
         P = -S * S2 * C3 * EL1 * E(L) / DL1
         E(L) = S * P
         D(L) = C * P
         TST2 = TST1 + ABS(E(L))
         IF (TST2 .GT. TST1) GO TO 130
  220    D(L) = D(L) + F
  240 CONTINUE
!     .......... ORDER EIGENVALUES AND EIGENVECTORS ..........
      DO 300 II = 2, N
         I = II - 1
         K = I
         P = D(I)
!
         DO 260 J = II, N
            IF (D(J) .GE. P) GO TO 260
            K = J
            P = D(J)
  260    CONTINUE
!
         IF (K .EQ. I) GO TO 300
         D(K) = D(I)
         D(I) = P
!
         DO 280 J = 1, N
            P = Z(J,I)
            Z(J,I) = Z(J,K)
            Z(J,K) = P
  280    CONTINUE
!
  300 CONTINUE
!
      GO TO 1001
!     .......... SET ERROR -- NO CONVERGENCE TO AN
!                EIGENVALUE AFTER 30 ITERATIONS ..........
 1000 IERR = L
 1001 RETURN
      END
      SUBROUTINE KPTQLRAT(N,D,E2,IERR)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
!
      INTEGER I,J,L,M,N,II,L1,MML,IERR
      DOUBLE PRECISION D(N),E2(N)
      DOUBLE PRECISION B,C,F,G,H,P,R,S,T,EPSLON,PYTHAG
!
!     THIS SUBROUTINE IS A TRANSLATION OF THE ALGOL PROCEDURE TQLRAT,
!     ALGORITHM 464, COMM. ACM 16, 689(1973) BY REINSCH.
!
!     THIS SUBROUTINE FINDS THE EIGENVALUES OF A SYMMETRIC
!     TRIDIAGONAL MATRIX BY THE RATIONAL QL METHOD.
!
!     ON INPUT
!
!        N IS THE ORDER OF THE MATRIX.
!
!        D CONTAINS THE DIAGONAL ELEMENTS OF THE INPUT MATRIX.
!
!        E2 CONTAINS THE SQUARES OF THE SUBDIAGONAL ELEMENTS OF THE
!          INPUT MATRIX IN ITS LAST N-1 POSITIONS.  E2(1) IS ARBITRARY.
!
!      ON OUTPUT
!
!        D CONTAINS THE EIGENVALUES IN ASCENDING ORDER.  IF AN
!          ERROR EXIT IS MADE, THE EIGENVALUES ARE CORRECT AND
!          ORDERED FOR INDICES 1,2,...IERR-1, BUT MAY NOT BE
!          THE SMALLEST EIGENVALUES.
!
!        E2 HAS BEEN DESTROYED.
!
!        IERR IS SET TO
!          ZERO       FOR NORMAL RETURN,
!          J          IF THE J-TH EIGENVALUE HAS NOT BEEN
!                     DETERMINED AFTER 30 ITERATIONS.
!
!     CALLS PYTHAG FOR  SQRT(A*A + B*B) .
!
!     QUESTIONS AND COMMENTS SHOULD BE DIRECTED TO BURTON S. GARBOW,
!     MATHEMATICS AND COMPUTER SCIENCE DIV, ARGONNE NATIONAL LABORATORY
!
!     THIS VERSION DATED AUGUST 1983.
!
!     ------------------------------------------------------------------
!
      IERR = 0
      IF (N .EQ. 1) GO TO 1001
!
      DO 100 I = 2, N
  100 E2(I-1) = E2(I)
!
      F = 0.0E0
      T = 0.0E0
      E2(N) = 0.0E0
!
      DO 290 L = 1, N
         J = 0
         H = ABS(D(L)) + SQRT(E2(L))
         IF (T .GT. H) GO TO 105
         T = H
         B = EPSLON(T)
         C = B * B
!     .......... LOOK FOR SMALL SQUARED SUB-DIAGONAL ELEMENT ..........
  105    DO 110 M = L, N
            IF (E2(M) .LE. C) GO TO 120
!     .......... E2(N) IS ALWAYS ZERO, SO THERE IS NO EXIT
!                THROUGH THE BOTTOM OF THE LOOP ..........
  110    CONTINUE
!
  120    IF (M .EQ. L) GO TO 210
  130    IF (J .EQ. 30) GO TO 1000
         J = J + 1
!     .......... FORM SHIFT ..........
         L1 = L + 1
         S = SQRT(E2(L))
         G = D(L)
         P = (D(L1) - G) / (2.0E0 * S)
         R = PYTHAG(P,1.0E0)
         D(L) = S / (P + SIGN(R,P))
         H = G - D(L)
!
         DO 140 I = L1, N
  140    D(I) = D(I) - H
!
         F = F + H
!     .......... RATIONAL QL TRANSFORMATION ..........
         G = D(M)
         IF (G .EQ. 0.0E0) G = B
         H = G
         S = 0.0E0
         MML = M - L
!     .......... FOR I=M-1 STEP -1 UNTIL L DO -- ..........
         DO 200 II = 1, MML
            I = M - II
            P = G * H
            R = P + E2(I)
            E2(I+1) = S * R
            S = E2(I) / R
            D(I+1) = H + S * (H + D(I))
            G = D(I) - E2(I) / G
            IF (G .EQ. 0.0E0) G = B
            H = G * P / R
  200    CONTINUE
!
         E2(L) = S * G
         D(L) = H
!     .......... GUARD AGAINST UNDERFLOW IN CONVERGENCE TEST ..........
         IF (H .EQ. 0.0E0) GO TO 210
         IF (ABS(E2(L)) .LE. ABS(C/H)) GO TO 210
         E2(L) = H * E2(L)
         IF (E2(L) .NE. 0.0E0) GO TO 130
  210    P = D(L) + F
!     .......... ORDER EIGENVALUES ..........
         IF (L .EQ. 1) GO TO 250
!     .......... FOR I=L STEP -1 UNTIL 2 DO -- ..........
         DO 230 II = 2, L
            I = L + 2 - II
            IF (P .GE. D(I-1)) GO TO 270
            D(I) = D(I-1)
  230    CONTINUE
!
  250    I = 1
  270    D(I) = P
  290 CONTINUE
!
      GO TO 1001
!     .......... SET ERROR -- NO CONVERGENCE TO AN
!                EIGENVALUE AFTER 30 ITERATIONS ..........
 1000 IERR = L
 1001 RETURN
      END
      DOUBLE PRECISION FUNCTION PYTHAG(A,B)
      DOUBLE PRECISION A,B
!
!     FINDS SQRT(A**2+B**2) WITHOUT OVERFLOW OR DESTRUCTIVE UNDERFLOW
!
      DOUBLE PRECISION P,R,S,T,U
      P = AMAX1(ABS(A),ABS(B))
      IF (P .EQ. 0.0E0) GO TO 20
      R = (AMIN1(ABS(A),ABS(B))/P)**2
   10 CONTINUE
         T = 4.0E0 + R
         IF (T .EQ. 4.0E0) GO TO 20
         S = R/T
         U = 1.0E0 + 2.0E0*S
         P = U*P
         R = (S/U)**2 * R
      GO TO 10
   20 PYTHAG = P
      RETURN
      END
!
      DOUBLE PRECISION FUNCTION EPSLON (X)
      DOUBLE PRECISION X
      DOUBLE PRECISION A,B,C,EPS
      A = 4.0E0/3.0E0
  10  B = A - 1.0E0
      C = B + B + B
      EPS = ABS(C-1.0E0)
      IF(EPS .EQ. 0.0E0)GO TO 10
      EPSLON = EPS*ABS(X)
      RETURN
      END
!
! *********************************************************************
!   SUBROUTINE KPCUTPLANE -- FINDS CUTTING LINE USING THE CUTTING
!                            PLANE PROCEDURE
! *********************************************************************
!
!
      SUBROUTINE KPCUTPLANE(JJJ,NP,NRCALL,NS,NDUAL,XMAT,ZVEC,WS, &
                            MCUTS,LERROR,IFIXX,KTT,KT,LDATA,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION XMAT(NP,25),ZVEC(NRCALL,25),WS(NDUAL),            &
                LERROR(NP,NRCALL),MCUTS(NRCALL,2),LDATA(NP,NRCALL)               
!
      DOUBLE PRECISION, ALLOCATABLE :: XJCH(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJEH(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJCL(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJEL(:)
      DOUBLE PRECISION, ALLOCATABLE :: XPROJ(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XXY(:)
      DOUBLE PRECISION, ALLOCATABLE :: XXX(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZS(:)
      INTEGER, ALLOCATABLE :: LLL(:)
      INTEGER, ALLOCATABLE :: MM(:)
      INTEGER, ALLOCATABLE :: MVOTE(:)
      INTEGER, ALLOCATABLE :: LLV(:)
      INTEGER, ALLOCATABLE :: LLVB(:)
      INTEGER, ALLOCATABLE :: LLE(:)
      INTEGER, ALLOCATABLE :: LLEB(:)
      INTEGER, ALLOCATABLE :: LCERROR(:,:)
      ALLOCATE(XJCH(25))
      ALLOCATE(XJEH(25))
      ALLOCATE(XJCL(25))
      ALLOCATE(XJEL(25))
      ALLOCATE(XPROJ(NP,NRCALL))
      ALLOCATE(XXY(NP))
      ALLOCATE(XXX(NDUAL))
      ALLOCATE(LLL(NDUAL))
      ALLOCATE(MM(NRCALL))
      ALLOCATE(MVOTE(NDUAL))
      ALLOCATE(LLV(NDUAL))
      ALLOCATE(LLVB(NDUAL))
      ALLOCATE(LLE(NDUAL))
      ALLOCATE(LLEB(NDUAL))
      ALLOCATE(LCERROR(NP,NRCALL))
      ALLOCATE(ZS(NDUAL))
!
!  100 FORMAT(5I5)
!  101 FORMAT(7I4,2F10.4)
! 1010 FORMAT(' WHOA DUDE! THESE DO NOT MATCH!')
! 1093 FORMAT(' CLASSIFICATION CHECK  ',I3,4I8)
! 1094 FORMAT(' RC  CLASSIFICATION ERROR  ',2I3,2I8,2F10.5)
! 1118 FORMAT(7I4,F7.3,3I4)
      CALL ECHOEVENT(11)
      CALL FLUSHCON()
      CALL PROCEVENT()
!
!   ESTIMATE PROJECTION VECTORS
!
      IF(JJJ.EQ.1)THEN
         DO 286 JX=1,NRCALL
         DO 285 I=1,NP
         LERROR(I,JX)=0
  285    CONTINUE
  286    CONTINUE
      ENDIF
      KCHECK4=0
      DO 284 JX=1,NRCALL
      DO 283 I=1,NP
      LCERROR(I,JX)=LERROR(I,JX)
      IF(LDATA(I,JX).EQ.0)GO TO 283
      KCHECK4=KCHECK4+LERROR(I,JX)
  283 CONTINUE
  284 CONTINUE
!
      KT=0
      KTT=0
      KTTSAVE=0
      KTSAVE=0
      KCHECK=0
      DO 93 JX=1,NRCALL
!
!  GET YES AND NO COUNTS
!
      KYES=0
      KNO=0
      DO 92 I=1,NP
      IF(LDATA(I,JX).EQ.1)KYES=KYES+1
      IF(LDATA(I,JX).EQ.6)KNO=KNO+1
  92  CONTINUE
!
!
      DO 89 I=1,NP
      SUM=0.0
      DO 90 K=1,NS
      SUM=SUM+XMAT(I,K)*ZVEC(JX,K)
  90  CONTINUE
!
!  SAVE PROJECTION VECTORS -- LEGISLATOR BY ROLL CALL MATRIX
!
      XPROJ(I,JX)=SUM
      XXY(I)=SUM
      LLL(I)=I
      XXX(I)=SUM
      MM(I)=LDATA(I,JX)
      IF(LDATA(I,JX).EQ.0)MM(I)=9
  89  CONTINUE
!
!  SORT PROJECTION VECTOR (Y-HAT)
!
      CALL KPRSORT(XXX,NP,LLL)
      DO 114 I=1,NP
      MVOTE(I)=MM(LLL(I))
  114 CONTINUE
!
!
!  CALCULATE CLASSIFICATION ERRORS OF PROJECTION ONTO NORMAL VECTOR
!
!
      JCH=0
      JEH=0
      JCL=0
      JEL=0
      IROTC=0
      CALL JAN1PT(NP,NRCALL,NP,NRCALL,NS,NDUAL,JX,XMAT,XXX,MVOTE,WS, &
                  LLV,LLVB,LLE,LLEB,LERROR, &
                  ZS,JCH,JEH,JCL,JEL,IROTC,KCUT,LCUT,LLL, &
                  XJCH,XJEH,XJCL,XJEL)
!
!      IF(IPRINT.EQ.1)WRITE(11,3909)JX,KYES,KNO,JCH,JCL,JEH,JEL,
!     C                (ZVEC(JX,K),K=1,NS),WS(JX)
! 3909 FORMAT(I3,'***',6I4,10F7.3)
      IF(JEH+JEL.EQ.0)THEN
         KT=KT+JCH+JEH+JCL+JEL
         KTSAVE=KTSAVE+JCH+JEH+JCL+JEL
         KITTY1=0
         KITTY2=JCH+JEH+JCL+JEL
         IJUST=0
         GO TO 9377
      ENDIF
!
!  SET-UP FOR GRID SEARCH FOR BEST CUTTING LINE
!
      NCUT=25
      CALL KPSEARCH(JX,NCUT,NS,NP,NRCALL,NDUAL,KCUT,LCUT,KTT,KT, &
                  XMAT,ZVEC,XPROJ,WS,XXY, &
                  KITTY1,KITTY2,KYES,KNO,LDATA,LERROR,IPRINT)
!
!
      KTTSAVE=KTTSAVE+KITTY1
      KTSAVE=KTSAVE+KITTY2
!
 9377 CONTINUE
!
!  STORE DIRECTIONALITY OF ROLL CALL
!
      MCUTS(JX,1)=KCUT
      MCUTS(JX,2)=LCUT
!
!
!  LOCATE ERRORS -- WS(.) CONTAINS THE OPTIMAL CUTTING POINT ON THE
!                   PROJECTION VECTOR -- IT CAN BE USED TO CALCULATE THE
!                   CLASSIFICATION ERRORS
!
      KSUM=0
      DO 108 I=1,NP
      LERROR(I,JX)=0
      XXX(I)=XXY(I)
      LLL(I)=I
      IF(LDATA(I,JX).EQ.0)GO TO 108
      IF(XXY(I).LT.WS(JX))THEN
         IF(LDATA(I,JX).NE.KCUT)THEN
            LERROR(I,JX)=1
            KCHECK=KCHECK+1
            KSUM=KSUM+1
         ENDIF
      ENDIF
      IF(XXY(I).GT.WS(JX))THEN
         IF(LDATA(I,JX).NE.LCUT)THEN
            LERROR(I,JX)=1
            KCHECK=KCHECK+1
            KSUM=KSUM+1
         ENDIF
      ENDIF
  108 CONTINUE
!      IF(KSUM.NE.KITTY1)THEN
!         IF(IPRINT.EQ.1)WRITE(11,1010)
!      ENDIF
      KXERROR=KITTY1
      JXERROR=KITTY1
      SAVEWS=WS(JX)
      XINC=0.2
      CALL KPRSEARCH(NP,NRCALL,NS,NDUAL,XINC,JX,NCUT,KPCUT,LPCUT, &
                   XMAT,ZVEC,WS,KDOWN,KEQUAL,KUP,JXERROR,WSNEW, &
                   LDATA,LERROR)

      IF(JXERROR.EQ.KXERROR)THEN
         WS(JX)=SAVEWS
      ENDIF
!
!  RESET LERROR(,)
!
      IF(JXERROR.LT.KXERROR)THEN
         KTTSAVE=KTTSAVE-KITTY1+JXERROR
         WS(JX)=WSNEW
         SAVEWS=WS(JX)
         MCUTS(JX,1)=KPCUT
         MCUTS(JX,2)=LPCUT
         KCHECK3=0
         DO 191 I=1,NP
         SUMI=0.0
         DO 192 K=1,NS
         SUMI=SUMI+XMAT(I,K)*ZVEC(JX,K)
  192    CONTINUE
         KCUT=MCUTS(JX,1)
         LCUT=MCUTS(JX,2)
         LERROR(I,JX)=0
         IF(LDATA(I,JX).EQ.0)GO TO 191
         IF(SUMI.LT.WS(JX))THEN
            IF(LDATA(I,JX).NE.KCUT)THEN
               LERROR(I,JX)=1
               KCHECK3=KCHECK3+1
            ENDIF
         ENDIF
         IF(SUMI.GT.WS(JX))THEN
            IF(LDATA(I,JX).NE.LCUT)THEN
               LERROR(I,JX)=1
               KCHECK3=KCHECK3+1
            ENDIF
         ENDIF
  191    CONTINUE
         KXERROR=JXERROR
      ENDIF
!
      IF(JXERROR.GE.KXERROR)THEN
         KCHECK33=0
         DO 391 I=1,NP
         SUMI=0.0
         DO 392 K=1,NS
         SUMI=SUMI+XMAT(I,K)*ZVEC(JX,K)
  392    CONTINUE
         KCUT=MCUTS(JX,1)
         LCUT=MCUTS(JX,2)
         LERROR(I,JX)=0
         IF(LDATA(I,JX).EQ.0)GO TO 391
         IF(SUMI.LT.WS(JX))THEN
            IF(LDATA(I,JX).NE.KCUT)THEN
               LERROR(I,JX)=1
               KCHECK33=KCHECK33+1
            ENDIF
         ENDIF
         IF(SUMI.GT.WS(JX))THEN
            IF(LDATA(I,JX).NE.LCUT)THEN
               LERROR(I,JX)=1
               KCHECK33=KCHECK33+1
            ENDIF
         ENDIF
  391    CONTINUE
      ENDIF
!
!      WRITE(38,1118)JX,JJJ,KYES,KNO,KITTY1,JXERROR,KCHECK3,
!     C                XINC,KDOWN,KEQUAL,KUP
  93  CONTINUE
!
      KT=KTSAVE
      KTT=KTTSAVE
      KCHECK2=0
      KCHECK22=0
      DO 282 I=1,NP
      DO 281 JX=1,NRCALL
      IF(LDATA(I,JX).EQ.0)GO TO 281
      KCHECK2=KCHECK2+LERROR(I,JX)
      KCHECK22=KCHECK22+LCERROR(I,JX)
  281 CONTINUE
  282 CONTINUE
!      IF(IPRINT.EQ.1)THEN
!         WRITE(11,1093)NS,KCHECK,KCHECK2,KCHECK22,KCHECK4
!      ENDIF
      IF(KT.GT.0)THEN
        XERROR=FLOAT(KTT)/FLOAT(KT)
        YERROR=1.0-XERROR
      ENDIF
!      IF(IPRINT.EQ.1)WRITE(21,1094)JJJ,NS,KTT,KT,XERROR,YERROR
      DEALLOCATE(XJCH)
      DEALLOCATE(XJEH)
      DEALLOCATE(XJCL)
      DEALLOCATE(XJEL)
      DEALLOCATE(XPROJ)
      DEALLOCATE(XXY)
      DEALLOCATE(XXX)
      DEALLOCATE(LLL)
      DEALLOCATE(MM)
      DEALLOCATE(MVOTE)
      DEALLOCATE(LLV)
      DEALLOCATE(LLVB)
      DEALLOCATE(LLE)
      DEALLOCATE(LLEB)
      DEALLOCATE(LCERROR)
      DEALLOCATE(ZS)
      RETURN
      END
!
!  ************************************************************************
!    SUBROUTINE KPSEARCH
!  ************************************************************************
!
      SUBROUTINE KPSEARCH(JX,NCUT,NS,NP,NRCALL,NDUAL,KCUT,LCUT, &
                        KTT,KT,XMAT,ZVEC,XPROJ,WS,XXY, &
                        KITTY1,KITTY2,KYES,KNO,LDATA, &
                        LERROR,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION XMAT(NP,25),ZVEC(NRCALL,25),LERROR(NP,NRCALL),&
                XPROJ(NP,NRCALL),WS(NDUAL),XXY(NP),LDATA(NP,NRCALL)
      DOUBLE PRECISION SUM
!               
      INTEGER, ALLOCATABLE :: KKKCUT(:)
      INTEGER, ALLOCATABLE :: LLLCUT(:)
      INTEGER, ALLOCATABLE :: LLV(:)
      INTEGER, ALLOCATABLE :: LLVB(:)
      INTEGER, ALLOCATABLE :: LLE(:)
      INTEGER, ALLOCATABLE :: LLEB(:)
      INTEGER, ALLOCATABLE :: LWRONG(:)
      INTEGER, ALLOCATABLE :: LLL(:)
      INTEGER, ALLOCATABLE :: MVOTE(:)
      INTEGER, ALLOCATABLE :: LLM(:)
      INTEGER, ALLOCATABLE :: LLN(:)
      INTEGER, ALLOCATABLE :: MM(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJCH(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJEH(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJCL(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJEL(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZS(:)
      DOUBLE PRECISION, ALLOCATABLE :: UUU(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: FV1(:)
      DOUBLE PRECISION, ALLOCATABLE :: FV2(:)
      DOUBLE PRECISION, ALLOCATABLE :: SUMX(:)
      DOUBLE PRECISION, ALLOCATABLE :: UUUU(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XXX(:)
      DOUBLE PRECISION, ALLOCATABLE :: IWORK(:)
      DOUBLE PRECISION, ALLOCATABLE ::  Y16MIDP(:,:)
      DOUBLE PRECISION, ALLOCATABLE ::  YHAT(:)
      DOUBLE PRECISION, ALLOCATABLE ::  Z16MIDP(:,:)
      DOUBLE PRECISION, ALLOCATABLE ::  VVV(:,:)
      DOUBLE PRECISION, ALLOCATABLE ::  WORK(:)
      DOUBLE PRECISION, ALLOCATABLE ::  X16MIDP(:,:)
      ALLOCATE(KKKCUT(NP))
      ALLOCATE(LLLCUT(NP))
      ALLOCATE(LLV(NDUAL))
      ALLOCATE(LLVB(NDUAL))
      ALLOCATE(LLE(NDUAL))
      ALLOCATE(LLEB(NDUAL))
      ALLOCATE(LWRONG(NP))
      ALLOCATE(LLL(NDUAL))
      ALLOCATE(MVOTE(NDUAL))
      ALLOCATE(LLM(NP))
      ALLOCATE(LLN(NP))
      ALLOCATE(MM(NP))
      ALLOCATE(XJCH(25))
      ALLOCATE(XJEH(25))
      ALLOCATE(XJCL(25))
      ALLOCATE(XJEL(25))
      ALLOCATE(ZS(NDUAL))
      ALLOCATE(UUU(NP,NP))
      ALLOCATE(FV1(NP))
      ALLOCATE(FV2(NP))
      ALLOCATE(SUMX(NP))
      ALLOCATE(UUUU(NP,NP))
      ALLOCATE(XXX(NDUAL))
      ALLOCATE(IWORK(200))
      ALLOCATE(Y16MIDP(NP,25))
      ALLOCATE(YHAT(NP))
      ALLOCATE(Z16MIDP(NP,NP))
      ALLOCATE(VVV(25,25))
      ALLOCATE(WORK(2*NP+1875))
      ALLOCATE(X16MIDP(NP,25))
!
!  104 FORMAT(I5,10F10.4)
!  210 FORMAT(I5,10F12.3)
! 1091 FORMAT(' INVERSE MATRIX ERROR',I4,I5,I8,2F10.4)
! 1099 FORMAT(I3,I5,I3,2I4)
! 1103 FORMAT(' MIDPOINT DECOMPOSITION',5I6)
! 1212 FORMAT(I3,I5,7I4)
! 3909 FORMAT(I5,I3,6I4,2I8,5I5)
!
      DO 1 I=1,50
      SUMX(I)=0.0
  1   CONTINUE
!
!  PHASE 2
!
!      NCUT2=20
!
      DO 999 IJL=1,NCUT
!
!  SET-UP FOR PHASE 2
!
!
      DO 388 K=1,NS
      UUUU(IJL,K)=ZVEC(JX,K)
  388 CONTINUE
      DO 389 I=1,NP
      SUM=0.0
      DO 390 K=1,NS
      SUM=SUM+XMAT(I,K)*ZVEC(JX,K)
  390 CONTINUE
!
!  SAVE PROJECTION VECTORS -- LEGISLATOR BY ROLL CALL MATRIX
!
      XPROJ(I,JX)=SUM
      XXY(I)=SUM
      LLL(I)=I
      XXX(I)=SUM
      MM(I)=LDATA(I,JX)
      IF(LDATA(I,JX).EQ.0)MM(I)=9
  389 CONTINUE
!
!  SORT PROJECTION VECTOR (Y-HAT)
!
!
      CALL KPRSORT(XXX,NP,LLL)
      DO 314 I=1,NP
      MVOTE(I)=MM(LLL(I))
  314 CONTINUE
!
!
!  CALCULATE CLASSIFICATION ERRORS FOR BEST SOLUTION FROM PHASE 1
!
!
      JCH=0
      JEH=0
      JCL=0
      JEL=0
      IROTC=0
      CALL JAN1PT(NP,NRCALL,NP,NRCALL,NS,NDUAL,JX,XMAT,XXX,MVOTE,WS, &
                  LLV,LLVB,LLE,LLEB,LERROR, &
                  ZS,JCH,JEH,JCL,JEL,IROTC,KCUT,LCUT,LLL, &
                  XJCH,XJEH,XJCL,XJEL)
!
!      IF(IPRINT.EQ.1)WRITE(11,3909)JX,IJL,KYES,KNO,JCH,JCL,JEH,JEL
!
      LLM(IJL)=IJL
      LLN(IJL)=JEH+JEL
      FV1(IJL)=FLOAT(JEH+JEL)
      FV2(IJL)=WS(JX)
      KKKCUT(IJL)=KCUT
      LLLCUT(IJL)=LCUT
!
      IF(JEH+JEL.EQ.0)THEN
         KT=KT+JCH+JCL+JEH+JEL
         KITTY1=0
         KITTY2=JCH+JCL+JEH+JEL
         IJUST=2
         DEALLOCATE(KKKCUT)
         DEALLOCATE(LLLCUT)
         DEALLOCATE(LLV)
         DEALLOCATE(LLVB)
         DEALLOCATE(LLE)
         DEALLOCATE(LLEB)
         DEALLOCATE(LWRONG)
         DEALLOCATE(LLL)
         DEALLOCATE(MVOTE)
         DEALLOCATE(LLM)
         DEALLOCATE(LLN)
         DEALLOCATE(MM)
         DEALLOCATE(XJCH)
         DEALLOCATE(XJEH)
         DEALLOCATE(XJCL)
         DEALLOCATE(XJEL)
         DEALLOCATE(ZS)
         DEALLOCATE(UUU)
         DEALLOCATE(FV1)
         DEALLOCATE(FV2)
         DEALLOCATE(SUMX)
         DEALLOCATE(UUUU)
         DEALLOCATE(XXX)
         DEALLOCATE(IWORK)
         DEALLOCATE(Y16MIDP)
         DEALLOCATE(YHAT)
         DEALLOCATE(Z16MIDP)
         DEALLOCATE(VVV)
         DEALLOCATE(WORK)
         DEALLOCATE(X16MIDP)
         RETURN
      ENDIF
!
!
      KASTRO=4*(JEH+JEL)
      IF(KASTRO.GT.NP)KASTRO=NP
      IF(KASTRO.LT.4*NS)KASTRO=4*NS
!
      DO 108 I=1,NP
      LWRONG(I)=0
      DB2B1=WS(JX)-XXY(I)
      IF(XXY(I).LT.WS(JX))THEN
!
!  IF CORRECT PLACE LEGISLATOR POINT ON THE CURRENT CUTTING PLANE
!
         IF(LDATA(I,JX).EQ.KCUT)THEN
            DO 109 K=1,NS
            Y16MIDP(I,K)=XMAT(I,K)+DB2B1*ZVEC(JX,K)
  109       CONTINUE
         ENDIF
!
!  IF INCORRECT PUT ACTUAL POINT INTO THE CUTTING CLOUD
!
         IF(LDATA(I,JX).EQ.LCUT)THEN
            LWRONG(I)=1
            DO 110 K=1,NS
            Y16MIDP(I,K)=XMAT(I,K)
  110       CONTINUE
         ENDIF
!
!  IF NOT-VOTING PUT LEGISLATOR POINT ON THE CURRRENT CUTTING PLANE
!
         IF(LDATA(I,JX).EQ.0)THEN
            DO 111 K=1,NS
            Y16MIDP(I,K)=XMAT(I,K)+DB2B1*ZVEC(JX,K)
  111       CONTINUE
         ENDIF
      ENDIF
      IF(XXY(I).GT.WS(JX))THEN
!
!  IF CORRECT PLACE LEGISLATOR POINT ON THE CURRENT CUTTING PLANE
!
         IF(LDATA(I,JX).EQ.LCUT)THEN
            DO 112 K=1,NS
            Y16MIDP(I,K)=XMAT(I,K)+DB2B1*ZVEC(JX,K)
  112       CONTINUE
         ENDIF
!
!  IF INCORRECT PUT ACTUAL POINT INTO THE CUTTING CLOUD
!
         IF(LDATA(I,JX).EQ.KCUT)THEN
            LWRONG(I)=1
            DO 113 K=1,NS
            Y16MIDP(I,K)=XMAT(I,K)
  113       CONTINUE
         ENDIF
!
!  IF NOT-VOTING PUT LEGISLATOR POINT ON THE CURRRENT CUTTING PLANE
!
         IF(LDATA(I,JX).EQ.0)THEN
            DO 214 K=1,NS
            Y16MIDP(I,K)=XMAT(I,K)+DB2B1*ZVEC(JX,K)
  214       CONTINUE
         ENDIF
      ENDIF
!
  108 CONTINUE
!
!  MASS CENTER THE CUTTING PLANE MATRIX (Y16MIDP(,) HAS ALL POINTS)
!
      DO 215 K=1,NS
      SUM=0.0
      DO 216 I=1,NP
      SUM=SUM+Y16MIDP(I,K)
  216 CONTINUE
      DO 217 I=1,NP
      Y16MIDP(I,K)=Y16MIDP(I,K)-SUM/FLOAT(NP)
      SUMX(K)=SUMX(K)+Y16MIDP(I,K)**2
  217 CONTINUE
      SUMX(K)=SUMX(K)/FLOAT(NP)
  215 CONTINUE
!
!  CONSTRUCT PARTIAL CUTTING PLANE MATRIX (X16MIDP(,))
!
      KK=0
      KHIT=0
!
      DO 316 I=1,NP
      IF(LWRONG(I).EQ.1)THEN
         KK=KK+1
         DO 317 K=1,NS
         X16MIDP(KK,K)=Y16MIDP(I,K)
  317    CONTINUE
      ENDIF
  316 CONTINUE
      DO 201 I=1,NP
      IF(LWRONG(I).EQ.0)THEN
         KK=KK+1
         DO 219 K=1,NS
         X16MIDP(KK,K)=Y16MIDP(I,K)
  219    CONTINUE
         IF(KK.EQ.KASTRO)GO TO 203
      ENDIF
  201 CONTINUE
  203 CONTINUE
!
!  MASS CENTER THE PARTIAL CUTTING PLANE MATRIX
!
      DO 815 K=1,NS
      SUM=0.0
      DO 816 I=1,KASTRO
      SUM=SUM+X16MIDP(I,K)
  816 CONTINUE
      DO 817 I=1,KASTRO
      X16MIDP(I,K)=X16MIDP(I,K)-SUM/FLOAT(KASTRO)
      SUMX(K+NS)=SUMX(K+NS)+X16MIDP(I,K)**2
  817 CONTINUE
      SUMX(K+NS)=SUMX(K+NS)/FLOAT(KASTRO)
  815 CONTINUE
!
!  RUN REGRESSION TO ELIMINATE DIMENSION WITH LEAST VARIANCE
!
!
!  CALL SINGULAR VALUE DECOMPOSITION ROUTINE
!
      LWORK=2*NP+1875
      XTOL=.001
!      CALL LSVRR(NP,NS,Y16MIDP,NP,21,XTOL,IRANK,YHAT,Y16MIDP,
!     C           NP,VVV,25)
      CALL DGESDD('S',NP,NS,Y16MIDP,NP,YHAT,Z16MIDP, &
                 NP,VVV,25,WORK,LWORK,IWORK,IRANK)
!
!      WRITE(23,1094)IRANK
! 1094 FORMAT(' DGESDD ROUTINE',I5)
!      WRITE(23,3908)JX,IJL,(YHAT(K),K=1,NS),(VVV(K,NS),K=1,NS)
      DO 115 K=1,NS
      SUMX(K)=SUMX(K+NS)
      ZVEC(JX,K)=VVV(K,NS)
  115 CONTINUE
!
! 3908 FORMAT(I5,I3,10F7.3)
!
!
!  RUN REGRESSION TO ELIMINATE DIMENSION WITH LEAST VARIANCE
!
!      CALL LSVRR(KASTRO,NS,X16MIDP,NP,21,XTOL,IRANK,YHAT,X16MIDP,
!     C           NP,VVV,25)
      CALL DGESDD('S',KASTRO,NS,X16MIDP,NP,YHAT,Z16MIDP, &
                 NP,VVV,25,WORK,LWORK,IWORK,IRANK)
!
!      WRITE(23,1094)IRANK
!      WRITE(23,3908)JX,IJL,(YHAT(K),K=1,NS),(VVV(K,NS),K=1,NS)
      IF(IJL.GT.25)THEN
         DO 114 K=1,NS
         ZVEC(JX,K)=VVV(K,NS)
  114    CONTINUE
      ENDIF
!
!
  999 CONTINUE
!
      CALL KPRSORT(FV1,NCUT,LLM)
!
      DO 281 JJ=1,NCUT
      IF(FV1(1).LT.FV1(JJ))GO TO 282
  281 CONTINUE
  282 KIN=JJ-1
      LLM(1)=LLM(KIN)
!
      DO 387 K=1,NS
      ZVEC(JX,K)=UUUU(LLM(1),K)
  387 CONTINUE
      WS(JX)=FV2(LLM(1))
      KCUT=KKKCUT(LLM(1))
      LCUT=LLLCUT(LLM(1))
      DO 137 I=1,NP
      SUM=0.0
      DO 138 K=1,NS
      SUM=SUM+XMAT(I,K)*ZVEC(JX,K)
  138 CONTINUE
      XPROJ(I,JX)=SUM
      XXY(I)=SUM
  137 CONTINUE
      KTT=KTT+LLN(LLM(1))
      KITTY1=LLN(LLM(1))
      IJUST=3
      KT=KT+JCH+JCL+JEH+JEL
      KITTY2=JCH+JCL+JEH+JEL
      DEALLOCATE(KKKCUT)
      DEALLOCATE(LLLCUT)
      DEALLOCATE(LLV)
      DEALLOCATE(LLVB)
      DEALLOCATE(LLE)
      DEALLOCATE(LLEB)
      DEALLOCATE(LWRONG)
      DEALLOCATE(LLL)
      DEALLOCATE(MVOTE)
      DEALLOCATE(LLM)
      DEALLOCATE(LLN)
      DEALLOCATE(MM)
      DEALLOCATE(XJCH)
      DEALLOCATE(XJEH)
      DEALLOCATE(XJCL)
      DEALLOCATE(XJEL)
      DEALLOCATE(ZS)
      DEALLOCATE(UUU)
      DEALLOCATE(FV1)
      DEALLOCATE(FV2)
      DEALLOCATE(SUMX)
      DEALLOCATE(UUUU)
      DEALLOCATE(XXX)
      DEALLOCATE(IWORK)
      DEALLOCATE(Y16MIDP)
      DEALLOCATE(YHAT)
      DEALLOCATE(Z16MIDP)
      DEALLOCATE(VVV)
      DEALLOCATE(WORK)
      DEALLOCATE(X16MIDP)
      RETURN
      END
!
!  **************************************************************************
!    SUBROUTINE JAN1PT -- FINDS OPTIMAL CUTTING POINT FOR ONE DIMENSION
!  **************************************************************************
!
      SUBROUTINE JAN1PT(NPZZ,NV,NP,NRCALL,NS,NDUAL,IVOT,XMAT,YSS,KA,WS, &
                        LLV,LLVB,LLE,LLEB, &
                        LERROR,ZS,JCH,JEH,JCL,JEL,IROTC,KCCUT,LCCUT, &
                        LLL,XJCH,XJEH,XJCL,XJEL)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION YSS(NDUAL),KA(NDUAL),WS(NDUAL),LV(NDUAL), &
                LEB(NDUAL),Z(NDUAL),Y(NDUAL),LLV(NDUAL), &
                LLVB(NDUAL),LE(NDUAL),LERROR(NP,NRCALL), &
                LLEB(NDUAL),ZS(NDUAL),LLL(NDUAL),XMAT(NP,25), &
                XJCH(25),XJEH(25),XJCL(25),XJEL(25),AAJEP(101), &
                ABJEP(101),LAJEP(101),LBJEP(101),LCJEP(101), &
                LDJEP(101),ABABJEP(101),MJEP(101), &
                LVB(NDUAL),LLE(NDUAL),LJEP(NDUAL)
!
      JROTC=1
      IF(IROTC.EQ.2)THEN
         JROTC=0
         IROTC=1
      ENDIF
      NPN=NPZZ+1
      NPP=NPZZ-1
      KCUT=1
      LCUT=6
      NOTE=2
      IF(IROTC.EQ.1)THEN
         NOTE=1
      ENDIF
      AA1=0.0
      AB1=0.0
      LA1=0
      LB1=0
      LC1=0
      LD1=0
      AA2=999.0
      AB2=0.0
      LA2=0
      LB2=0
      LC2=0
      LD2=0
      DO 999 III=1,NOTE
      IF(III.EQ.2)THEN
         KCUT=6
         LCUT=1
      ENDIF
!
!  CHECK ALL POSSIBLE INTERIOR CUT POINTS  --  THE NP INPUT POINTS
!      ARE HELD FIXED.  THERE ARE NP POSSIBLE CUT-POINTS BEGINNING
!      WITH CUT-POINT 1 WHICH IS .001 UNITS TO THE LEFT OF POINT 1.
!      CUT-POINT 2 IS BETWEEN POINTS 1 AND 2, ETC.
!
!     1   2   3   4   5   6   7   8   9   10   11 ...... NP-1   NP
!    *  *   *   *   *   *   *   *   *   *    *                *
!    1  2   3   4   5   6   7   8   9  10   11  ...........  NP
!
!  IF KCUT=1 AND LCUT=6, THE FOLLOWING NP PATTERNS ARE TESTED
!
! PATTERN
!   1         6666666666666666666666
!   2         1666666666666666666666
!   3         1166666666666666666666
!   4         1116666666666666666666
!   5         1111666666666666666666
!   6         1111166666666666666666
!   7         1111116666666666666666
!   .           .....
!   .           .....
!   .           .....
!  NP-1       1111111111111111111166
!   NP        1111111111111111111116
!
!  BECAUSE THE PROGRAM TRIES BOTH KCUT=1/LCUT=6 AND KCUT=6/LCUT=1, THIS
!  WILL ALSO TEST THE ONE MISSING PATTERN ABOVE, VIZ., ALL "1"S.
!
!
      KSE=0
      KSV=0
      LSV=0
      LSE=0
      KMARK=1
      I=0
  10  I=I+1
!      IF(I-NPZZ-1)61,12,12
      IF((I-NPZZ-1).GE.0)GO TO 12
  61  Z(I)=999.0
      IF(I.EQ.1)THEN
         Y(I)=YSS(1)-.001
      ENDIF
      IF(I.GT.1)THEN
         Y(I)=(YSS(I)+YSS(I-1))/2.0
      ENDIF
!      IF(KA(I).EQ.9)GO TO 10
      IF(KMARK.EQ.1)THEN
         DO 3 J=I,NPZZ
         IF(KA(J).EQ.9)GO TO 3
         IF((LCUT-KA(J)).EQ.0)GO TO 5
         IF((KCUT-KA(J)).EQ.0)GO TO 6
         IF((KCUT-KA(J)).NE.0)GO TO 3
  5      LSV=LSV+1
         GO TO 3
  6      LSE=LSE+1
  3      CONTINUE
         KMARK=0
         GO TO 31
      ENDIF
      IF(KA(I-1).EQ.KCUT)THEN
         KSV=KSV+1
         LSE=LSE-1
      ENDIF
      IF(KA(I-1).EQ.LCUT)THEN
         KSE=KSE+1
         LSV=LSV-1
      ENDIF
!
  31  CONTINUE
      LJEP(I)=I
      LV(I)=KSV
      LVB(I)=LSV
      LE(I)=KSE
      LEB(I)=LSE
      KT=LV(I)+LE(I)+LVB(I)+LEB(I)
      Z(I)=FLOAT(LE(I)+LEB(I))/FLOAT(KT)
!
      IF(JROTC.EQ.0)THEN
         ZS(I)=Y(I)
         LLV(I)=LV(I)
         LLE(I)=LE(I)
         LLVB(I)=LVB(I)
         LLEB(I)=LEB(I)
      ENDIF
      GO TO 10
  12  CONTINUE
!
!  FIND BEST CUT POINT
!
      CALL KPRSORT(Z,NPZZ,LJEP)
      KIN=1
      MJEP(1)=1
      AAJEP(KIN)=Z(1)
      ABJEP(KIN)=Y(LJEP(1))
      ABABJEP(KIN)=ABS(ABJEP(KIN))
      LAJEP(KIN)=LV(LJEP(1))
      LBJEP(KIN)=LE(LJEP(1))
      LCJEP(KIN)=LVB(LJEP(1))
      LDJEP(KIN)=LEB(LJEP(1))
!
!  CHECK IF THERE ARE MULTIPLE CUT-POINTS WITH SAME CLASSIFICATION AND
!    SELECT THAT CUT-POINT CLOSEST TO THE INTERIOR OF THE SPACE
!
      DO 63 I=2,NPZZ
      IF(ABS(Z(1)-Z(I)).LE..00001)THEN
         KIN=KIN+1
         MJEP(KIN)=KIN
         AAJEP(KIN)=Z(I)
         ABJEP(KIN)=Y(LJEP(I))
         ABABJEP(KIN)=ABS(ABJEP(KIN))
         LAJEP(KIN)=LV(LJEP(I))
         LBJEP(KIN)=LE(LJEP(I))
         LCJEP(KIN)=LVB(LJEP(I))
         LDJEP(KIN)=LEB(LJEP(I))
         IF(KIN.GT.100)GO TO 633
         GO TO 63
      ENDIF
      IF(Z(1).LT.Z(I))GO TO 633
  63  CONTINUE
  633 CONTINUE
      IF(KIN.EQ.1)THEN
         AA=AAJEP(1)
         AB=ABJEP(1)
         LA=LAJEP(1)
         LB=LBJEP(1)
         LC=LCJEP(1)
         LD=LDJEP(1)
      ENDIF
      IF(KIN.GT.1)THEN
         CALL KPRSORT(ABABJEP,KIN,MJEP)
         AA=AAJEP(MJEP(1))
         AB=ABJEP(MJEP(1))
         LA=LAJEP(MJEP(1))
         LB=LBJEP(MJEP(1))
         LC=LCJEP(MJEP(1))
         LD=LDJEP(MJEP(1))
      ENDIF
!
      IF(III.EQ.1)THEN
         AA1=AA
         AB1=AB
         LA1=LA
         LB1=LB
         LC1=LC
         LD1=LD
      ENDIF
      IF(III.EQ.2)THEN
         AA2=AA
         AB2=AB
         LA2=LA
         LB2=LB
         LC2=LC
         LD2=LD
      ENDIF
!
  999 CONTINUE
!
      IF(AA1.LE.AA2)THEN
         KCCUT=1
         LCCUT=6
         AA=AA1
         AB=AB1
         LA=LA1
         LB=LB1
         LC=LC1
         LD=LD1
      ENDIF
      IF(AA1.GT.AA2)THEN
         KCCUT=6
         LCCUT=1
         AA=AA2
         AB=AB2
         LA=LA2
         LB=LB2
         LC=LC2
         LD=LD2
      ENDIF
      IF(IROTC.EQ.1)THEN
         KCCUT=1
         LCCUT=6
         AA=AA1
         AB=AB1
         LA=LA1
         LB=LB1
         LC=LC1
         LD=LD1
      ENDIF
      WS(IVOT)=AB
      IF(IROTC.EQ.1)WS(IVOT+NV)=AB
      IF(JROTC.EQ.1)THEN
         ZS(IVOT)=AA
         LLV(IVOT)=LA
         LLE(IVOT)=LB
         LLVB(IVOT)=LC
         LLEB(IVOT)=LD
      ENDIF
      JCL=LA
      JEL=LB
      JCH=LC
      JEH=LD
!
      IF(IROTC.EQ.0)THEN
         DO 71 K=1,NS
         XJCH(K)=0.0
         XJEH(K)=0.0
         XJCL(K)=0.0
         XJEL(K)=0.0
  71     CONTINUE
         DO 64 I=1,NPZZ
         IF(LLL(I).LE.NPZZ-1)LERROR(LLL(I),IVOT)=0
         IF(KA(I).EQ.9)GO TO 64
         LERROR(LLL(I),IVOT)=0
         IF(YSS(I).LT.AB)THEN
            IF(KA(I).EQ.KCCUT)THEN
               LERROR(LLL(I),IVOT)=0
               DO 70 K=1,NS
               XJCL(K)=XJCL(K)+XMAT(LLL(I),K)
   70          CONTINUE
            ENDIF
            IF(KA(I).EQ.LCCUT)THEN
               LERROR(LLL(I),IVOT)=1
               DO 72 K=1,NS
               XJEL(K)=XJEL(K)+XMAT(LLL(I),K)
   72          CONTINUE
            ENDIF
         ENDIF
         IF(YSS(I).GT.AB)THEN
            IF(KA(I).EQ.LCCUT)THEN
               LERROR(LLL(I),IVOT)=0
               DO 73 K=1,NS
               XJCH(K)=XJCH(K)+XMAT(LLL(I),K)
   73          CONTINUE
            ENDIF
            IF(KA(I).EQ.KCCUT)THEN
               LERROR(LLL(I),IVOT)=1
               DO 74 K=1,NS
               XJEH(K)=XJEH(K)+XMAT(LLL(I),K)
   74          CONTINUE
            ENDIF
         ENDIF
  64     CONTINUE
         DO 75 K=1,NS
         IF(JCL.GT.0)XJCL(K)=XJCL(K)/FLOAT(JCL)
         IF(JEL.GT.0)XJEL(K)=XJEL(K)/FLOAT(JEL)
         IF(JCH.GT.0)XJCH(K)=XJCH(K)/FLOAT(JCH)
         IF(JEH.GT.0)XJEH(K)=XJEH(K)/FLOAT(JEH)
  75     CONTINUE
      ENDIF
      IF(IROTC.EQ.1)THEN
         DO 65 I=1,NPZZ
         IF(LLL(I).LE.NPZZ-1)LERROR(IVOT,LLL(I))=0
         IF(KA(I).EQ.9)GO TO 65
         LERROR(IVOT,LLL(I))=0
         IF(YSS(I).LT.AB)THEN
            IF(KA(I).EQ.KCCUT)LERROR(IVOT,LLL(I))=0
            IF(KA(I).EQ.LCCUT)LERROR(IVOT,LLL(I))=1
         ENDIF
         IF(YSS(I).GT.AB)THEN
            IF(KA(I).EQ.LCCUT)LERROR(IVOT,LLL(I))=0
            IF(KA(I).EQ.KCCUT)LERROR(IVOT,LLL(I))=1
         ENDIF
  65     CONTINUE
      ENDIF
      RETURN
      END
!
!
! *********************************************************************
!   SUBROUTINE KPLEGIS -- PERFORMS THE LEGISLATIVE PROCEDURE
!                           30 JUNE 1999
!
! *********************************************************************
!
      SUBROUTINE KPLEGIS(JJJ,NP,NRCALL,NS,NDUAL,XMAT,LLEGERR, &
                        ZVEC,WS,MCUTS,LERROR,LTOTAL,MWRONG, &
                        LDATA,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION XMAT(NP,25),ZVEC(NRCALL,25),&
                MCUTS(NRCALL,2),WS(NDUAL),LERROR(NP,NRCALL), &
                LLEGERR(NP,2),LDATA(NP,NRCALL)
!
      DOUBLE PRECISION, ALLOCATABLE :: BB(:,:)
      ALLOCATE(BB(25,NRCALL))
!
!  885 FORMAT(' ERROR CHECK ON ENTRY TO KPLEGIS',I5,I7)
! 1094 FORMAT(' LEG CLASSIFICATION ERROR  ',2I3,2I8,2F10.5)
!
      CALL ECHOEVENT(1)
      CALL FLUSHCON()
      CALL PROCEVENT()
      CALL ZVECINV(NRCALL,NS,ZVEC,BB,IPRINT)
!
      LTOTAL=0
      LWRONG=0
      MWRONG=0
      DO 111 I=1,NP
      KCHECK4=0
      DO 882 JX=1,NRCALL
      KCHECK4=KCHECK4+LERROR(I,JX)
  882 CONTINUE
      XSAVE1=XMAT(I,1)
      XSAVE2=XMAT(I,2)
      IVOT=I
      CALL KTPXI(IVOT,NP,NRCALL,NS,NDUAL,MCUTS,BB,XMAT,ZVEC,WS, &
                  LERROR,KTOTAL,KWRONG,LDATA)
!
!      WRITE(21,1492)I,KCHECK4,KWRONG,KTOTAL,XSAVE1,XSAVE2,
!     C                    XMAT(I,1),XMAT(I,2)
! 1492 FORMAT(4I8,4F7.3)
      MWRONG=MWRONG+KWRONG
      LTOTAL=LTOTAL+KTOTAL
      LLEGERR(I,1)=KWRONG
      LLEGERR(I,2)=KTOTAL
!
  111 CONTINUE
      IF(LTOTAL.GT.0)THEN
        XERROR=FLOAT(MWRONG)/FLOAT(LTOTAL)
        YERROR=1.0-XERROR
      ENDIF
!      IF(IPRINT.EQ.1)WRITE(21,1094)JJJ,NS,MWRONG,LTOTAL,XERROR,YERROR
      DEALLOCATE(BB)
      RETURN
      END
!
! **************************************************************************
!  SUBROUTINE ZVECINV -- CALCULATES (Z'Z)-1Z' WHERE Z IS THE NORMAL PLANE
!                        MATRIX
! **************************************************************************
!
      SUBROUTINE ZVECINV(NRCALL,NS,ZVEC,BB,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION BB(25,NRCALL),ZVEC(NRCALL,25)
      DOUBLE PRECISION, ALLOCATABLE :: VVV(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: FV1(:)
      DOUBLE PRECISION, ALLOCATABLE :: FV2(:)
      DOUBLE PRECISION, ALLOCATABLE :: VCOV(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: WVEC(:)
      DOUBLE PRECISION, ALLOCATABLE :: UL(:,:)
      ALLOCATE(VVV(25,25))
      ALLOCATE(FV1(NRCALL))
      ALLOCATE(FV2(NRCALL))
      ALLOCATE(VCOV(25,25))
      ALLOCATE(WVEC(25))
      ALLOCATE(UL(25,25))
!
! 1011 FORMAT(7F10.4)
! 1012 FORMAT(' DECOMPOSITION OF NORMAL VECTOR MATRIX',3I4)
! 1091 FORMAT(' INVERSE MATRIX ERROR',F10.4)
!
!
!    (X'X)
!
      DO 38 K=1,NS
      DO 39 L=1,NS
      SUM=0.0
      DO 40 I=1,NRCALL
      SUM=SUM+ZVEC(I,K)*ZVEC(I,L)
  40  CONTINUE
      VCOV(K,L)=SUM
  39  CONTINUE
  38  CONTINUE
!
!  EIGENVECTOR-EIGENVALUE DECOMPOSITION OF NORMAL VECTOR MATRIX
!
      CALL KPRS(25,NS,VCOV,WVEC,1,VVV,FV1,FV2,IER)
!      WRITE(21,1012)NS,NRCALL,IER
!      WRITE(*,1012)NS,NRCALL,IER
!      WRITE(21,1011)(WVEC(K),K=1,NS)
!
!  (X'X)-1
!
      DO 83 I=1,NS
      DO 83 K=1,NS
      SUM=0.0
      DO 84 J=1,NS
      IF(ABS(WVEC(NS+1-J)).GT..0001)THEN
          SUM=SUM+VVV(K,NS+1-J)*(1.0/WVEC(NS+1-J))*VVV(I,NS+1-J)
      ENDIF
  84  CONTINUE
  83  UL(I,K)=SUM
!
!
!  MATRIX INVERSION CHECK  (X'X)-1(X'X) = I
!
      ASUM=0.0
      DO 933 I=1,NS
      DO 933 J=1,NS
      SUM=0.0
      DO 944 K=1,NS
      SUM=SUM+UL(J,K)*VCOV(K,I)
  944 CONTINUE
      IF(I.EQ.J)ASUM=ASUM+ABS(1.0-SUM)
      IF(I.NE.J)ASUM=ASUM+ABS(SUM)
  933 CONTINUE
!      IF(ASUM.GT..01.AND.IPRINT.EQ.1)WRITE(23,1091)ASUM
!
!  (X'X)-1*X'
!
      DO 85 I=1,NRCALL
      DO 85 J=1,NS
      SUM=0.0
      DO 86 JJ=1,NS
      SUM=SUM+UL(J,JJ)*ZVEC(I,JJ)
  86  CONTINUE
  85  BB(J,I)=SUM
!
      DEALLOCATE(VVV)
      DEALLOCATE(FV1)
      DEALLOCATE(FV2)
      DEALLOCATE(VCOV)
      DEALLOCATE(WVEC)
      DEALLOCATE(UL)
      RETURN
      END
!
! **************************************************************************
!  SUBROUTINE KTPXI -- PERFORMS LEGISLATOR FITTING
! **************************************************************************
!
      SUBROUTINE KTPXI(ILEG,NP,NRCALL,NS,NDUAL,MCUTS,BB,XMAT,ZVEC,WS, &
                              LERROR,KTOTAL,KWRONG,LDATA)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION BB(25,NRCALL),XMAT(NP,25),WS(NDUAL),LERROR(NP,NRCALL), &
                ZVEC(NRCALL,25),MCUTS(NRCALL,2),LDATA(NP,NRCALL)
!
      INTEGER, ALLOCATABLE :: LL(:)
      INTEGER, ALLOCATABLE :: LSAVE(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ZWRONG(:)
      DOUBLE PRECISION, ALLOCATABLE :: XDAT(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XXZ(:)
      DOUBLE PRECISION, ALLOCATABLE :: YWRONG(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: YYWRONG(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XMAT2(:)
      DOUBLE PRECISION, ALLOCATABLE :: XXY(:)
      DOUBLE PRECISION, ALLOCATABLE :: YYYWRONG(:,:)
      ALLOCATE(LL(NRCALL))
      ALLOCATE(LSAVE(NRCALL,25))
      ALLOCATE(ZWRONG(50))
      ALLOCATE(XDAT(NP,25))
      ALLOCATE(XXZ(NRCALL))
      ALLOCATE(YWRONG(NRCALL,25))
      ALLOCATE(YYWRONG(NRCALL,25))
      ALLOCATE(XMAT2(25))
      ALLOCATE(XXY(NRCALL))
      ALLOCATE(YYYWRONG(NRCALL,25))
!
! 1001 FORMAT(I4,2X,I6,I4)
! 1011 FORMAT(I4,2I3,I4,12F7.3)
! 1012 FORMAT(14X,12F7.3)
! 1013 FORMAT(' LEG',2I3,I4,12F7.3)
! 1014 FORMAT(' WHOA DUDE',I4,I3,I4)
! 1015 FORMAT(' HEY THESE ARE NOT EQUAL!')
! 1016 FORMAT(I4,2I3,I4,12F7.3)
! 1017 FORMAT(14X,I4,12F7.3)
! 1018 FORMAT(10X,2I4,12F7.3)
! 1019 FORMAT(16X,12F7.3)
! 1020 FORMAT(2I4,3F10.4)
! 1021 FORMAT(4I4,12F7.3)
! 1022 FORMAT(' TWO  ',3I4,12F7.3)
! 1023 FORMAT(' THREE',3I4,12F7.3)
! 1024 FORMAT(' FOUR ',3I4,12F7.3)
! 1025 FORMAT(4X,4X,12X,12F7.3)
! 1026 FORMAT(I4,25F7.3)
!
      DO 8999 I=1,50
      ZWRONG(I)=0.0
 8999 CONTINUE      
      NTRIAL2=15
      MZZZ=5
!
!      WRITE(21,1019)(XMAT(ILEG,K),K=1,NS)
      DO 203 K=1,NS
      XDAT(20,K)=XMAT(ILEG,K)
  203 CONTINUE
!
      DO 9887 IIII=1,2
      SUM=0.0
      DO 101 K=1,NS
      XDAT(1,K)=0.0
!      IF(IIII.EQ.2)XDAT(1,K)=0.1
      IF(IIII.EQ.2)XDAT(1,K)=XDAT(20,K)
      XDAT(2,K)=XDAT(1,K)
  101 CONTINUE
!
!      WRITE(21,1019)(XDAT(1,K),K=1,NS)
      KWRONG=0
      K3WRONG=0
!
      DO 9888 III=1,MZZZ
!
      DO 988 II=1,NTRIAL2
      NII=II
      DO 987 KL=1,NS
!
      K3WRONG=KWRONG
      XDAT(2,KL)=0.01
!
!
!  CALCULATE FEASIBLE ALPHA VALUE
!
      ASUM=0.0
      AAA=0.0
      BBB=0.0
      DO 902 ML=1,NS
      ASUM=ASUM+XDAT(1,ML)**2
      AAA=AAA+(XDAT(2,ML)-XDAT(1,ML))**2
      BBB=BBB+2.0*(XDAT(2,ML)-XDAT(1,ML))*XDAT(1,ML)
  902 CONTINUE
      CCC=ASUM - 1.0
      RAD=BBB*BBB-4.0*AAA*CCC
      RADSQ=SQRT(ABS(RAD))
      ROOT1=0.0
      ROOT2=0.0
      IF(AAA.GT..00001)THEN
         ROOT1=(-BBB+RADSQ)/(2.0*AAA)
         ROOT2=(-BBB-RADSQ)/(2.0*AAA)
      ENDIF
!
      CALL KTPXIXJ(NII,ILEG,NP,NRCALL,NS,NDUAL,MCUTS,BB,XDAT,ZVEC,WS, &
                      XXZ,WSSY,XMAT2,ZWRONG,YYWRONG,LERROR,KTOTAL, &
                      KWRONG,ROOT1,ROOT2,LDATA)
!
      LSAVE(II,KL)=KWRONG
      IF(KWRONG.EQ.0)THEN
         LL(1)=II
         DO 668 K=1,NS
         XMAT(ILEG,K)=XMAT2(K)
  668    CONTINUE
         KKNII=NII
         K3WRONG=KWRONG
!         WRITE(21,1021)ILEG,III,II,KWRONG,(XMAT(ILEG,K),K=1,NS)
         GO TO 996
      ENDIF
!
      SUM=0.0
      DO 133 K=1,NS
      SUM=SUM+XMAT2(K)**2
      YWRONG(II,K)=XMAT2(K)
      YYYWRONG(KL,K)=XMAT2(K)
      XDAT(3,K)=XDAT(1,K)
      XDAT(1,K)=XMAT2(K)
      XDAT(2,K)=XMAT2(K)
      XMAT(ILEG,K)=XMAT2(K)
  133 CONTINUE
!
!      WRITE(21,1011)ILEG,II,KL,KWRONG,(XDAT(3,K),K=1,NS)
!      WRITE(21,1012)(XMAT2(K),K=1,NS),(ZWRONG(K),K=1,NS)
!
  987 CONTINUE
!
      SUM=0.0
      KSUM=0
      DO 132 K=1,NS
      IF(II.GT.1)THEN
         SUM=SUM+(YWRONG(II,K)-YWRONG(II-1,K))**2
         KSUM=KSUM+ABS(LSAVE(II,K)-LSAVE(II-1,K))
      ENDIF
  132 CONTINUE
      IF(II.EQ.1)GO TO 988
      IF(SUM.LE..000001)GO TO 986
      IF(II.GT.5.AND.KSUM.EQ.0)GO TO 986
  988 CONTINUE
!
  986 CONTINUE
!      WRITE(21,1021)ILEG,III,II,KWRONG,(XMAT(ILEG,K),K=1,NS)
      KKKNII=NII
      K3WRONG=KWRONG
!
!
!  CALCULATE FEASIBLE ALPHA VALUE
!
      ASUM=0.0
      AAA=0.0
      BBB=0.0
      DO 903 ML=1,NS
      XDAT(1,ML)=XMAT(ILEG,ML)
      XDAT(2,ML)=ZWRONG(K)
      ASUM=ASUM+XDAT(1,ML)**2
      AAA=AAA+(XDAT(2,ML)-XDAT(1,ML))**2
      BBB=BBB+2.0*(XDAT(2,ML)-XDAT(1,ML))*XDAT(1,ML)
  903 CONTINUE
      CCC=ASUM - 1.0
      RAD=BBB*BBB-4.0*AAA*CCC
      RADSQ=SQRT(ABS(RAD))
      ROOT1=0.0
      ROOT2=0.0
      IF(AAA.GT..00001)THEN
         ROOT1=(-BBB+RADSQ)/(2.0*AAA)
         ROOT2=(-BBB-RADSQ)/(2.0*AAA)
      ENDIF
!      ROOT1=(-BBB+RADSQ)/(2.0*AAA)
!      ROOT2=(-BBB-RADSQ)/(2.0*AAA)
!
      CALL KTPXIXJ(NII,ILEG,NP,NRCALL,NS,NDUAL,MCUTS,BB,XDAT,ZVEC,WS, &
                      XXZ,WSSY,XMAT2,ZWRONG,YYWRONG,LERROR,KTOTAL, &
                      KWRONG,ROOT1,ROOT2,LDATA)
!
!      WRITE(21,1021)ILEG,III,II,KWRONG,(XMAT2(K),K=1,NS),WSSY
!
      DO 44 K=1,NS
      XMAT(ILEG,K)=XMAT2(K)
      XDAT(1,K)=XMAT2(K)
      XDAT(2,K)=XMAT2(K)
      IF(IIII.EQ.1)XDAT(10,K)=XMAT2(K)
  44  CONTINUE
      IF(KWRONG.EQ.0)GO TO 996
 9888 CONTINUE
      IF(IIII.EQ.1)KLWRONG=KWRONG
      IF(IIII.EQ.2)THEN
!
!  CALCULATE FEASIBLE ALPHA VALUE
!
         ASUM=0.0
         AAA=0.0
         BBB=0.0
         DO 905 ML=1,NS
         XDAT(1,ML)=XMAT(ILEG,ML)
         XDAT(2,ML)=XDAT(10,ML)
         ASUM=ASUM+XDAT(1,ML)**2
         AAA=AAA+(XDAT(2,ML)-XDAT(1,ML))**2
         BBB=BBB+2.0*(XDAT(2,ML)-XDAT(1,ML))*XDAT(1,ML)
  905    CONTINUE
         CCC=ASUM - 1.0
         RAD=BBB*BBB-4.0*AAA*CCC
         RADSQ=SQRT(ABS(RAD))
         ROOT1=0.0
         ROOT2=0.0
         IF(AAA.GT..00001)THEN
            ROOT1=(-BBB+RADSQ)/(2.0*AAA)
            ROOT2=(-BBB-RADSQ)/(2.0*AAA)
         ENDIF
!         ROOT1=(-BBB+RADSQ)/(2.0*AAA)
!         ROOT2=(-BBB-RADSQ)/(2.0*AAA)
!
         CALL KTPXIXJ(NII,ILEG,NP,NRCALL,NS,NDUAL,MCUTS,BB,XDAT,ZVEC, &
                      WS,XXZ,WSSY,XMAT2,ZWRONG,YYWRONG,LERROR,KTOTAL, &
                      KWRONG,ROOT1,ROOT2,LDATA)
!
!         WRITE(21,1021)ILEG,III,II,KWRONG,(XMAT2(K),K=1,NS),WSSY
!
         DO 48 K=1,NS
         XMAT(ILEG,K)=XMAT2(K)
  48     CONTINUE
         IF(KWRONG.EQ.0)GO TO 996
      ENDIF
!
 9887 CONTINUE
!
  996 CONTINUE
!
      SUM=0.0
      DO 12 K=1,NS
      SUM=SUM+XMAT(ILEG,K)**2
  12  CONTINUE
      IF(SUM.GT.1.0)THEN
         DO 13 K=1,NS
         XMAT(ILEG,K)=XMAT(ILEG,K)/SQRT(SUM)
  13     CONTINUE
      ENDIF
!
      KKRITE=0
      KKWRONG=0
      KTOTAL=0
      DO 31 JX=1,NRCALL
      LERROR(ILEG,JX)=0
      SUM=0.0
      DO 32 K=1,NS
      SUM=SUM+XMAT(ILEG,K)*ZVEC(JX,K)
  32  CONTINUE
      XXY(JX)=SUM
      DB2B1=WS(JX)-XXY(JX)
!
!  CALCULATE CLASSIFICATION ERROR
!
      IF(LDATA(ILEG,JX).NE.0)THEN
         KTOTAL=KTOTAL+1
         IF(XXY(JX).LT.WS(JX))THEN
!            KTOTAL=KTOTAL+1
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,1))THEN
               KKRITE=KKRITE+1
            ENDIF
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,2))THEN
               LERROR(ILEG,JX)=1
               KKWRONG=KKWRONG+1
            ENDIF
         ENDIF
         IF(XXY(JX).GT.WS(JX))THEN
!            KTOTAL=KTOTAL+1
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,2))THEN
               KKRITE=KKRITE+1
            ENDIF
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,1))THEN
               LERROR(ILEG,JX)=1
               KKWRONG=KKWRONG+1
            ENDIF
         ENDIF
      ENDIF
  31  CONTINUE
!      WRITE(21,1001)ILEG,KKRITE,KKWRONG
      IF(KKWRONG.NE.KWRONG)THEN
!         WRITE(21,1015)
      ENDIF
      SUM=0.0
      DO 204 K=1,NS
      SUM=SUM+(XDAT(20,K)-XMAT(ILEG,K))**2
  204 CONTINUE
      SUM=SQRT(SUM)
!      WRITE(23,1026)ILEG,SUM
      DEALLOCATE(LL)
      DEALLOCATE(LSAVE)
      DEALLOCATE(ZWRONG)
      DEALLOCATE(XDAT)
      DEALLOCATE(XXZ)
      DEALLOCATE(YWRONG)
      DEALLOCATE(YYWRONG)
      DEALLOCATE(XMAT2)
      DEALLOCATE(XXY)
      DEALLOCATE(YYYWRONG)
      RETURN
      END
!
! **************************************************************************
!  SUBROUTINE KTPXIXJ -- PERFORMS LEGISLATOR FITTING
! **************************************************************************
!
      SUBROUTINE KTPXIXJ(NII,ILEG,NP,NRCALL,NS,NDUAL,MCUTS,BB,XDAT,ZVEC, &
                         WS,XXZ,WSSY,XMAT2,ZWRONG,YWRONG,LERROR,KTOTAL, &
                            KKWRONG,ROOT1,ROOT2,LDATA)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION BB(25,NRCALL),XDAT(NP,25),WS(NDUAL),LERROR(NP,NRCALL), &
                ZVEC(NRCALL,25),MCUTS(NRCALL,2),XXZ(NRCALL), &
                ZWRONG(50),YWRONG(NRCALL,25),XMAT2(25),LDATA(NP,NRCALL)
!
      INTEGER, ALLOCATABLE :: MRITE(:,:)
      INTEGER, ALLOCATABLE :: LALL(:)
      DOUBLE PRECISION, ALLOCATABLE :: YALL(:)
      DOUBLE PRECISION, ALLOCATABLE :: XALL(:)
      DOUBLE PRECISION, ALLOCATABLE :: KALL(:)
      DOUBLE PRECISION, ALLOCATABLE :: XXY(:)
      DOUBLE PRECISION, ALLOCATABLE :: XSAVE(:,:)
      ALLOCATE(MRITE(NRCALL,100))
      ALLOCATE(LALL(NDUAL))
      ALLOCATE(YALL(NDUAL))
      ALLOCATE(XALL(NDUAL))
      ALLOCATE(KALL(NDUAL))
      ALLOCATE(XXY(NRCALL))
      ALLOCATE(XSAVE(NRCALL,100))
!
! 1012 FORMAT(I4,3I6,7F7.3)
! 1013 FORMAT(2I4,3I6,F12.6,6F7.3/8X,8F7.3/8X,8F7.3)
! 1013 FORMAT(2I4,4I6,3F7.3)
! 1014 FORMAT(15X,I6,13X,4F7.3)
! 1015 FORMAT(I5,4F7.3)
! 1016 FORMAT(I5,2F7.3,I3,F7.3)
! 1017 FORMAT(I5,2F10.4,3F7.3)
! 1018 FORMAT(4X,6I5,20F10.4)
! 1019 FORMAT(2I4,4I6)
! 1020 FORMAT(' INITIAL ERROR',I4,3I6,7F7.3)
! 1021 FORMAT(I3,2I5,15F7.3)
! 1023 FORMAT(3I4,F15.10)
!
      KWED1=NII
!
!  INITIALIZE AT ZERO
!
      NTRY=2
!
      DO 99 III=1,NTRY
      KTOTAL=0
      KRITE=0
      KWRONG=0
      DO 11 JX=1,NRCALL
      SUM=0.0
      DO 52 K=1,NS
      SUM=SUM+XDAT(III,K)*ZVEC(JX,K)
  52  CONTINUE
      XXY(JX)=SUM
      XSAVE(JX,III)=SUM
      MRITE(JX,III)=0
      DB2B1=WS(JX)-XXY(JX)
      IF(LDATA(ILEG,JX).NE.0)THEN
         KTOTAL=KTOTAL+1
!
!  CALCULATE CLASSIFICATION ERROR
!
         IF(XXY(JX).LT.WS(JX))THEN
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,1))THEN
               KRITE=KRITE+1
               MRITE(JX,III)=1
            ENDIF
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,2))THEN
               KWRONG=KWRONG+1
            ENDIF
         ENDIF
         IF(XXY(JX).GT.WS(JX))THEN
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,1))THEN
               KWRONG=KWRONG+1
            ENDIF
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,2))THEN
               KRITE=KRITE+1
               MRITE(JX,III)=1
            ENDIF
         ENDIF
      ENDIF
  11  CONTINUE
!      WRITE(21,1012)III,KRITE,KWRONG,KTOTAL,(XDAT(III,K),K=1,NS)
  99  CONTINUE
!
!
!  CONSTRUCT PROJECTION VECTOR
!
      JJJ=1
      III=2
      ITOT=0
      KRITE=0
      KWRONG=0
      KTOTAL=0
      XERR=0.0
      XKMAX=+99999.0
      XKMIN=-99999.0
      DO 1 JX=1,NRCALL
!
      DB2B1=WS(JX)-XSAVE(JX,III)
      DENOM=XSAVE(JX,III)-XSAVE(JX,JJJ)
      IF(ABS(DENOM).LE.0.00001)THEN
!         WRITE(23,1023)NII,ILEG,JX,DENOM
         GO TO 1
      ENDIF
      XNUM1=+1.0-XSAVE(JX,JJJ)
      XNUM2=-1.0-XSAVE(JX,JJJ)
      XNUM3=WS(JX)-XSAVE(JX,JJJ)
!
!  CALCULATE CLASSIFICATION ERROR
!
      IF(LDATA(ILEG,JX).NE.0)THEN
         IF(XSAVE(JX,III).LT.WS(JX))THEN
            KTOTAL=KTOTAL+1
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,1))THEN
               KRITE=KRITE+1
!
!  CORRECT TO CORRECT (CASES 3 AND 4)
!
               IF(MRITE(JX,JJJ).EQ.1)THEN
!  CASE 3
                  IF(XSAVE(JX,III).LT.XSAVE(JX,JJJ))THEN
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM2/DENOM
                     KALL(ITOT)=6
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM3/DENOM
                     KALL(ITOT)=1
                  ENDIF
!  CASE 4
                  IF(XSAVE(JX,III).GT.XSAVE(JX,JJJ))THEN
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM3/DENOM
                     KALL(ITOT)=6
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM2/DENOM
                     KALL(ITOT)=1
                  ENDIF
               ENDIF
!
!  INCORRECT TO CORRECT (CASE 11)
!
               IF(MRITE(JX,JJJ).EQ.0)THEN
                  ITOT=ITOT+1
                  XALL(ITOT)=XNUM2/DENOM
                  KALL(ITOT)=6
                  ITOT=ITOT+1
                  XALL(ITOT)=XNUM3/DENOM
                  KALL(ITOT)=1
               ENDIF
            ENDIF
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,2))THEN
               KWRONG=KWRONG+1
!
!  CORRECT TO INCORRECT (CASE 9)
!
               IF(MRITE(JX,JJJ).EQ.1)THEN
                  ITOT=ITOT+1
                  XALL(ITOT)=XNUM3/DENOM
                  KALL(ITOT)=6
                  ITOT=ITOT+1
                  XALL(ITOT)=XNUM1/DENOM
                  KALL(ITOT)=1
               ENDIF
!
!  INCORRECT TO INCORRECT (CASES 7 AND 8)
!
               IF(MRITE(JX,JJJ).EQ.0)THEN
!  CASE 7
                  IF(XSAVE(JX,III).LT.XSAVE(JX,JJJ))THEN
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM3/DENOM
                     KALL(ITOT)=6
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM1/DENOM
                     KALL(ITOT)=1
                  ENDIF
!  CASE 8
                  IF(XSAVE(JX,III).GT.XSAVE(JX,JJJ))THEN
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM1/DENOM
                     KALL(ITOT)=6
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM3/DENOM
                     KALL(ITOT)=1
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
!
!
!
         IF(XSAVE(JX,III).GT.WS(JX))THEN
            KTOTAL=KTOTAL+1
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,2))THEN
               KRITE=KRITE+1
!
!  CORRECT TO CORRECT (CASES 1 AND 2)
!
               IF(MRITE(JX,JJJ).EQ.1)THEN
!  CASE 2
                  IF(XSAVE(JX,III).LT.XSAVE(JX,JJJ))THEN
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM3/DENOM
                     KALL(ITOT)=6
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM1/DENOM
                     KALL(ITOT)=1
                  ENDIF
!  CASE 1
                  IF(XSAVE(JX,III).GT.XSAVE(JX,JJJ))THEN
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM1/DENOM
                     KALL(ITOT)=6
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM3/DENOM
                     KALL(ITOT)=1
                  ENDIF
               ENDIF
!
!  INCORRECT TO CORRECT (CASE 12)
!
               IF(MRITE(JX,JJJ).EQ.0)THEN
                  ITOT=ITOT+1
                  XALL(ITOT)=XNUM1/DENOM
                  KALL(ITOT)=6
                  ITOT=ITOT+1
                  XALL(ITOT)=XNUM3/DENOM
                  KALL(ITOT)=1
               ENDIF
            ENDIF
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,1))THEN
               KWRONG=KWRONG+1
!
!  CORRECT TO INCORRECT (CASE 10)
!
               IF(MRITE(JX,JJJ).EQ.1)THEN
                  ITOT=ITOT+1
                  XALL(ITOT)=XNUM3/DENOM
                  KALL(ITOT)=6
                  ITOT=ITOT+1
                  XALL(ITOT)=XNUM2/DENOM
                  KALL(ITOT)=1
               ENDIF
!
!  INCORRECT TO INCORRECT (CASES 5 AND 6)
!
               IF(MRITE(JX,JJJ).EQ.0)THEN
!  CASE 6
                  IF(XSAVE(JX,III).LT.XSAVE(JX,JJJ))THEN
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM2/DENOM
                     KALL(ITOT)=6
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM3/DENOM
                     KALL(ITOT)=1
                  ENDIF
!  CASE 5
                  IF(XSAVE(JX,III).GT.XSAVE(JX,JJJ))THEN
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM3/DENOM
                     KALL(ITOT)=6
                     ITOT=ITOT+1
                     XALL(ITOT)=XNUM2/DENOM
                     KALL(ITOT)=1
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
      ENDIF
  1   CONTINUE
!
!  IMPOSE RANGE CONSTRAINTS ON ALPHA VECTOR -- ROOT2 IS THE LOWER BOUND
!                                              ROOT1 IS THE UPPER BOUND
!
      KK=0
      DO 363 I=1,ITOT
      IF(XALL(I).GT.ROOT2.AND.XALL(I).LT.ROOT1)THEN
         KK=KK+1
         YALL(KK)=XALL(I)
         LALL(KK)=KALL(I)
      ENDIF
  363 CONTINUE
!
      WSSY=0.0
      IF(KK.GT.0)THEN
         CALL KPRSORT(YALL,KK,LALL)
         IROTC=1
         CALL JAN0PT(KK,NP,NDUAL,YALL,LALL,WSSY,JCH,JEH,JCL,JEL,IROTC)
      ENDIF
!
!  (Z'Z)-1*Z'W-HAT
!
!
      DO 3 K=1,NS
      ZWRONG(K)=0.0
      SUMWS=0.0
      DO 4 JJ=1,NRCALL
      SUMWS=SUMWS+BB(K,JJ)*(XSAVE(JJ,JJJ)+ &
                      WSSY*(XSAVE(JJ,III)-XSAVE(JJ,JJJ)))
   4  CONTINUE
!
      XMAT2(K)=SUMWS
   3  CONTINUE
!
      KKRITE=0
      KKWRONG=0
      KTOTAL=0
      XERR2=0.0
      DO 31 JX=1,NRCALL
      LERROR(ILEG,JX)=0
      SUM=0.0
      DO 32 K=1,NS
      SUM=SUM+XMAT2(K)*ZVEC(JX,K)
  32  CONTINUE
      XXY(JX)=SUM
      XXZ(JX)=SUM
      DB2B1=WS(JX)-XXY(JX)
!
!  CALCULATE CLASSIFICATION ERROR
!
      IF(LDATA(ILEG,JX).NE.0)THEN
         IF(XXY(JX).LT.WS(JX))THEN
            KTOTAL=KTOTAL+1
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,1))THEN
               KKRITE=KKRITE+1
            ENDIF
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,2))THEN
               LERROR(ILEG,JX)=1
               KKWRONG=KKWRONG+1
               XERR2=XERR2+(XXY(JX)-WS(JX))**2
               XXZ(JX)=+1.0
               DO 62 K=1,NS
               YWRONG(KKWRONG,K)=XMAT2(K)+1.000*DB2B1*ZVEC(JX,K)
               ZWRONG(K)=ZWRONG(K)+XMAT2(K)+ &
                         1.5000*DB2B1*ZVEC(JX,K)
  62           CONTINUE
            ENDIF
         ENDIF
         IF(XXY(JX).GT.WS(JX))THEN
            KTOTAL=KTOTAL+1
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,2))THEN
               KKRITE=KKRITE+1
            ENDIF
            IF(LDATA(ILEG,JX).EQ.MCUTS(JX,1))THEN
               LERROR(ILEG,JX)=1
               KKWRONG=KKWRONG+1
               XERR2=XERR2+(XXY(JX)-WS(JX))**2
               XXZ(JX)=-1.0
               DO 63 K=1,NS
               YWRONG(KKWRONG,K)=XMAT2(K)+1.000*DB2B1*ZVEC(JX,K)
               ZWRONG(K)=ZWRONG(K)+XMAT2(K)+ &
                         1.5000*DB2B1*ZVEC(JX,K)
  63           CONTINUE
            ENDIF
         ENDIF
      ENDIF
  31  CONTINUE
!
      DO 5 K=1,NS
      IF(KKWRONG.GT.0)ZWRONG(K)=ZWRONG(K)/FLOAT(KKWRONG)
  5   CONTINUE
!      IF(ILEG.EQ.5)THEN
!      WRITE(21,1013)NII,ILEG,KKRITE,KKWRONG,JEH+JEL,KTOTAL,
!     C                  (XMAT2(K),K=1,3)
!      ENDIF
!
      DEALLOCATE(MRITE)
      DEALLOCATE(LALL)
      DEALLOCATE(YALL)
      DEALLOCATE(XALL)
      DEALLOCATE(KALL)
      DEALLOCATE(XXY)
      DEALLOCATE(XSAVE)
      RETURN
      END
!
!  **************************************************************************
!    SUBROUTINE JAN0PT -- FINDS OPTIMAL CUTTING POINT FOR ONE DIMENSION
!  **************************************************************************
!
      SUBROUTINE JAN0PT(KKNP,NP,NDUAL,YSS,KA,WSSY,JCH,JEH,JCL,JEL,IROTC)
!
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION YSS(NDUAL),KA(NDUAL)
      INTEGER, ALLOCATABLE :: LE(:)
      INTEGER, ALLOCATABLE :: LJEP(:)  
      INTEGER, ALLOCATABLE :: LV(:)
      INTEGER, ALLOCATABLE :: LVB(:)
      INTEGER, ALLOCATABLE :: LEB(:)
      INTEGER, ALLOCATABLE :: LAJEP(:)
      INTEGER, ALLOCATABLE :: LBJEP(:)
      INTEGER, ALLOCATABLE :: LCJEP(:)
      INTEGER, ALLOCATABLE :: LDJEP(:)
      INTEGER, ALLOCATABLE :: MJEP(:)
      DOUBLE PRECISION, ALLOCATABLE :: Z(:)
      DOUBLE PRECISION, ALLOCATABLE :: Y(:)
      DOUBLE PRECISION, ALLOCATABLE :: AAJEP(:)
      DOUBLE PRECISION, ALLOCATABLE :: ABJEP(:)
      DOUBLE PRECISION, ALLOCATABLE :: ABABJEP(:)
      ALLOCATE(LE(NDUAL))
      ALLOCATE(LJEP(NDUAL))  
      ALLOCATE(LV(NDUAL))
      ALLOCATE(LVB(NDUAL))
      ALLOCATE(LEB(NDUAL))
      ALLOCATE(LAJEP(101))
      ALLOCATE(LBJEP(101))
      ALLOCATE(LCJEP(101))
      ALLOCATE(LDJEP(101))
      ALLOCATE(MJEP(101))
      ALLOCATE(Z(NDUAL))
      ALLOCATE(Y(NDUAL))
      ALLOCATE(AAJEP(101))
      ALLOCATE(ABJEP(101))
      ALLOCATE(ABABJEP(101))
!
      NPN=KKNP+1
      NPP=KKNP-1
      KCUT=1
      LCUT=6
      NOTE=1
      AA1=0.0
      AB1=0.0
      LA1=0
      LB1=0
      LC1=0
      LD1=0
      AA2=999.0
      AB2=0.0
      LA2=0
      LB2=0
      LC2=0
      LD2=0
      DO 999 III=1,1
      IF(III.EQ.2)THEN
         KCUT=6
         LCUT=1
      ENDIF
!
!  CHECK ALL POSSIBLE INTERIOR CUT POINTS  --  THE NP INPUT POINTS
!      ARE HELD FIXED.  THERE ARE NP POSSIBLE CUT-POINTS BEGINNING
!      WITH CUT-POINT 1 WHICH IS .001 UNITS TO THE LEFT OF POINT 1.
!      CUT-POINT 2 IS BETWEEN POINTS 1 AND 2, ETC.
!
!     1   2   3   4   5   6   7   8   9   10   11 ...... NP-1   NP
!    *  *   *   *   *   *   *   *   *   *    *                *
!    1  2   3   4   5   6   7   8   9  10   11  ...........  NP
!
!  IF KCUT=1 AND LCUT=6, THE FOLLOWING NP PATTERNS ARE TESTED
!
! PATTERN
!   1         6666666666666666666666
!   2         1666666666666666666666
!   3         1166666666666666666666
!   4         1116666666666666666666
!   5         1111666666666666666666
!   6         1111166666666666666666
!   7         1111116666666666666666
!   .           .....
!   .           .....
!   .           .....
!  NP-1       1111111111111111111166
!   NP        1111111111111111111116
!
!  BECAUSE THE PROGRAM TRIES BOTH KCUT=1/LCUT=6 AND KCUT=6/LCUT=1, THIS
!  WILL ALSO TEST THE ONE MISSING PATTERN ABOVE, VIZ., ALL "1"S.
!
!
      KSE=0
      KSV=0
      LSV=0
      LSE=0
      KMARK=1
      I=0
  10  I=I+1
      IF((I-KKNP-1).GE.0)GO TO 12
  61  Z(I)=999.0
      IF(I.EQ.1)THEN
         Y(I)=YSS(1)-.001
      ENDIF
      IF(I.GT.1)THEN
         Y(I)=(YSS(I)+YSS(I-1))/2.0
      ENDIF
!      IF(KA(I).EQ.9)GO TO 10
      IF(KMARK.EQ.1)THEN
         DO 3 J=I,KKNP
         IF(KA(J).EQ.9)GO TO 3
         IF((LCUT-KA(J)).EQ.0)GO TO 5
         IF((KCUT-KA(J)).EQ.0)GO TO 6
         IF((KCUT-KA(J)).NE.0)GO TO 3
  5      LSV=LSV+1
         GO TO 3
  6      LSE=LSE+1
  3      CONTINUE
         KMARK=0
         GO TO 31
      ENDIF
      IF(KA(I-1).EQ.KCUT)THEN
         KSV=KSV+1
         LSE=LSE-1
      ENDIF
      IF(KA(I-1).EQ.LCUT)THEN
         KSE=KSE+1
         LSV=LSV-1
      ENDIF
!
  31  CONTINUE
      LJEP(I)=I
      LV(I)=KSV
      LVB(I)=LSV
      LE(I)=KSE
      LEB(I)=LSE
      KT=LV(I)+LE(I)+LVB(I)+LEB(I)
      Z(I)=FLOAT(LE(I)+LEB(I))/FLOAT(KT)
      GO TO 10
  12  CONTINUE
!
!  FIND BEST CUT POINT
!
      CALL KPRSORT(Z,KKNP,LJEP)
      KIN=1
      MJEP(1)=1
      AAJEP(KIN)=Z(1)
      ABJEP(KIN)=Y(LJEP(1))
      ABABJEP(KIN)=ABS(ABJEP(KIN))
      LAJEP(KIN)=LV(LJEP(1))
      LBJEP(KIN)=LE(LJEP(1))
      LCJEP(KIN)=LVB(LJEP(1))
      LDJEP(KIN)=LEB(LJEP(1))
!
!  CHECK IF THERE ARE MULTIPLE CUT-POINTS WITH SAME CLASSIFICATION AND
!    SELECT THAT CUT-POINT CLOSEST TO THE INTERIOR OF THE SPACE
!
      DO 63 I=2,KKNP
      IF(ABS(Z(1)-Z(I)).LE..000001)THEN
         KIN=KIN+1
         MJEP(KIN)=KIN
         AAJEP(KIN)=Z(I)
         ABJEP(KIN)=Y(LJEP(I))
         ABABJEP(KIN)=ABS(ABJEP(KIN))
         LAJEP(KIN)=LV(LJEP(I))
         LBJEP(KIN)=LE(LJEP(I))
         LCJEP(KIN)=LVB(LJEP(I))
         LDJEP(KIN)=LEB(LJEP(I))
         IF(KIN.GT.100)GO TO 633
         GO TO 63
      ENDIF
      IF(Z(1).LT.Z(I))GO TO 633
  63  CONTINUE
  633 CONTINUE
      IF(KIN.EQ.1)THEN
         AA=AAJEP(1)
         AB=ABJEP(1)
         LA=LAJEP(1)
         LB=LBJEP(1)
         LC=LCJEP(1)
         LD=LDJEP(1)
      ENDIF
      IF(KIN.GT.1)THEN
         CALL KPRSORT(ABABJEP,KIN,MJEP)
         AA=AAJEP(MJEP(1))
         AB=ABJEP(MJEP(1))
         LA=LAJEP(MJEP(1))
         LB=LBJEP(MJEP(1))
         LC=LCJEP(MJEP(1))
         LD=LDJEP(MJEP(1))
      ENDIF
!
      IF(III.EQ.1)THEN
         AA1=AA
         AB1=AB
         LA1=LA
         LB1=LB
         LC1=LC
         LD1=LD
      ENDIF
      IF(III.EQ.2)THEN
         AA2=AA
         AB2=AB
         LA2=LA
         LB2=LB
         LC2=LC
         LD2=LD
      ENDIF
!
  999 CONTINUE
!
      IF(AA1.LE.AA2)THEN
         KCCUT=1
         LCCUT=6
         AA=AA1
         AB=AB1
         LA=LA1
         LB=LB1
         LC=LC1
         LD=LD1
      ENDIF
      IF(AA1.GT.AA2)THEN
         KCCUT=6
         LCCUT=1
         AA=AA2
         AB=AB2
         LA=LA2
         LB=LB2
         LC=LC2
         LD=LD2
      ENDIF
      IF(IROTC.EQ.1)THEN
         KCCUT=1
         LCCUT=6
         AA=AA1
         AB=AB1
         LA=LA1
         LB=LB1
         LC=LC1
         LD=LD1
      ENDIF
      WSSY=AB
      JCL=LA
      JEL=LB
      JCH=LC
      JEH=LD
!
      DEALLOCATE(LE)
      DEALLOCATE(LJEP)  
      DEALLOCATE(LV)
      DEALLOCATE(LVB)
      DEALLOCATE(LEB)
      DEALLOCATE(LAJEP)
      DEALLOCATE(LBJEP)
      DEALLOCATE(LCJEP)
      DEALLOCATE(LDJEP)
      DEALLOCATE(MJEP)
      DEALLOCATE(Z)
      DEALLOCATE(Y)
      DEALLOCATE(AAJEP)
      DEALLOCATE(ABJEP)
      DEALLOCATE(ABABJEP)
      RETURN
      END
!
! **************************************************************************
!  SUBROUTINE KPVOLUME2 -- CALCULATES VOLUME OF REGION CONTAINING LEGISLATOR
!                           POINT
!
! **************************************************************************
!
      SUBROUTINE KPVOLUME2(IX,NS,NP,NRCALL,NDUAL,XMAT,ZVEC,WS,LDATA, &
                         BBSAVE,KKSAVE,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION XMAT(NP,25),WS(NDUAL),ZVEC(NRCALL,25),LDATA(NP,NRCALL)
      DOUBLE PRECISION, ALLOCATABLE :: XXY(:)
      DOUBLE PRECISION, ALLOCATABLE :: TVEC(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XXX(:)
      DOUBLE PRECISION, ALLOCATABLE :: XMAT2(:,:)
      ALLOCATE(XXY(NRCALL))
      ALLOCATE(TVEC(NRCALL+111,25))
      ALLOCATE(XXX(NRCALL))
      ALLOCATE(XMAT2(NRCALL+111,25))
! 1000 FORMAT(3I4,20F7.3)
! 1001 FORMAT(' MAX ITER',3I5,F6.3,2X,100F7.3)
!
!      CALL GETTIM(ITIM1,ITIM2,ITIM3,ITIM4)
!      ISEED=1000*ITIM2+100*ITIM2+1000*ITIM3+200*ITIM4
!
!      CALL RNSET(ISEED)
!
      KKSAVE=-99
      BBSAVE=-999.0
!
! PUT POINTS ON CUTTING PLANES CLOSEST TO XI
!
      DO 777 LM=1,100
      SUM=0.0
      DO 59 K=1,NS
!      TVEC(LM,K)=(URAND(ISEED)-.50)
!      TVEC(LM,K)=(RNUNF()-.50)
      TVEC(LM,K)=0.6
      SUM=SUM+TVEC(LM,K)**2
  59  CONTINUE
      DO 60 K=1,NS
      TVEC(LM,K)=TVEC(LM,K)/SQRT(SUM)
  60  CONTINUE
      XINC=.002
!
      DO 776 KLM=1,500
      SUMBIG=0.0
      DO 61 K=1,NS
      XMAT2(LM,K)=XMAT(IX,K)+XINC*TVEC(LM,K)
      SUMBIG=SUMBIG+XMAT2(LM,K)**2
  61  CONTINUE
!
!  CHECK IF POINT MOVES OUTSIDE HYPERSPHERE
!
      IF(SUMBIG.GE.1.0)GO TO 933
      DO 93 JX=1,NRCALL
      SUM=0.0
      SUM1=0.0
      DO 90 K=1,NS
      SUM= SUM+ XMAT(IX,K)*ZVEC(JX,K)
      SUM1=SUM1+XMAT2(LM,K)*ZVEC(JX,K)
  90  CONTINUE
      XXY(JX)=SUM
      XXX(JX)=SUM1
!
!  CHECK IF POINT MOVES OUTSIDE POLYTOPE
!
      IF(LDATA(IX,JX).EQ.0)GO TO 108
      IF(XXY(JX).LT.WS(JX))THEN
         IF(XXX(JX).GT.WS(JX))GO TO 933
      ENDIF
      IF(XXY(JX).GT.WS(JX))THEN
         IF(XXX(JX).LT.WS(JX))GO TO 933
      ENDIF
  108 CONTINUE
  93  CONTINUE
      XINC=XINC+.001
  776 CONTINUE
!      IF(IPRINT.EQ.1)WRITE(23,1001)IX,KLM,LM,XINC,(XMAT2(LM,K),K=1,NS), &
!                      (TVEC(LM,K),K=1,NS),(XMAT(IX,K),K=1,NS)
  933 CONTINUE
      SUM=0.0
      DO 81 K=1,NS
      SUM=SUM+(XMAT2(LM,K)-XMAT(IX,K))**2
  81  CONTINUE
      SUM=SQRT(SUM)
      BBSAVE=AMAX1(BBSAVE,SUM)
      KKSAVE=AMAX0(KKSAVE,KLM)
!
  777 CONTINUE
      DEALLOCATE(XXY)
      DEALLOCATE(TVEC)
      DEALLOCATE(XXX)
      DEALLOCATE(XMAT2)
      RETURN
      END
!
!  ************************************************************************
!    SUBROUTINE KPRSEARCH -- DOES LOCAL SEARCH ON NORMAL VECTORS
!
!  ************************************************************************
!
      SUBROUTINE KPRSEARCH(NP,NRCALL,NS,NDUAL,XINC,JX,NCUT,KPCUT,LPCUT, &
                      XMAT,ZVEC,WS,KDOWN,KEQUAL,KUP,JXERROR, &
                      WSNEW,LDATA,LERROR)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION XMAT(NP,25),ZVEC(NRCALL,25),WS(NDUAL), &
                LERROR(NP,NRCALL),LDATA(NP,NRCALL)
!
      INTEGER, ALLOCATABLE :: LLL(:)
      INTEGER, ALLOCATABLE :: MVOTE(:)
      INTEGER, ALLOCATABLE :: LLV(:)
      INTEGER, ALLOCATABLE :: LLVB(:)
      INTEGER, ALLOCATABLE :: LLE(:)
      INTEGER, ALLOCATABLE :: LLEB(:)
      INTEGER, ALLOCATABLE :: MM(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJCH(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJEH(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJCL(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJEL(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZS(:)
      DOUBLE PRECISION, ALLOCATABLE :: UUU(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XXX(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZZZ(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZVEC2(:,:)
      ALLOCATE(LLL(NRCALL))
      ALLOCATE(MVOTE(NDUAL))
      ALLOCATE(LLV(NDUAL))
      ALLOCATE(LLVB(NDUAL))
      ALLOCATE(LLE(NDUAL))
      ALLOCATE(LLEB(NDUAL))
      ALLOCATE(MM(NP))
      ALLOCATE(XJCH(25))
      ALLOCATE(XJEH(25))
      ALLOCATE(XJCL(25))
      ALLOCATE(XJEL(25))
      ALLOCATE(ZS(NDUAL))
      ALLOCATE(UUU(NP,25))
      ALLOCATE(XXX(NDUAL))
      ALLOCATE(ZZZ(NP))
      ALLOCATE(ZVEC2(NRCALL,25))
!
!  210 FORMAT(I5,10F12.3)
! 1091 FORMAT(' INVERSE MATRIX ERROR',I4,I5,I8,2F10.4)
! 1099 FORMAT(I3,I5,I3,2I4)
! 1103 FORMAT(' MIDPOINT DECOMPOSITION',5I6)
! 1212 FORMAT(I3,I5,7I4)
! 3909 FORMAT(I5,I3,6I4,2I8,5I5)
!
!      XINC=0.05
!
      KDOWN=0
      KEQUAL=0
      KUP=0
      DO 998 IJL=1,NCUT
      KQUIT=IJL
!
!  SET-UP FOR PHASE 2
!
      SUM=0.0
      DO 3 K=1,NS
!      ZZZ(K)=(URAND(ISEED)-.50)*0.4 + ZVEC(JX,K)
!      ZZZ(K)=(RNUNF()-.50)*0.4 + ZVEC(JX,K)
      ZZZ(K)=0.7*0.4 + ZVEC(JX,K)
      SUM=SUM+ZZZ(K)**2
  3   CONTINUE
      SUM2=0.0
      DO 4 K=1,NS
      ZZZ(K)=ZZZ(K)/SQRT(SUM)
      SUM2=SUM2+(ZVEC(JX,K)-ZZZ(K))**2
  4   CONTINUE
      SUM2=SQRT(SUM2)
      SUM3=0.0
      DO 5 K=1,NS
      ZVEC2(JX,K)=ZVEC(JX,K)+(XINC/SUM2)*(ZZZ(K)-ZVEC(JX,K))
      SUM3=SUM3+ZVEC2(JX,K)**2
  5   CONTINUE
      DO 6 K=1,NS
      ZVEC2(JX,K)=ZVEC2(JX,K)/SQRT(SUM3)
  6   CONTINUE
!
      DO 488 K=1,NS
      UUU(IJL,K)=ZVEC2(JX,K)
  488 CONTINUE
      DO 489 I=1,NP
      SUM=0.0
      DO 490 K=1,NS
      SUM=SUM+XMAT(I,K)*ZVEC2(JX,K)
  490 CONTINUE
!
!  SAVE PROJECTION VECTORS -- LEGISLATOR BY ROLL CALL MATRIX
!
      LLL(I)=I
      XXX(I)=SUM
      MM(I)=LDATA(I,JX)
      IF(LDATA(I,JX).EQ.0)MM(I)=9
  489 CONTINUE
!
!  SORT PROJECTION VECTOR (Y-HAT)
!
!
      CALL KPRSORT(XXX,NP,LLL)
      DO 414 I=1,NP
      MVOTE(I)=MM(LLL(I))
  414 CONTINUE
!
!
!  CALCULATE CLASSIFICATION ERRORS FOR BEST SOLUTION FROM PHASE 1
!
!
      JCH=0
      JEH=0
      JCL=0
      JEL=0
      IROTC=0
      CALL JAN1PT(NP,NRCALL,NP,NRCALL,NS,NDUAL,JX,XMAT,XXX,MVOTE,WS, &
                  LLV,LLVB,LLE,LLEB,LERROR, &
                  ZS,JCH,JEH,JCL,JEL,IROTC,KCUT,LCUT,LLL, &
                  XJCH,XJEH,XJCL,XJEL)
!
      IF(JEH+JEL.LT.JXERROR)THEN
         KDOWN=KDOWN+1
         JXERROR=JEH+JEL
         DO 997 K=1,NS
         ZVEC(JX,K)=ZVEC2(JX,K)
  997    CONTINUE
         WSNEW=WS(JX)
         KPCUT=KCUT
         LPCUT=LCUT
         GO TO 998
      ENDIF
      IF(JEH+JEL.EQ.JXERROR)KEQUAL=KEQUAL+1
      IF(JEH+JEL.GT.JXERROR)KUP=KUP+1
!
  998 CONTINUE
!
      DEALLOCATE(LLL)
      DEALLOCATE(MVOTE)
      DEALLOCATE(LLV)
      DEALLOCATE(LLVB)
      DEALLOCATE(LLE)
      DEALLOCATE(LLEB)
      DEALLOCATE(MM)
      DEALLOCATE(XJCH)
      DEALLOCATE(XJEH)
      DEALLOCATE(XJCL)
      DEALLOCATE(XJEL)
      DEALLOCATE(ZS)
      DEALLOCATE(UUU)
      DEALLOCATE(XXX)
      DEALLOCATE(ZZZ)
      DEALLOCATE(ZVEC2)
      RETURN
      END
!
!  ************************************************************************
!    SUBROUTINE KPZVECSTRT -- PRODUCES STARTS FOR THE NORMAL VECTORS USING
!                           SIMPLE OLS
!
!  ************************************************************************
!
      SUBROUTINE KPZVECSTRT(NP,NRCALL,NS,NDUAL,XMAT,ZVEC,LDATA,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION XMAT(NP,25),ZVEC(NRCALL,25),LDATA(NP,NRCALL)
!
      INTEGER, ALLOCATABLE :: MM(:)
      INTEGER, ALLOCATABLE :: LLL(:)
      INTEGER, ALLOCATABLE :: MDATA(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: XXX(:)
      DOUBLE PRECISION, ALLOCATABLE :: FV1(:)
      DOUBLE PRECISION, ALLOCATABLE :: FV2(:)
      DOUBLE PRECISION, ALLOCATABLE :: VCOV(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: UL(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: WVEC2(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZMAT2(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ZVEC2(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: BB(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: YY(:)
      DOUBLE PRECISION, ALLOCATABLE :: V(:)
      ALLOCATE(MM(NP))
      ALLOCATE(LLL(NP))
      ALLOCATE(MDATA(NP,NRCALL))
      ALLOCATE(XXX(NRCALL))
      ALLOCATE(FV1(NP))
      ALLOCATE(FV2(NP))
      ALLOCATE(VCOV(25,25))
      ALLOCATE(UL(25,25))
      ALLOCATE(WVEC2(25))
      ALLOCATE(ZMAT2(25,25))
      ALLOCATE(ZVEC2(NRCALL,25))
      ALLOCATE(BB(25,NP))
      ALLOCATE(YY(NP))
      ALLOCATE(V(25))
!
!  210 FORMAT(I5,10F12.3)
! 1012 FORMAT(' DECOMPOSITION OF LEGISLATOR MATRIX',3I4)
! 1091 FORMAT(' INVERSE MATRIX ERROR',F10.4)
! 1107 FORMAT(' TOTAL NONMISSING AND MISSING OBSERVATIONS',2I8)
!
!  FILL IN MISSING MATRIX ENTRIES
!
!  FIND 10 CLOSEST VOTERS
!
!  IF MISSING VOTE IMPUTE LIKELIEST CHOICE USING NEAREST 5 DISTANCES
!
!
      NMISS=0
      DO 78 JX=1,NRCALL
      DO 788 I=1,NP
      IF(LDATA(I,JX).EQ.0)NMISS=NMISS+1
      MDATA(I,JX)=LDATA(I,JX)
      DO 79 II=1,NP
      SUM=0.0
      DO 80 K=1,NS
      SUM=SUM+(XMAT(I,K)-XMAT(II,K))**2
  80  CONTINUE
      FV1(II)=SUM
      LLL(II)=II
  79  CONTINUE
      CALL KPRSORT(FV1,NP,LLL)
      MYES=0
      MNO=0
      MMISS=0
      DO 81 K=1,10
      IF(LDATA(LLL(K),JX).EQ.0)GO TO 81
      MMISS=MMISS+1
      IF(LDATA(LLL(K),JX).EQ.1)MYES=MYES+1
      IF(LDATA(LLL(K),JX).EQ.6)MNO =MNO +1
      IF(K.GT.5.AND.MMISS.GT.1)GO TO 82
  81  CONTINUE
  82  CONTINUE
      IF(MYES.GE.MNO)MDATA(I,JX)=1
      IF(MYES.LT.MNO)MDATA(I,JX)=6
      IF(LDATA(I,JX).NE.0)MDATA(I,JX)=LDATA(I,JX)
  788 CONTINUE
  78  CONTINUE
      KMISS=NP*NRCALL-NMISS
!      IF(IPRINT.EQ.1)WRITE(23,1107)KMISS,NMISS
!
!
!    (X'X)
!
      DO 38 K=1,NS
      DO 39 L=1,NS
      SUM=0.0
      DO 40 I=1,NP
      SUM=SUM+XMAT(I,K)*XMAT(I,L)
  40  CONTINUE
      VCOV(K,L)=SUM
  39  CONTINUE
  38  CONTINUE
!
!  EIGENVECTOR-EIGENVALUE DECOMPOSITION OF LEGISLATOR COORDINATES
!
      CALL KPRS(25,NS,VCOV,WVEC2,1,ZMAT2,FV1,FV2,IER)
!      IF(IPRINT.EQ.1)THEN
!         WRITE(11,1012)NS,NP,IER
!         DO 37 I=1,NS
!         WRITE(11,210)I,WVEC2(I)
!  37     CONTINUE
!      ENDIF
!
!  (X'X)-1
!
      DO 83 I=1,NS
      DO 83 K=1,NS
      SUM=0.0
      DO 84 J=1,NS
      IF(ABS(WVEC2(NS+1-J)).GT..0001)THEN
          SUM=SUM+ZMAT2(K,NS+1-J)*(1.0/WVEC2(NS+1-J))*ZMAT2(I,NS+1-J)
      ENDIF
  84  CONTINUE
  83  UL(I,K)=SUM
!
!  MATRIX INVERSION CHECK  (X'X)-1(X'X) = I
!
      ASUM=0.0
      DO 933 I=1,NS
      DO 933 J=1,NS
      SUM=0.0
      DO 944 K=1,NS
      SUM=SUM+UL(J,K)*VCOV(K,I)
  944 CONTINUE
      IF(I.EQ.J)ASUM=ASUM+ABS(1.0-SUM)
      IF(I.NE.J)ASUM=ASUM+ABS(SUM)
  933 CONTINUE
!     IF(ASUM.GT..01.AND.IPRINT.EQ.1)WRITE(11,1091)ASUM
!
!  (X'X)-1*X'
!
      DO 85 I=1,NP
      DO 85 J=1,NS
      SUM=0.0
      DO 86 JJ=1,NS
 86   SUM=SUM+UL(J,JJ)*XMAT(I,JJ)
 85   BB(J,I)=SUM
!
      DO 93 JX=1,NRCALL
      KYES=0
      KNO=0
      YBAR=0.0
!
!  GET Y-VECTOR -- YES'S AND NO'S SUCH THAT SUM OF Y = 0 -- ELIMINATES
!         THE INTERCEPT TERM -- THE IMPUTED YES/NO FROM ABOVE IS USED
!         FOR MISSING DATA SO THAT THE SAME X MATRIX CAN BE USED FOR
!         EVERY ROLL CALL
!
      DO 92 I=1,NP
      IF(MDATA(I,JX).EQ.1)KYES=KYES+1
      IF(MDATA(I,JX).EQ.6)KNO=KNO+1
  92  CONTINUE
      DO 110 I=1,NP
      IF(MDATA(I,JX).EQ.1)YY(I)=1.0/FLOAT(KYES)
      IF(MDATA(I,JX).EQ.6)YY(I)=-1.0/FLOAT(KNO)
  110 CONTINUE
!
!  BETA-HAT = V(.) = (X'X)-1*X'Y = A-1*U'Y
!
      DO 102 K=1,NS
      SUM=0.0
      DO 87 J=1,NP
  87  SUM=SUM+BB(K,J)*YY(J)
  102 V(K)=SUM
!
!  NORMALIZE BETA VECTOR SO ITS OF UNIT LENGTH -- THIS DEFINES A POINT
!    ON THE UNIT HYPERSPHERE SO THAT THE BETA-VECTOR CAN BE USED DIRECTLY
!    TO CALCULATE THE PROJECTION VECTOR Y-HAT BELOW
!
      SUM=0.0
      DO 103 K=1,NS
      SUM=SUM+V(K)**2
  103 CONTINUE
!
!
      DO 104 K=1,NS
      V(K+NS)=V(K)/SQRT(SUM)
!
!  SELECT VECTOR MAPPING SUCH THAT IT IS ON THE + HEMISPHERE
!
      IF(V(1).LT.0.0)V(K+NS)=V(K+NS)*(-1.0)
      ZVEC(JX,K)=V(K+NS)
  104 CONTINUE
!
  93  CONTINUE
!
      DEALLOCATE(MM)
      DEALLOCATE(LLL)
      DEALLOCATE(MDATA)
      DEALLOCATE(XXX)
      DEALLOCATE(FV1)
      DEALLOCATE(FV2)
      DEALLOCATE(VCOV)
      DEALLOCATE(UL)
      DEALLOCATE(WVEC2)
      DEALLOCATE(ZMAT2)
      DEALLOCATE(ZVEC2)
      DEALLOCATE(BB)
      DEALLOCATE(YY)
      DEALLOCATE(V)
      RETURN
      END
!
!  ************************************************************************
!    KPEDITH SUBROUTINE--PERFORMS ONE DIMENSION NOMINAL UNFOLDING -- FINDS
!                      OPTIMAL CLASSIFICATIONS FOR MATRIX OF SENATE
!                      PAIRS
!  ************************************************************************
!
      SUBROUTINE KPEDITH(NP,NRCALL,NS,NDUAL,XMAT,X,XPT,ZPT,AB,KTOTC, &
                       KCUTTER,LCUTTER,LERROR,LDATA,MSUM,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION X(NDUAL),XYM(NRCALL),XNM(NRCALL),YSS(NDUAL), &
                KA(NDUAL),WS(NDUAL),L(NDUAL),LL(NDUAL), &
                LERROR(NP,NRCALL),XMAT(NP,25),ZS(NDUAL), &
                LLV(NDUAL),LLE(NDUAL),LLVB(NDUAL),LLEB(NDUAL), &
                KKA(NDUAL),KYES(NRCALL),KNO(NRCALL),XCTL(50), &
                LV(NDUAL),MM(NDUAL),ZPT(NRCALL),XPT(NDUAL), &
                YS(NDUAL),KCUTTER(NRCALL),LCUTTER(NRCALL), &
                XJCH(25),XJEH(25),XJCL(25),XJEL(25), &
                YSJAVA(NDUAL),MMJAVA(NDUAL),LJAVA(NDUAL), &
                LDATA(NP,NRCALL)
!
!  330 FORMAT(' WARNING--MISMATCH ON NUMBER OF VOTES READ',2I5)
!  340 FORMAT(' WARNING--MISMATCH ON ERROR PERCENTAGES',I5,2F7.3)
!  825 FORMAT(I4,I5,2I7,6F7.3)
! 8250 FORMAT(I3,' ROLL CALLS ',I3,2I8,5F7.3)
! 8251 FORMAT(I3,' ROLL CALLS ',I3,2I8,5F9.5)
! 8252 FORMAT(I3,' LEGISLATORS',I3,2I8,8F9.5)
! 8253 FORMAT(I3,' LEGISLATORS',I3,2I8,6F7.3)
!
      CALL ECHOEVENT(12)
      CALL FLUSHCON()
      CALL PROCEVENT()
      KSTOPR=1
      KSTOP=14
      NV=NRCALL
      DO 1 I=1,NP
      YSS(I)=X(I)
      XPT(I)=X(I)
      L(I)=I
      LL(I)=I
!      WRITE(23,6655)I,X(I),YSS(I),XPT(I),L(I),LL(I)
! 6655 FORMAT(I4,3F10.4,2I4)
  1   CONTINUE
!
      CALL KPRSORT(YSS,NP,LL)
!
!
      ITR=0
  121 CONTINUE
      ITR=ITR+1
      XLOW=YSS(1)
      XHIGH=YSS(NP)
      KT=0
      KTT=0
      JCH=0
      JEH=0
      JCL=0
      JEL=0
      MSUM=0
      NSUM=0
      IVOT=0
      NUNAM=0
!
!
!  ROLL CALL LOOP -- ESTIMATE BEST CUTTING POINT GIVEN FIXED LEGISLATOR
!                    CONFIGURATION
!
!      CALL ECHOEVENT(13)
!      CALL FLUSHCON()
!      CALL PROCEVENT()
      DO 600 IIII=1,NV
      IVOT=IVOT+1
      ESUM=0.0
      FSUM=0.0
      KSUM=0
      LSUM=0
!
!  RECODE AND COMPUTE YES AND NO MEANS
!
      DO 16 J=1,NP
      LV(J)=LDATA(J,IVOT)
      IF(LV(J).EQ.1.OR.LV(J).EQ.2.OR.LV(J).EQ.3)KK=1
      IF(LV(J).EQ.4.OR.LV(J).EQ.5.OR.LV(J).EQ.6)KK=6
      IF(LV(J).EQ.0.OR.LV(J).EQ.7.OR.LV(J).EQ.8.OR.LV(J).EQ.9)KK=9
      KKA(J)=KK
      IF(KK.EQ.1)ESUM=ESUM+XPT(J)
      IF(KK.EQ.1)KSUM=KSUM+1
      IF(KK.EQ.6)LSUM=LSUM+1
      IF(KK.EQ.6)FSUM=FSUM+XPT(J)
  16  CONTINUE
      DO 255 J=1,NP
  255 KA(J)=KKA(LL(J))
      KYES(IVOT)=KSUM
      KNO(IVOT)=LSUM
!
!  CHECK FOR UNANIMOUS VOTES AND DISCARD THEM
!
      IF(KSUM.EQ.0.OR.LSUM.EQ.0)XYM(IVOT)=99.0
      IF(KSUM.EQ.0.OR.LSUM.EQ.0)XNM(IVOT)=99.0
      IF(KSUM.EQ.0.OR.LSUM.EQ.0)NUNAM=NUNAM+1
      IF(KSUM.EQ.0.OR.LSUM.EQ.0)GO TO 600
!
!  STORE YES AND NO MEANS
!
      XYM(IVOT)=ESUM/FLOAT(KSUM)
      XNM(IVOT)=FSUM/FLOAT(LSUM)
!
!  CUMULATIVE SUM OF MAJORITY VOTE BY ROLL CALL
!
      IF((KSUM-LSUM).LT.0)GO TO 201
  202 MSUM=MSUM+KSUM
      GO TO 203
  201 MSUM=MSUM+LSUM
  203 CONTINUE
!
!  BEGIN JANICE LOOP FOR ROLL CALLS
!
!  GET ONE POINT RESULTS
!
      JCH=0
      JEH=0
      JCL=0
      JEL=0
      KJAVA=0
      DO 1663 JAVA=1,NP
      IF(KA(JAVA).NE.9)THEN
        KJAVA=KJAVA+1
        YSJAVA(KJAVA)=YSS(JAVA)
        MMJAVA(KJAVA)=KA(JAVA)
        LJAVA(KJAVA)=LL(JAVA)
      ENDIF
 1663 CONTINUE
      YSJAVA(KJAVA+1)=YSJAVA(KJAVA)+.01
      MMJAVA(KJAVA+1)=9
      LJAVA(KJAVA+1)=NP+1
      NV1=KJAVA+1
      IROTC=0
!
      CALL JAN1PT(NV1,NV,NP,NRCALL,NS,NDUAL,IVOT,XMAT,YSJAVA,MMJAVA,WS, &
                  LLV,LLVB,LLE,LLEB,LERROR, &
                  ZS,JCH,JEH,JCL,JEL,IROTC,KCUT,LCUT,LJAVA, &
                  XJCH,XJEH,XJCL,XJEL)
      KT=KT+JCH+JCL+JEH+JEL
      KTT=KTT+JEH+JEL
      KTOTC=KT
      KCUTTER(IVOT)=KCUT
      LCUTTER(IVOT)=LCUT
!
!  END OF ROLL CALL LOOP
!
  600 CONTINUE
!
!
      XT=FLOAT(KT)
      XTT=FLOAT(KTT)
      AB=1.0-(XTT/XT)
      XSUM=FLOAT(MSUM)
      XSUM=XSUM/XT
      YSUM=AB-XSUM
      PRE1=YSUM/(1.0-XSUM)
!
!  WRITE OUT: ITERATION #; NUMBER OF VOTES;
!             TOTAL CHOICES; TOTAL ERROR CHOICES; PERCENT CORRECT;
!             PERCENT MAJORITY MODEL; PROPORTIONAL REDUCTION IN ERROR
!
!      IF(NS.GT.1.AND.IPRINT.EQ.1)THEN
!         WRITE(21,825)ITR,IVOT,KT,KTT,AB,XSUM,PRE1,XLOW,XHIGH
!      ENDIF
!      IF(NS.EQ.1.AND.IPRINT.EQ.1)THEN
!         WRITE(21,8251)ITR,NS,KTT,KT,1.0-AB,AB,PRE1
!      ENDIF
!      IF(IVOT.NE.NV)THEN
!         WRITE(*,330)IVOT,NV
!         STOP
!      ENDIF
      XCTL(ITR)=AB
!
!
!
!  WRITE ROLL CALL MARGINS AND ERRORS TO DISK
!
      DO 130 I=1,NV
      IF(KYES(I).LE.KNO(I))KMIN=KYES(I)
      IF(KYES(I).GT.KNO(I))KMIN=KNO(I)
      KRITE=LLV(I)+LLVB(I)
      KWRONG=LLE(I)+LLEB(I)
      IF((KRITE+KWRONG).GT.0.0)XBAD=FLOAT(KWRONG)/FLOAT(KRITE+KWRONG)
      IF(KYES(I).EQ.0.OR.KNO(I).EQ.0)XBAD=0.0
      IF(KYES(I).EQ.0.OR.KNO(I).EQ.0)ZS(I)=0.0
      XMIN=0.0
      IF((KYES(I)+KNO(I)).GT.0)XMIN=FLOAT(KMIN)/FLOAT(KYES(I)+KNO(I))
!      IF(ABS(XBAD-ZS(I)).GT..001)THEN
!         WRITE(*,340)I,XBAD,ZS(I)
!         STOP
!      ENDIF
      AAA=ABS(WS(I)-XLOW)
      BBB=ABS(WS(I)-XHIGH)
      IF(XBAD.GT.XMIN.AND.AAA.LT.BBB)WS(I)=XLOW
      IF(XBAD.GT.XMIN.AND.AAA.GE.BBB)WS(I)=XHIGH
      IF(XBAD.GT.XMIN)XBAD=XMIN
      IF(KYES(I).EQ.0.OR.KNO(I).EQ.0)WS(I)=0.0
      IF(KSTOPR.EQ.1)GO TO 130
!
!  WRITE OUT CONGRESS #, VOTE #, YES #, NO #, PROPORTION IN MINORITY,
!            PROPORTION ERROR, CUT POINT
!
!      WRITE(24,800)I,KYES(I),KNO(I),XMIN,XBAD,WS(I),XYM(I),XNM(I)
!  800 FORMAT(I5,2I4,5F7.3)
  130 CONTINUE
!
!
!
!  BEGIN JANICE LOOP FOR LEGISLATORS
!
!
!
!      CALL ECHOEVENT(14)
!      CALL FLUSHCON()
!      CALL PROCEVENT()
      ITR=ITR+1
      DO 124 I=1,NV
      YS(I)=WS(I)
      ZPT(I)=WS(I)
  124 L(I)=I
!
!  SORT ROLL CALL MIDPOINTS
!
      CALL KPRSORT(YS,NV,L)
!
      KT=0
      KTT=0
      JCH=0
      JCL=0
      JEH=0
      JEL=0
      DO 9999 I=1,NP
      IVOT=I
!
!
      DO 166 J=1,NV
      LV(J)=LDATA(IVOT,J)
      IF(LV(J).EQ.1.OR.LV(J).EQ.2.OR.LV(J).EQ.3)KK=1
      IF(LV(J).EQ.4.OR.LV(J).EQ.5.OR.LV(J).EQ.6)KK=6
      IF(LV(J).EQ.0.OR.LV(J).EQ.7.OR.LV(J).EQ.8.OR.LV(J).EQ.9)KK=9
      IF(XYM(J).EQ.99.0.OR.XNM(J).EQ.99.0)KK=9
      KA(J)=KK
  166 CONTINUE
!
!  DETERMINE DIRECTIONALITY FOR EACH MIDPOINT -- STORE IN MM VECTOR
!
!
!  CUMULATIVE SUM OF MAJORITY VOTE BY INDIVIDUALS
!
      DO 161 J=1,NV
!      IF(XYM(L(J))-XNM(L(J)))163,162,162
!  163 KCUT=1
!      LCUT=6
!      GO TO 164
!  162 KCUT=6
!      LCUT=1
       KCUT=KCUTTER(L(J))
       LCUT=LCUTTER(L(J))
!
!  NOTE THAT THIS CODING OF MM(.) PRODUCES THE PATTERNS
!
!          6666666666...
!          1666666666...
!          1166666666...
!          1116666666...
!          1111666666...
!          1111166666...
!
!  ETC., IF THE LEGISLATOR IS VOTING PERFECTLY
!
  164 IF(KA(L(J)).EQ.KCUT)MM(J)=6
      IF(KA(L(J)).EQ.LCUT)MM(J)=1
      IF(KA(L(J)).EQ.9)MM(J)=9
      IF(KYES(L(J)).LT.KNO(L(J)).AND.KA(L(J)).EQ.6)NSUM=NSUM+1
      IF(KYES(L(J)).GE.KNO(L(J)).AND.KA(L(J)).EQ.1)NSUM=NSUM+1
  161 CONTINUE
!
!  GET ONE POINT RESULTS
!
      JCH=0
      JEH=0
      JCL=0
      JEL=0
      KJAVA=0
      DO 1661 JAVA=1,NV
      IF(MM(JAVA).NE.9)THEN
        KJAVA=KJAVA+1
        YSJAVA(KJAVA)=YS(JAVA)
        MMJAVA(KJAVA)=MM(JAVA)
        LJAVA(KJAVA)=L(JAVA)
      ENDIF
 1661 CONTINUE
!
!  TRICK JANICE TO FIX ROLL CALL PROBLEM
!
      YSJAVA(KJAVA+1)=YSJAVA(KJAVA)+.01
      MMJAVA(KJAVA+1)=9
      LJAVA(KJAVA+1)=NV+1
      NV1=KJAVA+1
      IROTC=1
!
      CALL JAN1PT(NV1,NP,NP,NRCALL,NS,NDUAL,IVOT,XMAT,YSJAVA,MMJAVA,WS, &
                  LLV,LLVB,LLE,LLEB,LERROR, &
                  ZS,JCH,JEH,JCL,JEL,IROTC,KCUT,LCUT,LJAVA, &
                  XJCH,XJEH,XJCL,XJEL)
      KT=KT+JCH+JCL+JEH+JEL
      KTT=KTT+JEH+JEL
!
!  END OF LEGISLATOR LOOP
!
 9999 CONTINUE
!
!  CALCULATE REGRESSION OF PREVIOUS LEGISLATOR CONFIGURATION ON
!        CURRENT LEGISLATOR CONFIGURATION
!
      ASUM=0.0
      BSUM=0.0
      CSUM=0.0
      DSUM=0.0
      ESUM=0.0
      KKNP=0
      DO 125 I=1,NP
      LL(I)=I
!
      YSS(I)=WS(I)
      KKNP=KKNP+1
      ASUM=ASUM+XPT(I)*WS(I+NP)
      BSUM=BSUM+XPT(I)
      CSUM=CSUM+WS(I+NP)
      DSUM=DSUM+XPT(I)*XPT(I)
      ESUM=ESUM+WS(I+NP)*WS(I+NP)
      XPT(I)=WS(I)
  125 CONTINUE
      AA=FLOAT(KKNP)*ASUM-BSUM*CSUM
      BB=FLOAT(KKNP)*DSUM-BSUM*BSUM
      CC=FLOAT(KKNP)*ESUM-CSUM*CSUM
      IF(BB*CC.GT.0.0)RR=(AA*AA)/(BB*CC)
      BETA=AA/CC
      ALFA=(BSUM-BETA*CSUM)/FLOAT(KKNP)
      XT=FLOAT(KT)
      XTT=FLOAT(KTT)
      AB=1.0-(XTT/XT)
      XSUM=FLOAT(NSUM)/FLOAT(KT)
      YSUM=AB-XSUM
      PRE=YSUM/(1.0-XSUM)
      NUNP=NP-KKNP
!
!  WRITE OUT: ITERATION #; NUMBER OF LEGISLATORS;
!             TOTAL CHOICES; TOTAL ERROR CHOICES; PERCENT CORRECT;
!             PERCENT MAJORITY MODEL; PROPORTIONAL REDUCTION IN ERROR
!
!      IF(NS.GT.1.AND.IPRINT.EQ.1)THEN
!         WRITE(21,825)ITR,NP,KT,KTT,AB,XSUM,PRE,ALFA,BETA,RR
!      ENDIF
!      IF(NS.EQ.1.AND.IPRINT.EQ.1)THEN
!         WRITE(21,8252)ITR,NS,KTT,KT,1.0-AB,AB,PRE,SQRT(RR)
!      ENDIF
      XCTL(ITR)=AB
!
!  WRITE LEGISLATOR MARGINS TO DISK
!
      DO 128 I=1,NP
!      WS(I+NP)=WS(I+NP)*BETA+ALFA
!      YSS(I)=YSS(I)*BETA+ALFA
      KHIGH=LLV(I)+LLE(I)
      KLOW=LLVB(I)+LLEB(I)
      IF(KHIGH.LE.KLOW)XMIN=FLOAT(KHIGH)/FLOAT(KHIGH+KLOW)
      IF(KHIGH.GT.KLOW)XMIN=FLOAT(KLOW)/FLOAT(KHIGH+KLOW)
      XBAD=FLOAT(LLE(I)+LLEB(I))/FLOAT(KHIGH+KLOW)
      AAA=ABS(WS(I)-XLOW)
      BBB=ABS(WS(I)-XHIGH)
      IF(XBAD.GT.XMIN.AND.AAA.LT.BBB)WS(I)=XLOW
      IF(XBAD.GT.XMIN.AND.AAA.GE.BBB)WS(I)=XHIGH
      IF(XBAD.GT.XMIN)XBAD=XMIN
  729 CONTINUE
      IF(KSTOPR.EQ.1)GO TO 128
!      WRITE(23,800)I,KHIGH,KLOW,XMIN,XBAD,WS(I)
  128 CONTINUE
      CALL KPRSORT(YSS,NP,LL)
      AA=(YSS(1)+YSS(NP))/2.0
      BB=YSS(NP)-AA
      DO 730 I=1,NP
      YSS(I)=(YSS(I)-AA)/BB
      XPT(I)=(XPT(I)-AA)/BB
      WS(I)=(WS(I)-AA)/BB
      WS(I+NP)=WS(I)
  730 CONTINUE
      IF(ITR.LE.5)GO TO 121
      IF(KSTOPR.EQ.0)RETURN
      IF((XCTL(ITR)-XCTL(ITR-2)).LE..0001)KSTOPR=0
      IF(ITR.LE.KSTOP)GO TO 121
      RETURN
      END
!
!
!  ***********************************************************************
!     SUBROUTINE KPPERM---GENERATES THE SEQUENCE OF PERMUTATIONS OF N
!         DISTINGUISHABLE OBJECTS, ONE AT A TIME, IN LEXOGRAPHIC ORDER.
!  ***********************************************************************
!
!
      SUBROUTINE KPPERM(N,K,M)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION K(N),M(N)
!
!  AT FIRST CALL M(1)=0
!
!  K CONTAINS THE VECTOR THAT IS TO BE PERMUTED
!
      IF(M(1).NE.0)GO TO 2
      DO 1 I=2,N
  1   M(I)=1
  2   M(1)=M(1)+1
      IF(M(2).NE.1)GO TO 3
      M(2)=2
      J=K(1)
      K(1)=K(2)
      K(2)=J
      RETURN
  3   DO 4 I=2,N
      IF(M(I).NE.I)GO TO 5
  4   M(I)=1
      M(1)=0
      I=N
      GO TO 6
  5   L=M(I)
      J=K(L)
      K(L)=K(I)
      K(I)=J
      M(I)=L+1
      I=I-1
  6   L=1
  7   J=K(L)
      K(L)=K(I)
      K(I)=J
      L=L+1
      I=I-1
      IF(L.LT.I)GO TO 7
      RETURN
      END
!
!
!  ********************************************************************
!    SUBROUTINE KPSHARPEN -- PERMUTES BLOCKS OF 5-ADJACENT LEGISLATORS
!                            TO SHARPEN THE RANK ORDERING
!  ********************************************************************
!
      SUBROUTINE KPSHARPEN(NNPERM,NP,NRCALL,NS,NDUAL,KCUTTER,LCUTTER, &
                          XMAT0,ZPT,WS,LDATA,LERROR,IPRINT)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
!
      DIMENSION KCUTTER(NRCALL),LCUTTER(NRCALL),XMAT0(NP,25), &
                ZPT(NRCALL),WS(NDUAL),LDATA(NP,NRCALL),  &
                LERROR(NP,NRCALL)
!
      INTEGER, ALLOCATABLE :: KPERM(:)
      INTEGER, ALLOCATABLE :: MPERM(:)
      INTEGER, ALLOCATABLE :: KBIGPERM(:,:)
      INTEGER, ALLOCATABLE :: MMJAVA(:)
      INTEGER, ALLOCATABLE :: LLV(:)
      INTEGER, ALLOCATABLE :: LLVB(:)
      INTEGER, ALLOCATABLE :: LLE(:)
      INTEGER, ALLOCATABLE :: LLEB(:)
      INTEGER, ALLOCATABLE :: L(:)
      INTEGER, ALLOCATABLE :: LL(:)
      INTEGER, ALLOCATABLE :: LJAVA(:)
      INTEGER, ALLOCATABLE :: LV(:)
      INTEGER, ALLOCATABLE :: KKA(:)
      INTEGER, ALLOCATABLE :: KA(:)
      INTEGER, ALLOCATABLE :: LLSAVE(:)
      INTEGER, ALLOCATABLE :: LTEST(:)
      INTEGER, ALLOCATABLE :: LORDER(:)
      INTEGER, ALLOCATABLE :: MERROR(:,:)
      INTEGER, ALLOCATABLE :: MMSAVE(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: YSS(:)
      DOUBLE PRECISION, ALLOCATABLE :: YSJAVA(:)
      DOUBLE PRECISION, ALLOCATABLE :: ZS(:)
      DOUBLE PRECISION, ALLOCATABLE :: YSSS(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJCH(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJEH(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJCL(:)
      DOUBLE PRECISION, ALLOCATABLE :: XJEL(:)
      ALLOCATE(KPERM(5))
      ALLOCATE(MPERM(5))
      ALLOCATE(KBIGPERM(120,5))
      ALLOCATE(MMJAVA(NDUAL))
      ALLOCATE(LLV(NDUAL))
      ALLOCATE(LLVB(NDUAL))
      ALLOCATE(LLE(NDUAL))
      ALLOCATE(LLEB(NDUAL))
      ALLOCATE(L(NDUAL))
      ALLOCATE(LL(NDUAL))
      ALLOCATE(LJAVA(NDUAL))
      ALLOCATE(LV(NDUAL))
      ALLOCATE(KKA(NDUAL))
      ALLOCATE(KA(NDUAL))
      ALLOCATE(LLSAVE(NDUAL))
      ALLOCATE(LTEST(2*NDUAL))
      ALLOCATE(LORDER(2*NDUAL))
      ALLOCATE(MERROR(NP,NRCALL))
      ALLOCATE(MMSAVE(NP,NDUAL))
      ALLOCATE(YSS(NDUAL))
      ALLOCATE(YSJAVA(NDUAL))
      ALLOCATE(ZS(NDUAL))
      ALLOCATE(YSSS(NDUAL))
      ALLOCATE(XJCH(25))
      ALLOCATE(XJEH(25))
      ALLOCATE(XJCL(25))
      ALLOCATE(XJEL(25))
!
!  100 FORMAT(I6,20I3)
!  101 FORMAT(I4,F10.4,3I4)
!  102 FORMAT(' INITIAL ERROR  ',2I7)
!  103 FORMAT(' BETTER SOLUTION',4I7,I5,10I4)
!  104 FORMAT(I4,2F10.4)
!  105 FORMAT(' SAME SOLUTION  ',4I7)
! 8250 FORMAT(I4,' ROLL CALLS ',I3,2I8,3F7.3,10I4)
!
!  KPERM(.) IS THE VECTOR TO BE PERMUTED
!  MPERM(.) IS A WORK VECTOR.  AT THE FIRST CALL OF KPPERM(N,K,M),
!    MPERM(1)=0.  IT IS THEN USED AS A FLAG TO DETERMINE WHEN
!    THE LAST OF THE N! PERMUTATIONS ARE COMPLETED.  IF SO,
!    THEN MPERM(1)=0 IF THE LAST PERMUTATION IS PASSED BACK
!
      NV=NRCALL
      N=NNPERM
      KBEFORE=0
      DO 9999 IIJJ=1,NP-N
!
!  INITIALIZE ERROR
!
      KINITIAL=0
      DO 20 J=1,NRCALL
      DO 20 I=1,NP
      KINITIAL=KINITIAL+LERROR(I,J)
      MERROR(I,J)=LERROR(I,J)
  20  CONTINUE
!
!      IF(IPRINT.EQ.1)WRITE(23,102)IIJJ,KINITIAL
      MPERM(1)=0
      DO 1 I=1,N
      KPERM(I)=I
  1   CONTINUE
!
      KKK=0
 999  CONTINUE
      KKK=KKK+1
      CALL KPPERM(N,KPERM,MPERM)
      DO 2 I=1,N
      KBIGPERM(KKK,I)=KPERM(I)
  2   CONTINUE
!
!  CHECK CURRENT PERMUTATION OF THE LEGISLATORS
!
      DO 11 I=1,NP
      YSS(I)=XMAT0(I,1)
      YSSS(I)=XMAT0(I,1)
      L(I)=I
      LL(I)=I
  11  CONTINUE
!
      CALL KPRSORT(YSS,NP,LL)
      CALL KPRSORT(YSSS,NP,L)
!
!  PERMUTE THE ORDERING BY "TRICKING" LL(.) USING KPERM(.)
!
      DO 12 I=1,N
      LLSAVE(I)=LL(KPERM(I)+KBEFORE)
  12  CONTINUE
      DO 13 I=1,N
      LL(I+KBEFORE)=LLSAVE(I)
  13  CONTINUE
      DO 14 I=1,NP
!      WRITE(22,101)I,YSS(I),LL(I),L(I)
      MMSAVE(I,KKK)=LL(I)
  14  CONTINUE
      KT=0
      KTT=0
      JCH=0
      JEH=0
      JCL=0
      JEL=0
      MSUM=0
      NSUM=0
      IVOT=0
!
!
!  ROLL CALL LOOP -- ESTIMATE BEST CUTTING POINT GIVEN FIXED LEGISLATOR
!                    CONFIGURATION
!
      DO 600 IIII=1,NV
      IVOT=IVOT+1
      KSUM=0
      LSUM=0
!
!  RECODE AND COMPUTE YES AND NO MEANS
!
      DO 16 J=1,NP
      LV(J)=LDATA(J,IVOT)
      IF(LV(J).EQ.1.OR.LV(J).EQ.2.OR.LV(J).EQ.3)KK=1
      IF(LV(J).EQ.4.OR.LV(J).EQ.5.OR.LV(J).EQ.6)KK=6
      IF(LV(J).EQ.0.OR.LV(J).EQ.7.OR.LV(J).EQ.8.OR.LV(J).EQ.9)KK=9
      KKA(J)=KK
      IF(KK.EQ.1)KSUM=KSUM+1
      IF(KK.EQ.6)LSUM=LSUM+1
  16  CONTINUE
      DO 255 J=1,NP
  255 KA(J)=KKA(LL(J))
!
!  CHECK FOR UNANIMOUS VOTES AND DISCARD THEM
!
      IF(KSUM.EQ.0.OR.LSUM.EQ.0)GO TO 600
!
!  CUMULATIVE SUM OF MAJORITY VOTE BY ROLL CALL
!
      IF((KSUM-LSUM).LT.0)GO TO 201
  202 MSUM=MSUM+KSUM
      GO TO 203
  201 MSUM=MSUM+LSUM
  203 CONTINUE
!
!  BEGIN JANICE LOOP FOR ROLL CALLS
!
!  GET ONE POINT RESULTS
!
      JCH=0
      JEH=0
      JCL=0
      JEL=0
      KJAVA=0
      DO 1663 JAVA=1,NP
      IF(KA(JAVA).NE.9)THEN
        KJAVA=KJAVA+1
        YSJAVA(KJAVA)=YSS(JAVA)
        MMJAVA(KJAVA)=KA(JAVA)
        LJAVA(KJAVA)=LL(JAVA)
      ENDIF
 1663 CONTINUE
      YSJAVA(KJAVA+1)=YSJAVA(KJAVA)+.01
      MMJAVA(KJAVA+1)=9
      LJAVA(KJAVA+1)=NP+1
      NV1=KJAVA+1
      IROTC=0
      CALL JAN1PT(NV1,NV,NP,NRCALL,NS,NDUAL,IVOT,XMAT,YSJAVA,MMJAVA,WS, &
                  LLV,LLVB,LLE,LLEB,LERROR, &
                  ZS,JCH,JEH,JCL,JEL,IROTC,KCUT,LCUT,LJAVA, &
                  XJCH,XJEH,XJCL,XJEL)
      KT=KT+JCH+JCL+JEH+JEL
      KTT=KTT+JEH+JEL
      KTOTC=KT
      KCUTTER(IVOT)=KCUT
      LCUTTER(IVOT)=LCUT
!
!  END OF ROLL CALL LOOP
!
  600 CONTINUE
!
!
      XT=FLOAT(KT)
      XTT=FLOAT(KTT)
      AB=1.0-(XTT/XT)
      XSUM=FLOAT(MSUM)
      XSUM=XSUM/XT
      YSUM=AB-XSUM
      PRE1=YSUM/(1.0-XSUM)
!
!  WRITE OUT: ITERATION #; NUMBER OF VOTES;
!             TOTAL CHOICES; TOTAL ERROR CHOICES; PERCENT CORRECT;
!             PERCENT MAJORITY MODEL; PROPORTIONAL REDUCTION IN ERROR
!
!      WRITE(*,8250)KKK,NS,KTT,KT,1.0-AB,AB,PRE1,(KBIGPERM(KKK,J),J=1,N)
      LTEST(KKK)=KTT
      LORDER(KKK)=KKK
!
!      WRITE(22,100)KKK,(KBIGPERM(KKK,J),J=1,N)
      IF(MPERM(1).NE.0)GO TO 999
!
!  IF A BETTER SOLUTION IS FOUND RESET THE ORIGINAL ORDERING
!
      CALL KPRSORT(LTEST,KKK,LORDER)
      IF(LTEST(1).LT.KINITIAL)THEN
         DO 18 I=1,NP
         YSSS(I)=XMAT0(I,1)
         LL(I)=L(I)
  18     CONTINUE
         DO 15 I=1,N
         LLSAVE(I)=LL(KBIGPERM(LORDER(1),I)+KBEFORE)
  15     CONTINUE
         DO 19 I=1,N
         LL(I+KBEFORE)=LLSAVE(I)
  19     CONTINUE
!         IF(IPRINT.EQ.1)WRITE(23,103)IIJJ,KBEFORE,KINITIAL,LTEST(1), &
!                      LORDER(1),(KBIGPERM(LORDER(1),JJ),JJ=1,N)
         DO 17 I=1,NP
         XMAT0(LL(I),1)=YSS(I)
!         WRITE(44,101)I,YSS(I),LL(I),L(I),MMSAVE(I,LORDER(1))
  17     CONTINUE
         DO 38 I=1,NP
!         WRITE(44,104)I,XMAT0(I,1),YSSS(I)
!         YSS(I)=XMAT0(I,1)
!         YSSS(I)=XMAT0(I,1)
!         L(I)=I
!         LL(I)=I
  38     CONTINUE
!
!  RESET LERROR(. , .) AND KINITIAL
!
!         CALL KPRSORT(YSS,NP,LL)
         KT=0
         KTT=0
         JCH=0
         JEH=0
         JCL=0
         JEL=0
         IVOT=0
!
!  ROLL CALL LOOP -- ESTIMATE BEST CUTTING POINT GIVEN FIXED LEGISLATOR
!                    CONFIGURATION
!
         DO 601 IIII=1,NV
         IVOT=IVOT+1
         KSUM=0
         LSUM=0
!
!  RECODE AND COMPUTE YES AND NO MEANS
!
         DO 36 J=1,NP
         LV(J)=LDATA(J,IVOT)
         IF(LV(J).EQ.1.OR.LV(J).EQ.2.OR.LV(J).EQ.3)KK=1
         IF(LV(J).EQ.4.OR.LV(J).EQ.5.OR.LV(J).EQ.6)KK=6
         IF(LV(J).EQ.0.OR.LV(J).EQ.7.OR.LV(J).EQ.8.OR.LV(J).EQ.9)KK=9
         KKA(J)=KK
         IF(KK.EQ.1)KSUM=KSUM+1
         IF(KK.EQ.6)LSUM=LSUM+1
  36     CONTINUE
         DO 256 J=1,NP
  256    KA(J)=KKA(LL(J))
!
!  CHECK FOR UNANIMOUS VOTES AND DISCARD THEM
!
         IF(KSUM.EQ.0.OR.LSUM.EQ.0)GO TO 601
!
!  BEGIN JANICE LOOP FOR ROLL CALLS
!
!  GET ONE POINT RESULTS
!
         JCH=0
         JEH=0
         JCL=0
         JEL=0
         KJAVA=0
         DO 1664 JAVA=1,NP
         IF(KA(JAVA).NE.9)THEN
           KJAVA=KJAVA+1
           YSJAVA(KJAVA)=YSS(JAVA)
           MMJAVA(KJAVA)=KA(JAVA)
           LJAVA(KJAVA)=LL(JAVA)
         ENDIF
 1664    CONTINUE
         YSJAVA(KJAVA+1)=YSJAVA(KJAVA)+.01
         MMJAVA(KJAVA+1)=9
         LJAVA(KJAVA+1)=NP+1
         NV1=KJAVA+1
         IROTC=0
         CALL JAN1PT(NV1,NV,NP,NRCALL,NS,NDUAL,IVOT,XMAT,YSJAVA,MMJAVA, &
                  WS,LLV,LLVB,LLE,LLEB,LERROR, &
                  ZS,JCH,JEH,JCL,JEL,IROTC,KCUT,LCUT,LJAVA, &
                  XJCH,XJEH,XJCL,XJEL)
         KT=KT+JCH+JCL+JEH+JEL
         KTT=KTT+JEH+JEL
         KTOTC=KT
         KCUTTER(IVOT)=KCUT
         LCUTTER(IVOT)=LCUT
!
!  END OF ROLL CALL LOOP
!
  601    CONTINUE
!
!
         XT=FLOAT(KT)
         XTT=FLOAT(KTT)
         AB=1.0-(XTT/XT)
         XSUM=FLOAT(MSUM)
         XSUM=XSUM/XT
         YSUM=AB-XSUM
         PRE1=YSUM/(1.0-XSUM)
!
!  WRITE OUT: ITERATION #; NUMBER OF VOTES;
!             TOTAL CHOICES; TOTAL ERROR CHOICES; PERCENT CORRECT;
!             PERCENT MAJORITY MODEL; PROPORTIONAL REDUCTION IN ERROR
!
!        IF(IPRINT.EQ.1)WRITE(23,8250)KKK,NS,KTT,KT,1.0-AB,AB,PRE1
         KKKCHK=0
         DO 90 IH=1,NRCALL
         DO 90 IG=1,NP
         KKKCHK=KKKCHK+LERROR(IG,IH)
  90     CONTINUE
!         IF(IPRINT.EQ.1)WRITE(23,8250)KKK,NS,KKKCHK
      ENDIF
!
!  IF A BETTER SOLUTION IS **NOT** FOUND RESET LERROR(. , .)
!
      IF(LTEST(1).GE.KINITIAL)THEN
         DO 70 J=1,NRCALL
         DO 70 I=1,NP
         LERROR(I,J)=MERROR(I,J)
  70     CONTINUE
!         IF(IPRINT.EQ.1)WRITE(23,105)IIJJ,KBEFORE,KINITIAL
      ENDIF
!
      KBEFORE=KBEFORE+1
 9999 CONTINUE
!
      DEALLOCATE(KPERM)
      DEALLOCATE(MPERM)
      DEALLOCATE(KBIGPERM)
      DEALLOCATE(MMJAVA)
      DEALLOCATE(LLV)
      DEALLOCATE(LLVB)
      DEALLOCATE(LLE)
      DEALLOCATE(LLEB)
      DEALLOCATE(L)
      DEALLOCATE(LL)
      DEALLOCATE(LJAVA)
      DEALLOCATE(LV)
      DEALLOCATE(KKA)
      DEALLOCATE(KA)
      DEALLOCATE(LLSAVE)
      DEALLOCATE(LTEST)
      DEALLOCATE(LORDER)
      DEALLOCATE(MERROR)
      DEALLOCATE(MMSAVE)
      DEALLOCATE(YSS)
      DEALLOCATE(YSJAVA)
      DEALLOCATE(ZS)
      DEALLOCATE(YSSS)
      DEALLOCATE(XJCH)
      DEALLOCATE(XJEH)
      DEALLOCATE(XJCL)
      DEALLOCATE(XJEL)
      RETURN
      END
