% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parties_doc.R
\docType{data}
\name{parties_v}
\alias{parties_v}
\title{New Zealand political party colours}
\format{A named vector of colours}
\source{
\url{https://en.wikipedia.org/wiki/Wikipedia:Index_of_New_Zealand_political_party_meta_attributes}
}
\usage{
parties_v
}
\description{
Colours associated with New Zealand political parties in the early 21st century
}
\examples{
# Example use of parties_v in a colour scale for ggplot2
if(require(ggplot2) & require(scales) & require(dplyr) & require(forcats)){
polls \%>\%
filter(MidDate > as.Date("2014-11-20") & !is.na(VotingIntention)) \%>\%
    mutate(Party = fct_reorder(Party, VotingIntention, .desc = TRUE),
           Party = fct_drop(Party)) \%>\%
    ggplot(aes(x = MidDate, y = VotingIntention, colour = Party, linetype = Pollster)) +
    geom_line(alpha = 0.5) +
    geom_point(aes(shape = Pollster)) +
    geom_smooth(aes(group = Party), se = FALSE, colour = "grey15", span = .4) +
    scale_colour_manual(values = parties_v) +
    scale_y_continuous("Voting intention", label = percent) +
    scale_x_date("") +
    facet_wrap(~Party, scales = "free_y") 
    }
}
\keyword{datasets}
