% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generics.R
\name{estimate}
\alias{estimate}
\title{Estimate several chaotic invariants using linear regression}
\usage{
estimate(x, regression.range, do.plot, ...)
}
\arguments{
\item{x}{An object containing all the information needed for the estimate.}

\item{regression.range}{Range of values on the x-axis on which the regression is performed.}

\item{do.plot}{Logical value. If TRUE (default value), a plot of the regression is shown.}

\item{...}{Additional parameters.}
}
\value{
An estimate of the proper chaotic invariant.
}
\description{
Several chaotic invariants are estimated by using linear regression. This function
provides a common interface for the estimate of all these parameters (see \code{\link{corrDim}},
\code{\link{dfa}} and \code{\link{maxLyapunov}} for examples).
}
\author{
Constantino A. Garcia
}
\references{
H. Kantz  and T. Schreiber: Nonlinear Time series Analysis (Cambridge university press)
}

