% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_amenity.R
\name{geo_amenity}
\alias{geo_amenity}
\title{Geocode amenities}
\usage{
geo_amenity(
  bbox,
  amenity,
  lat = "lat",
  long = "lon",
  limit = 1,
  full_results = FALSE,
  return_addresses = TRUE,
  verbose = FALSE,
  nominatim_server = "https://nominatim.openstreetmap.org/",
  progressbar = TRUE,
  custom_query = list(),
  strict = FALSE
)
}
\arguments{
\item{bbox}{The bounding box (viewbox) used to limit the search. It could be:
\itemize{
\item A numeric vector of \strong{longitude} (\code{x}) and \strong{latitude} (\code{y})
\verb{(xmin, ymin, xmax, ymax)}. See \strong{Details}.
\item A \code{\link[sf:sf]{sf}} or \code{\link[sf:sfc]{sfc}} object.
}}

\item{amenity}{A \code{character} (or a vector of \code{character}s) with the
amenities to be geolocated (i.e. \code{c("pub", "restaurant")}). See
\link{osm_amenities}.}

\item{lat}{Latitude column name in the output data (default  \code{"lat"}).}

\item{long}{Longitude column name in the output data (default  \code{"long"}).}

\item{limit}{Maximum number of results to return per input address. Note
that each query returns a maximum of 50 results.}

\item{full_results}{Returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_addresses}{Return input addresses with results if \code{TRUE}.}

\item{verbose}{If \code{TRUE} then detailed logs are output to the console.}

\item{nominatim_server}{The URL of the Nominatim server to use.
Defaults to \code{"https://nominatim.openstreetmap.org/"}.}

\item{progressbar}{Logical. If \code{TRUE} displays a progress bar to indicate
the progress of the function.}

\item{custom_query}{A named list with API-specific parameters to be used
(i.e. \code{list(countrycodes = "US")}). See \strong{Details}.}

\item{strict}{Logical \code{TRUE/FALSE}. Force the results to be included inside
the \code{bbox}. Note that Nominatim default behavior may return results located
outside the provided bounding box.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} with the results found by the query.
}
\description{
This function search \link[=osm_amenities]{amenities} as defined by OpenStreetMap
on a restricted area defined by a bounding box in the form
\verb{(<xmin>, <ymin>, <xmax>, <ymax>)}. This function returns the
\code{\link[tibble:tibble]{tibble}} associated with the query, see \code{\link[=geo_amenity_sf]{geo_amenity_sf()}}
for retrieving the data as a spatial object (\code{\link[sf:sf]{sf}} format).
}
\details{
Bounding boxes can be located using different online tools, as
\href{https://boundingbox.klokantech.com/}{Bounding Box Tool}.

For a full list of valid amenities see
\url{https://wiki.openstreetmap.org/wiki/Key:amenity} and \link{osm_amenities}.

See \url{https://nominatim.org/release-docs/latest/api/Search/} for additional
parameters to be passed to \code{custom_query}.
}
\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Times Square, NY, USA
bbox <- c(
  -73.9894467311, 40.75573629,
  -73.9830630737, 40.75789245
)

geo_amenity(
  bbox = bbox,
  amenity = "restaurant"
)

# Several amenities
geo_amenity(
  bbox = bbox,
  amenity = c("restaurant", "pub")
)

# Increase limit and use with strict
geo_amenity(
  bbox = bbox,
  amenity = c("restaurant", "pub"),
  limit = 10,
  strict = TRUE
)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other amenity: 
\code{\link{geo_amenity_sf}()},
\code{\link{osm_amenities}}

Geocoding: 
\code{\link{geo_address_lookup}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite_struct}()},
\code{\link{geo_lite_struct_sf}()}
}
\concept{amenity}
\concept{geocoding}
