% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_nlslist.R
\name{anova_nlslist}
\alias{anova_nlslist}
\title{Anova for nlsList}
\usage{
anova_nlslist(nlsfull, nlsreduc)
}
\arguments{
\item{nlsfull}{The full model, an object returned by \code{\link{nlsList}}}

\item{nlsreduc}{The reduced model, which is identical to the full model except the grouping variable has been removed, and it was fit with \code{\link{nls}}}
}
\description{
Applies an F-test to a non-linear regression model that includes a grouping variable (fit with \code{\link{nlsList}}), comparing it to a model without a grouping variable. This is a convenient way to test whether there is an overall effect of the grouping variable on the non-linear relationship.
}
\examples{
chick <- as.data.frame(ChickWeight)

# Fit a simple model with nls
fit0 <- nls(weight ~ a*Time^b, data=chick, start=list(a=10, b=1.1))

# Fit an nlsList model, with a grouping variable (Diet)
fit1 <- nlsList(weight ~ a*Time^b | Diet, data=chick, start=list(a=10, b=1.1))

# Using an F-test, test whether the fit is significantly better when adding
# a grouping variable
anova_nlslist(fit1, fit0)
}

