% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginalVoidProbNumIntegration.R
\name{marginalVoidProbNumIntegration}
\alias{marginalVoidProbNumIntegration}
\title{Marginal void probability}
\usage{
marginalVoidProbNumIntegration(
  quadNodes,
  quadWeights,
  numNodes,
  lowerCoords,
  upperCoords,
  sd,
  baseIntensities,
  habIntensities,
  sumHabIntensity,
  numObsWindows,
  numHabWindows
)
}
\arguments{
\item{quadNodes}{Three-dimensional array of nodes for midpoint integration. The dimension sizes are equal to 
the number of nodes per habitat window (1st), 2 (2nd), and the number of habitat windows (3rd).}

\item{quadWeights}{Vector of weights for midpoint integration.}

\item{numNodes}{Vector of numbers of nodes for all habitat windows.}

\item{lowerCoords, upperCoords}{Matrix of lower and upper x- and y-coordinates of all detection windows. One row for each window.}

\item{sd}{Standard deviation of the isotropic multivariate normal distribution.}

\item{baseIntensities}{Vector of baseline detection intensities for all detection windows.}

\item{habIntensities}{Vector of habitat intensities for all habitat windows.}

\item{sumHabIntensity}{Total habitat selection intensity over all windows.}

\item{numObsWindows}{Number of detection windows.}

\item{numHabWindows}{Number of habitat windows.}
}
\value{
The marginal void probability.
}
\description{
Calculate the marginal void probability using the midpoint integration method.
}
\examples{
lowerHabCoords <- matrix(c(0, 0, 0, 1), nrow = 2, byrow = TRUE)
upperHabCoords <- matrix(c(2, 1, 2, 2), nrow = 2, byrow = TRUE)
lowerObsCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperObsCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)
nodesRes <- getMidPointNodes(lowerHabCoords, upperHabCoords, 10)
quadNodes <- nodesRes$quadNodes
quadWeights <- nodesRes$quadWeights
numNodes <- rep(100, 2)
sd <- 0.1
baseDetIntensities <- c(1:4)
habIntensities <- c(1:2)
sumHabIntensity <- sum(habIntensities * c(2, 2))
numObsWindows <- 4
numHabWindows <- 2
marginalVoidProbNumIntegration(quadNodes, quadWeights, numNodes,
                               lowerObsCoords, upperObsCoords, sd, 
                               baseDetIntensities, habIntensities,
                               sumHabIntensity, numObsWindows, numHabWindows)

}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang
}
