% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nhdplus.R
\name{get_nhdplushr}
\alias{get_nhdplushr}
\title{Get NHDPlus HiRes as single geopackage}
\usage{
get_nhdplushr(hr_dir, out_gpkg = NULL, layers = c("NHDFlowline",
  "NHDPlusCatchment"), pattern = ".*GDB.gdb$")
}
\arguments{
\item{hr_dir}{character directory with geodatabases (gdb search is recursive)}

\item{out_gpkg}{character path to write output geopackage}

\item{layers}{character vector with desired layers to return.
c("NHDFlowline", "NHDPlusCatchment") is default.
Choose from:
c("NHDFlowline", "NHDPlusCatchment", "NHDWaterbody", "NHDArea", "NHDLine",
"NHDPlusSink", "NHDPlusWall", "NHDPoint", "NHDPlusBurnWaterbody",
"NHDPlusBurnLineEvent", "HYDRO_NET_Junctions",
"WBDHU2", "WBDHU4","WBDHU6", "WBDHU8" "WBDHU10", "WBDHU12", "WBDLine")}

\item{pattern}{character optional regex to select certain files in hr_dir}
}
\description{
Get NHDPlus HiRes as single geopackage
}
\details{
NHDFlowline is joined to value added attributes prior to being
returned.
Names are not modified from the NHDPlusHR geodatabase.
Set layers to "NULL" to get all layers.
}
\examples{
\donttest{
# Note this will download a lot of data to a temp directory.
# Change 'tempdir()' to your directory of choice.
download_dir <- download_nhdplushr(tempdir(), c("0302", "0303"))
get_nhdplushr(download_dir, file.path(download_dir, "nhdplus_0302-03.gpkg"))
}
}
