% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transform_ilr.R
\docType{methods}
\name{transform_ilr}
\alias{transform_ilr}
\alias{transform_ilr-method}
\alias{transform_ilr,CompositionMatrix-method}
\alias{transform_ilr,CompositionMatrix,missing-method}
\alias{transform_ilr,GroupedComposition-method}
\alias{transform_ilr,GroupedComposition,missing-method}
\alias{transform_ilr,CLR-method}
\alias{transform_ilr,CLR,missing-method}
\alias{transform_ilr,GroupedCLR-method}
\alias{transform_ilr,GroupedCLR,missing-method}
\alias{transform_ilr,ALR-method}
\alias{transform_ilr,ALR,missing-method}
\alias{transform_ilr,GroupedALR-method}
\alias{transform_ilr,GroupedALR,missing-method}
\title{Isometric Log-Ratios (ILR)}
\usage{
transform_ilr(object, ...)

\S4method{transform_ilr}{CompositionMatrix}(object)

\S4method{transform_ilr}{GroupedComposition}(object)

\S4method{transform_ilr}{CLR}(object)

\S4method{transform_ilr}{GroupedCLR}(object)

\S4method{transform_ilr}{ALR}(object)

\S4method{transform_ilr}{GroupedALR}(object)
}
\arguments{
\item{object}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}
}
\value{
An \code{\linkS4class{ILR}} object.
}
\description{
Computes ILR transformations.
}
\details{
The ILR transformation provides the coordinates of any composition with
respect to a given orthonormal basis. \code{transform_ilr()} uses the orthonormal
basis (Helmert matrix) originally defined by Egozcue \emph{et al.} (2003).
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Isometric log-ratio
ilr <- transform_ilr(coda)
plr <- transform_plr(coda)

## Inverse transformation
inv_ilr <- transform_inverse(ilr)
all.equal(coda, inv_ilr)

inv_plr <- transform_inverse(plr)
all.equal(coda, inv_plr)
}
\references{
Egozcue, J. J., Pawlowsky-Glahn, V., Mateu-Figueras, G. & Barceló-Vidal, C.
(2003). Isometric Logratio Transformations for Compositional Data Analysis.
\emph{Mathematical Geology}, 35(3), 279-300. \doi{10.1023/A:1023818214614}.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.

Greenacre, M. J. (2021). Compositional Data Analysis. \emph{Annual Review of
Statistics and Its Application}, 8(1): 271-299.
\doi{10.1146/annurev-statistics-042720-124436}.
}
\seealso{
Other log-ratio transformations: 
\code{\link{transform_alr}()},
\code{\link{transform_clr}()},
\code{\link{transform_inverse}()},
\code{\link{transform_lr}()},
\code{\link{transform_plr}()}
}
\author{
N. Frerebeau
}
\concept{log-ratio transformations}
