% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthopolos.R
\name{anthopolos}
\alias{anthopolos}
\title{Racial Isolation Index based on Anthopolos et al. (2011)}
\usage{
anthopolos(geo = "tract", year = 2020, subgroup, quiet = FALSE, ...)
}
\arguments{
\item{geo}{Character string specifying the geography of the data either census tracts \code{geo = "tract"} (the default) or counties \code{geo = "county"}.}

\item{year}{Numeric. The year to compute the estimate. The default is 2020 and the years between 2009 and 2020 are currently available.}

\item{subgroup}{Character string specifying the racial/ethnic subgroup(s). See Details for available choices.}

\item{quiet}{Logical. If TRUE, will display messages about potential missing census information. The default is FALSE.}

\item{...}{Arguments passed to \code{\link[tidycensus]{get_acs}} to select state, county, and other arguments for census characteristics}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{ri}}{An object of class 'tbl' for the GEOID, name, RI, and raw census values of specified census geographies.}
\item{\code{missing}}{An object of class 'tbl' of the count and proportion of missingness for each census variable used to compute the RI.}
}
}
\description{
Compute the Racial Isolation Index (Anthopolos) values for selected subgroup(s).
}
\details{
This function will compute the Racial Isolation Index (RI) of U.S. census tracts or counties for a specified geographical extent (e.g., entire U.S. or a single state) based on Anthopolos et al. (2011) \doi{10.1016/j.sste.2011.06.002} who originally designed the metric for the racial isolation of non-Hispanic Black individuals. This function provides the computation of RI for any of the U.S. Census Bureau race/ethnicity subgroups (including Hispanic and non-Hispanic individuals).

The function uses the \code{\link[tidycensus]{get_acs}} function to obtain U.S. Census Bureau 5-year American Community Survey characteristics used for the geospatial computation. The yearly estimates available for 2009 through 2020 when ACS-5 data are available but are available from other U.S. Census Bureau surveys. The twenty racial/ethnic subgroups (U.S. Census Bureau definitions) are:
\itemize{
\item{B03002_002: }{Not Hispanic or Latino "NHoL"}
\item{B03002_003: }{Not Hispanic or Latino, White alone "NHoLW"}
\item{B03002_004: }{Not Hispanic or Latino, Black or African American alone "NHoLB"}
\item{B03002_005: }{Not Hispanic or Latino, American Indian and Alaska Native alone "NHoLAIAN"}
\item{B03002_006: }{Not Hispanic or Latino, Asian alone "NHoLA"}
\item{B03002_007: }{Not Hispanic or Latino, Native Hawaiian and Other Pacific Islander alone "NHoLNHOPI"}
\item{B03002_008: }{Not Hispanic or Latino, Some other race alone "NHoLSOR"}
\item{B03002_009: }{Not Hispanic or Latino, Two or more races "NHoLTOMR"}
\item{B03002_010: }{Not Hispanic or Latino, Two races including Some other race "NHoLTRiSOR"}
\item{B03002_011: }{Not Hispanic or Latino, Two races excluding Some other race, and three or more races "NHoLTReSOR"}
\item{B03002_012: }{Hispanic or Latino "HoL"}
\item{B03002_013: }{Hispanic or Latino, White alone "HoLW"}
\item{B03002_014: }{Hispanic or Latino, Black or African American alone "HoLB"}
\item{B03002_015: }{Hispanic or Latino, American Indian and Alaska Native alone "HoLAIAN"}
\item{B03002_016: }{Hispanic or Latino, Asian alone "HoLA"}
\item{B03002_017: }{Hispanic or Latino, Native Hawaiian and Other Pacific Islander alone "HoLNHOPI"}
\item{B03002_018: }{Hispanic or Latino, Some other race alone "HoLSOR"}
\item{B03002_019: }{Hispanic or Latino, Two or more races "HoLTOMR"}
\item{B03002_020: }{Hispanic or Latino, Two races including Some other race "HoLTRiSOR"}
\item{B03002_021: }{Hispanic or Latino, Two races excluding Some other race, and three or more races "HoLTReSOR"}
}

Use the internal \code{state} and \code{county} arguments within the \code{\link[tidycensus]{get_acs}} function to specify geographic extent of the data output. NOTE: Current version does not correct for edge effects (e.g., census geographies along the specified spatial extent border, coastline, or U.S.-Mexico / U.S.-Canada border) may have few neighboring census geographies and RI values in these census geographies may be unstable. A stop-gap solution for the former source of edge effect is to compute the RI for neighboring census geographies (i.e., the states bordering a study area of interest) and then use the estimates of the study area of interest.

A census geography (and its neighbors) that has nearly all of its population who identify with the specified race/ethnicity subgroup(s) (e.g., non-Hispanic or Latino, Black or African American alone) will have an RI value that is close to 1. In contrast, a census geography (and its neighbors) that is nearly none of its population who identify with the specified race/ethnicity subgroup(s) (e.g., not non-Hispanic or Latino, Black or African American alone) will have an RI value that is close to 0.
}
\examples{
\dontrun{
# Wrapped in \dontrun{} because these examples require a Census API key.
  
  # Tract-level metric (2020)
  anthopolos(geo = "tract", state = "GA", year = 2020, subgroup = c("NHoLB", "HoLB"))
  
  # County-level metric (2020)
  anthopolos(geo = "county", state = "GA", year = 2020, subgroup = c("NHoLB", "HoLB"))
  
}

}
\seealso{
\code{\link[tidycensus]{get_acs}} for additional arguments for geographic extent selection (i.e., \code{state} and \code{county}).
}
