% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xform.R
\name{mirror}
\alias{mirror}
\alias{mirror.character}
\alias{mirror.default}
\alias{mirror.neuronlist}
\title{Mirror 3D object about a given axis, optionally using a warping registration}
\usage{
mirror(x, ...)

\method{mirror}{character}(x, output, mirrorAxisSize = NULL, target = x,
  ...)

\method{mirror}{default}(x, mirrorAxisSize, mirrorAxis = c("X", "Y", "Z"),
  warpfile = NULL, transform = c("warp", "affine", "flip"), ...)

\method{mirror}{neuronlist}(x, subset = NULL, OmitFailures = NA, ...)
}
\arguments{
\item{x}{Object with 3D points (with named cols X,Y,Z) or path to image on
disk.}

\item{...}{additional arguments passed to methods or eventually to 
\code{\link{xform}}}

\item{output}{Path to the output image}

\item{mirrorAxisSize}{A single number specifying the size of the axis to 
mirror or a 2 vector (\bold{recommended}) or 2x3 matrix specifying the 
\code{\link{boundingbox}} (see details).}

\item{target}{Path to the image defining the target grid (defaults to the
input image - hard to see when this would not be wanted).}

\item{mirrorAxis}{Axis to mirror (default \code{"X"}). Can also be an integer
in range \code{1:3}.}

\item{warpfile}{Optional registration or \code{\link{reglist}} to be applied
\emph{after} the simple mirroring.. It is called warpfile for historical
reasons, since it is normally the path to a CMTK registration that
specifies a non-rigid transformation to correct asymmetries in an image.}

\item{transform}{whether to use warp (default) or affine component of 
registration, or simply flip about midplane of axis.}

\item{subset}{For \code{mirror.neuronlist} indices
(character/logical/integer) that specify a subset of the members of
\code{x} to be transformed.}

\item{OmitFailures}{Whether to omit neurons for which \code{FUN} gives an 
error. The default value (\code{NA}) will result in nlapply stopping with 
an error message the moment there is an eror. For other values, see 
details.}
}
\value{
Object with transformed points
}
\description{
mirroring with a warping registration can be used to account 
  e.g. for the asymmetry between brain hemispheres.

\code{mirror.character} handles images on disk
}
\details{
The \code{mirrorAxisSize} argument can be specified in 3 ways for 
  the x axis with extreme values, x0+x1: \itemize{
  
  \item a single number equal to x0+x1
  
  \item a 2-vector c(x0, x1) (\bold{recommended})
  
  \item the \code{\link{boundingbox}} for the 3D data to be mirrored: the 
  relevant axis specified by \code{mirrorAxis} will be extracted.
  
  }
  
  This function is agnostic re node vs cell data, but for node data 
  BoundingBox should be supplied while for cell, it should be bounds. See 
  \code{\link{boundingbox}} for details of BoundingBox vs bounds.
  
  See \code{\link{nlapply}} for details of the \code{subset} and 
  \code{OmitFailures} arguments.
}
\examples{
nopen3d()
x=Cell07PNs[[1]]
mx=mirror(x,168)
\donttest{
plot3d(x,col='red')
plot3d(mx,col='green')
}

# also works with dotprops objects
clear3d()
y=kcs20[[1]]
my=mirror(y,mirrorAxisSize=564.2532,transform='flip')
\donttest{
plot3d(y, col='red')
plot3d(my, col='green')
}

\dontrun{
## Example with an image
# note that we must specify an output image (obviously) but that as a
# convenience mirror calculates the mirrorAxisSize for us
mirror('myimage.nrrd', output='myimage-mirrored.nrrd', 
  warpfile='myimage_mirror.list')

# Simple flip along a different axis
mirror('myimage.nrrd', output='myimage-flipped.nrrd', mirrorAxis="Y", 
  transform='flip')
}
}
\seealso{
\code{\link{xform}, \link{boundingbox}}

\code{\link{nlapply}}
}
