% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{independence.test}
\alias{independence.test}
\title{test for independence}
\usage{
independence.test(x, vec = NA, alpha = 0.05)
}
\arguments{
\item{x}{either a data matrix or an array of centered distance matrices}

\item{vec}{if x is a matrix, then this indicates which columns are treated together as one sample; if x is an array, these are the indexes for which the multivariance is calculated. The default is all columns and all indicies, respectively.}

\item{alpha}{significance level}
}
\value{
Returns \code{TRUE} if the hypothesis of independence is NOT rejected, otherwise \code{FALSE}.
}
\description{
This computes a test of independence for given columns of a sample matrix or given centered distance matrices.
}
\details{
The test might be very conservative.

The centered distance matrices can be prepared by \code{\link{cdms}}.
}
\examples{
independence.test(coins(100)) # dependent sample
independence.test(coins(100)[,2:3]) # independent sample
independence.test(coins(100)) #dependent sample which is 2-independent

}
