% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodesplit_summary-class.R
\name{nodesplit_summary-class}
\alias{nodesplit_summary-class}
\alias{nodesplit_summary}
\title{The \code{nodesplit_summary} class}
\description{
The \code{nodesplit_summary} class contains posterior summary statistics for
node-splitting models, as a result of calling \code{summary()} on a
\code{nma_nodesplit} or \code{nma_nodesplit_df} object.
}
\details{
Objects of class \code{nodesplit_summary} are tibble data frames, with one row
for each node-split comparison and columns:
\describe{
\item{\code{trt1}, \code{trt2}}{Treatments forming the comparison}
\item{\code{summary}}{A list column containing \link{nma_summary} objects with the
posterior summaries and draws for each of the node-splitting parameters}
\item{\code{p_value}}{Bayesian p-value for inconsistency}
\item{\code{dic}}{A list column containing \link{nma_dic} objects, giving the model
fit statistics}
}

The parameters included in \code{summary} are:
\describe{
\item{\code{d_net}}{Network estimate from the corresponding consistency model,
if available}
\item{\code{d_dir}}{Direct estimate from the node-splitting model}
\item{\code{d_ind}}{Indirect estimate from the node-splitting model}
\item{\code{omega}}{Inconsistency factor \eqn{\omega = d_\mathrm{dir} -
  d_\mathrm{ind}}{\omega = d_dir - d_ind}}
\item{\code{tau}}{Heterogeneity standard deviation from the node-splitting
model, if a random effects model was fitted}
\item{\code{tau_consistency}}{Heterogeneity standard deviation from the
corresponding consistency model, if available and if a random effects model
was fitted}
}
}
