% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{qgamma}
\alias{qgamma}
\alias{dgamma}
\alias{pgamma}
\title{The Gamma distribution}
\usage{
qgamma(
  p,
  shape,
  rate = 1,
  scale = 1/rate,
  lower.tail = TRUE,
  log.p = FALSE,
  mean,
  sd
)

dgamma(x, shape, rate = 1, scale = 1/rate, log = FALSE, mean, sd)

pgamma(
  q,
  shape,
  rate = 1,
  scale = 1/rate,
  lower.tail = TRUE,
  log.p = FALSE,
  mean,
  sd
)
}
\arguments{
\item{p}{vector of probabilities}

\item{shape, rate, scale, log, lower.tail, log.p}{see \link[stats:GammaDist]{stats::GammaDist}}

\item{mean, sd}{mean and standard deviation, overriding \code{shape} and
\code{rate} or \code{scale} if specified}

\item{x, q}{vector of quantiles}
}
\description{
We provide convenient extensions of the \verb{[dpq]gamma} functions, which allow
the distribution to be specified in terms of its mean and standard deviation,
instead of shape and rate/scale.
}
