% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue.R
\name{multibias_evalue}
\alias{multibias_evalue}
\title{E-value for meta-analysis with multiple biases}
\usage{
multibias_evalue(
  yi,
  vi,
  sei,
  cluster = 1:length(yi),
  biased = TRUE,
  selection_ratio,
  q = 0,
  favor_positive = TRUE,
  alpha_select = 0.05,
  ci_level = 0.95,
  small = TRUE,
  bias_max = 20,
  assumed_bias_type = NULL
)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed.}

\item{vi}{A vector of estimated variances (i.e., squared standard errors) for
the point estimates.}

\item{sei}{A vector of estimated standard errors for the point estimates.
(Only one of \code{vi} or \code{sei} needs to be specified).}

\item{cluster}{Vector of the same length as the number of rows in the data,
indicating which cluster each study should be considered part of (defaults
to treating studies as independent; i.e., each study is in its own cluster).}

\item{biased}{Boolean indicating whether each study is considered internally
biased; either single value used for all studies or a vector the same
length as the number of rows in the data (defaults to all studies).}

\item{selection_ratio}{Ratio by which publication bias favors affirmative
studies (i.e., studies with p-values less than \code{alpha_select} and
estimates in the direction indicated by \code{favor_positive}).}

\item{q}{The attenuated value to which to shift the point estimate or CI.
Should be specified on the same scale as \code{yi} (e.g., if
\code{yi} is on the log-RR scale, then \code{q} should be as well).}

\item{favor_positive}{\code{TRUE} if publication bias are
assumed to favor significant positive estimates; \code{FALSE} if assumed to
favor significant negative estimates.}

\item{alpha_select}{Alpha level at which an estimate's probability of being
favored by publication bias is assumed to change (i.e.,
the threshold at which study investigators, journal editors, etc., consider
an estimate to be significant).}

\item{ci_level}{Confidence interval level (as proportion) for the corrected
point estimate. (The alpha level for inference on the corrected point
estimate will be calculated from \code{ci_level}.)}

\item{small}{Should inference allow for a small meta-analysis? We recommend
always using \code{TRUE}.}

\item{bias_max}{The largest value of \code{bias}, on the additive scale, that
should be included in the grid search. The bias has the same units as \code{yi}.}

\item{assumed_bias_type}{List of biases to consider for computing evalues
(objects of \code{bias} as returned by \code{\link[EValue:confounding]{EValue::confounding()}},
\code{\link[EValue:selection]{EValue::selection()}}, \code{\link[EValue:misclassification]{EValue::misclassification()}}) (defaults to NULL,
i.e. agnostic as to the nature of the internal bias). If not NULL, the \code{yi}
argument must be on the log-RR scale (if \code{yi} is not already on that scale,
use \code{\link[EValue:convert_measures]{EValue::convert_measures()}} to make it so).}
}
\value{
An object of class \code{\link[metabias:metabias-class]{metabias::metabias()}}, a list containing:
\describe{
\item{data}{A tibble with one row per study and the columns
\code{yi}, \code{vi}, \code{sei}, \code{cluster}, \code{biased}.}
\item{values}{A list with the elements \code{selection_ratio}, \code{q}, \code{favor_positive}, \code{alpha_select}, \code{ci_level}, \code{small}, \code{bias_max}.}
\item{stats}{A tibble with the columns \code{bias_est}, \code{bias_ci}, \code{evalue_est}, \code{evalue_ci}.}
}
}
\description{
E-value for meta-analysis with multiple biases
}
\details{
For more on the functions passed as \code{assumed_bias_type}, see the
\code{EValue} package multiple-bias vignette:
\code{vignette("multiple-bias", package = "EValue")}
}
\examples{
\donttest{
  # specify confounding as internal bias
  evalues <- multibias_evalue(yi = meta_meat$yi,
                              vi = meta_meat$vi,
                              biased = !meta_meat$randomized,
                              selection_ratio = 4)
  evalues$stats

  # specify confounding as internal bias
  evalues_confounding <- multibias_evalue(yi = meta_meat$yi,
                                          vi = meta_meat$vi,
                                          biased = !meta_meat$randomized,
                                          selection_ratio = 4,
                                          assumed_bias_type = list(EValue::confounding()))
  evalues_confounding$stats
}
}
\references{
\insertRef{mathur2022multibias}{multibiasmeta}

\insertRef{ding2016}{metabias}

\insertRef{smith2019}{metabias}

\insertRef{vanderweele2019}{metabias}
}
