% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmxml.R
\name{nmxml}
\alias{nmxml}
\alias{NMXML}
\title{Import model estimates from a NONMEM xml file}
\usage{
nmxml(
  run = numeric(0),
  project = character(0),
  file = character(0),
  path = character(0),
  root = c("working", "cppfile"),
  theta = TRUE,
  omega = TRUE,
  sigma = TRUE,
  olabels = NULL,
  slabels = NULL,
  oprefix = "",
  sprefix = "",
  tname = "THETA",
  oname = "...",
  sname = "...",
  index = "last",
  xpath = ".//nm:estimation",
  env = NULL
)
}
\arguments{
\item{run}{run number}

\item{project}{project directory}

\item{file}{deprecated; use \code{path} instead}

\item{path}{the complete path to the \code{run.xml} file}

\item{root}{the directory that `path` and `project` are relative to; this is
currently limited to the `working` directory or `cppdir`, the directory 
where the model file is located}

\item{theta}{logical; if TRUE, the \code{$THETA} vector is returned}

\item{omega}{logical; if TRUE, the \code{$OMEGA} matrix is returned}

\item{sigma}{logical; if TRUE, the \code{$SIGMA} matrix is returned}

\item{olabels}{labels for \code{$OMEGA}}

\item{slabels}{labels for \code{$SIGMA}}

\item{oprefix}{prefix for \code{$OMEGA} labels}

\item{sprefix}{prefix for \code{$SIGMA} labels}

\item{tname}{name for \code{$THETA}}

\item{oname}{name for \code{$OMEGA}}

\item{sname}{name for \code{$SIGMA}}

\item{index}{the estimation number to return;  "last" will return the 
last estimation results; otherwise, pass an integer indicating which 
estimation results to return}

\item{xpath}{xml path containing run results; if the default doesn't work, 
consider using \code{.//estimation} as an alternative; see details}

\item{env}{internal}
}
\value{
A list with theta, omega and sigma elements, 
depending on what was requested
}
\description{
Import model estimates from a NONMEM xml file
}
\details{
If \code{run} and \code{project} are supplied, the .xml file is 
assumed to be located in \code{run.xml}, in directory \code{run} 
off the \code{project} directory.  If \code{file} is supplied, 
\code{run} and \code{project} arguments are ignored.

This function requires that the \code{xml2} package 
be installed and loadable.  If \code{requireNamespace("xml2")}
fails, an error will be generated. 

\code{nmxml} usually expects to find run results in the xpath called
\code{.//nm:estimation}.  Occasionally, the run results are not stored in 
this namespace but no namespaces are found in the xml file.  In this case, 
the user can specify the xpath containing run results.  Consider trying 
\code{.//estimation} as an alternative if the default fails.
}
\examples{

if(requireNamespace("xml2")) {
  proj <- system.file("nonmem", package = "mrgsolve")
  mrgsolve:::nmxml(run = 1005, project = proj)
}

}
\seealso{
nmext
}
