% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpnorm.R
\name{cnorm}
\alias{cnorm}
\alias{ct}
\title{Central Probability in a Normal or T Distribution}
\usage{
cnorm(p, mean = 0, sd = 1, log.p = FALSE, side = c("both", "upper", "lower"))

ct(p, df, ncp, log.p = FALSE, side = c("upper", "lower", "both"))
}
\arguments{
\item{p}{vector of probabilities.}

\item{mean}{vector of means.}

\item{sd}{vector of standard deviations.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{side}{One of "upper", "lower", or "both" indicating
whether a vector of upper or lower quantiles or a matrix of
both should be returned.}

\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{ncp}{non-centrality parameter \eqn{\delta}{delta};
    currently except for \code{rt()}, only for \code{abs(ncp) <= 37.62}.
    If omitted, use the central t distribution.}
}
\description{
These versions of the quantile functions take a vector of
\emph{central} probabilities as its first argument.
}
\examples{
qnorm(.975)
cnorm(.95)
xcnorm(.95)
xcnorm(.95, verbose = FALSE, return = "plot") \%>\%
  gf_refine(
  scale_fill_manual( values = c("navy", "limegreen")),
  scale_color_manual(values = c("black", "black")))
cnorm(.95, mean = 100, sd = 10)
xcnorm(.95, mean = 100, sd = 10)

}
\seealso{
\code{\link[stats:qnorm]{stats::qnorm()}}, \code{\link[=cdist]{cdist()}}
}
