% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-ets_params.R
\name{exp_smoothing_params}
\alias{exp_smoothing_params}
\alias{error}
\alias{trend}
\alias{season}
\alias{damping}
\title{Tuning Parameters for Exponential Smoothing Models}
\usage{
error(values = c("additive", "multiplicative"))

trend(values = c("additive", "multiplicative", "none"))

season(values = c("additive", "multiplicative", "none"))

damping(values = c("damped", "none"))
}
\arguments{
\item{values}{A character string of possible values.}
}
\description{
Tuning Parameters for Exponential Smoothing Models
}
\details{
The main parameters for Exponential Smoothing models are:
\itemize{
\item \code{error}: The form of the error term: additive", or "multiplicative".
If the error is multiplicative, the data must be non-negative.
\item \code{trend}: The form of the trend term: "additive", "multiplicative" or "none".
\item \code{season}: The form of the seasonal term: "additive", "multiplicative" or "none"..
\item \code{damping}: Apply damping to a trend: "damped", or "none".
}
}
\examples{

error()

trend()

season()

}
