% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-model_descriptions.R
\name{get_model_description}
\alias{get_model_description}
\title{Get model descriptions for parsnip, workflows & modeltime objects}
\usage{
get_model_description(object, indicate_training = FALSE, upper_case = TRUE)
}
\arguments{
\item{object}{Parsnip or workflow objects}

\item{indicate_training}{Whether or not to indicate if the model has been trained}

\item{upper_case}{Whether to return upper or lower case model descriptions}
}
\description{
Get model descriptions for parsnip, workflows & modeltime objects
}
\examples{
library(dplyr)
library(timetk)
library(parsnip)
library(modeltime)

# Model Specification ----

arima_spec <- arima_reg() \%>\%
    set_engine("auto_arima")

get_model_description(arima_spec, indicate_training = TRUE)

# Fitted Model ----

m750 <- m4_monthly \%>\% filter(id == "M750")

arima_fit <- arima_spec \%>\%
    fit(value ~ date, data = m750)

get_model_description(arima_fit, indicate_training = TRUE)


}
