% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supplement.funct.R
\name{Margins.mod}
\alias{Margins.mod}
\title{Compute uniform margins with Generalized Pareto Distribution above threshold}
\usage{
Margins.mod(tr1, tr2, u)
}
\arguments{
\item{tr1}{extreme threshold for first variable}

\item{tr2}{extreme threshold for second variable}

\item{u}{Two column data frame}
}
\value{
a list of containing the following pseudo observations (uniform margins) with a mixed distribution (empirical below and gpd above a threshold)
\itemize{
\item uvar - data frame of pseudo observations (uniform margins) of the original data '\code{u}'
\item uvar_ext - data frame of pseudo observations (uniform margins) with a mixed distribution (empirical below and gpd above a threshold) and 1000 extrapolated values
\item val_est - data frame consiting of mix of original data '\code{u}'and 1000 extrapolated values
}
}
\description{
Compute uniform margins with Generalized Pareto Distribution above threshold
}
\examples{
data(porto)
tr1=0.9
tr2=0.9
fire01meantemp=na.omit(fire01meantemp)
u=fire01meantemp
marmod=Margins.mod(tr1,tr2,u=fire01meantemp)
}
