% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{Extract}
\alias{Extract}
\title{Create an Implementation of [ For Custom Matrix-Like Types}
\usage{
Extract(extract_vector, extract_matrix)
}
\arguments{
\item{extract_vector}{A function in the form of \code{function(x, i)} that takes
a subset of \code{x} based on a single vector of indices \code{i} and returns a vector.}

\item{extract_matrix}{A function in the form of \code{function(x, i, j)} that
takes a subset of \code{x} based on two vectors of indices \code{i} and \code{j} and returns
a matrix.}
}
\value{
A function in the form of \code{function(x, i, j, ..., drop = TRUE)} that
is meant to be used as a method for \code{[} for a custom type.
}
\description{
\code{extract} is a function that converts different index types such as negative
integer vectors or logical vectors passed to the \code{[} function as \code{i}
(e.g. \code{X[i]}) or \code{i} and \code{j} (e.g. \code{X[i, j]}) into positive
integer vectors. The converted indices are provided as the \code{i} parameter of
\code{extract_vector} or \code{i} and \code{j} parameters of \code{extract_matrix} to facilitate
implementing the extraction mechanism for custom matrix-like types.
}
\details{
The custom type must implement methods for \code{dim} for this function
to work. Implementing methods for \code{nrow} and \code{ncol} is not necessary
as the default method of those generics calls \code{dim} internally.

\strong{This idea initially comes from \href{https://goo.gl/3RDNQG}{package crochet}.}
}
