% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readdatamlx.R
\name{readDatamlx}
\alias{readDatamlx}
\title{Read formatted data file}
\usage{
readDatamlx(project = NULL, data = NULL, out.data = FALSE,
  nbSSDoses = 10, obs.rows = FALSE, datafile = NULL, header = NULL,
  infoProject = NULL, addl.ss = NULL)
}
\arguments{
\item{project}{a Monolix project}

\item{data}{a list with fields
\itemize{
  \item \code{dataFile}: path of a formatted data file
  \item \code{headerTypes}: a vector of strings
}}

\item{out.data}{TRUE/FALSE (default=FALSE) returns the original data as a table and some information about the Monolix project}

\item{nbSSDoses}{number of additional doses to use for steady-state (default=10)}

\item{obs.rows}{a list of observation indexes}

\item{datafile}{(deprecated) a formatted data file}

\item{header}{(deprecated) a vector of strings}

\item{infoProject}{(deprecated) an xmlfile}

\item{addl.ss}{(deprecated) number of additional doses to use for steady-state  (default=10)}
}
\value{
A list of data frames
}
\description{
Read data in a Monolix/NONMEM format
}
\details{
See http://simulx.webpopix.org/mlxr/readdatamlx/ for more details.
}
\examples{
\dontrun{
# using a Monolix project:
d <- readDatamlx(project='projects/warfarinPK.mlxtran')


# using a data file:
warfarinPK <- list(dataFile = "data/warfarinPK.csv",
                   headerTypes = c("id", "time", "observation", "amount", 
                                   "contcov", "contcov", "catcov"),
                   administration = "oral")
d <- readDatamlx(data=warfarinPK)

}
}
