% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-opal_functions.R
\name{taxonomy_opal_get}
\alias{taxonomy_opal_get}
\title{Get available taxonomies in format used by Opal}
\usage{
taxonomy_opal_get(opal)
}
\arguments{
\item{opal}{Opal login attributes.}
}
\value{
A tibble identifying a taxonomy (generally generated from Opal taxonomy).
}
\description{
Downloads all taxonomies from an Opal server in a specific tibble format
used by Opal.
}
\details{
Opal is the OBiBa application for data management, and Opal environments can
be integrated with RStudio environments using the package \code{opalr}.
The user must have adequate credentials to interact with a specific Opal
environment. Some function errors produced may be associated with the
handler or Opal read/write permissions.
}
\examples{
\donttest{

library(opalr)
opal <- 
 opal.login('administrator','password',
   url ='https://opal-demo.obiba.org/')
  
try(taxonomy_opal_get(opal))

}

}
\seealso{
Please see \href{https://opaldoc.obiba.org/en/dev/}{Opal documentation} for
complete documentation.
\code{\link[madshapR:as_taxonomy]{madshapR::as_taxonomy()}}
}
