% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPO_cbind.R
\name{cpoCbind}
\alias{cpoCbind}
\title{\dQuote{cbind} the Result of Multiple CPOs}
\usage{
cpoCbind(..., .cpos = list())
}
\arguments{
\item{...}{[\code{\link{CPO}}]\cr
The \code{\link{CPO}}s to cbind. These must be Feature Operation CPOs.
Named arguments will result in the respective
columns being prefixed with the name. This is highly recommended if there
is any chance of name collision otherwise. it is possible to use the same
name multiple times (provided the resulting column names don't clash).}

\item{.cpos}{[\code{list} of \code{\link{CPO}}]\cr
Alternatively, give the CPOs to cbind as a list. Default is \code{list()}.}
}
\value{
[\code{\link{CPO}}].
}
\description{
This is a \code{\link{CPOConstructor}} to be used to create a
\code{\link{CPO}}. It is called like any R function and returns
the created \code{\link{CPO}}.

Build a \code{\link{CPO}} that represents the operations of its input parameters,
performed in parallel and put together column wise.

For example, to construct a \code{\link[mlr]{Task}} that contains the original
data, as well as the data after scaling, one could do

\code{task \%>>\% cpoCbind(NULLCPO, cpoScale())}

The result of \code{cpoCbind} is itself a CPO which exports its constituents'
hyperparameters. CPOs with the same type / ID get combined automatically.
To get networks, e.g. of the form
\preformatted{
      ,-C--E-.
     /    /   \
A---B----D-----F---G
}
one coul use the code
\preformatted{
initcpo = A \%>>\% B
route1 = initcpo \%>>\% D
route2 = cpoCbind(route1, initcpo \%>>\% C) \%>>\% E
result = cpoCbind(route1, route2) \%>>\% F \%>>\% G
}

\code{cpoCbind} finds common paths among its arguments and combines them into one operation.
This saves computation and makes it possible for one exported hyperparameter to
influence multiple of \code{cpoCbind}'s inputs. However, if you want to use the same
operation with different parameters on different parts of \code{cpoCbind} input,
you must give these operations different IDs. If CPOs that could represent an identical CPO,
with the same IDs (or both with IDs absent) but different parameter settings, \code{affect.*} settings
or different parameter exportations occur, an error will be thrown.
}
\section{General CPO info}{

This function creates a CPO object, which can be applied to
\code{\link{Task}}s, \code{data.frame}s, \code{link{Learner}}s
and other CPO objects using the \code{\link{\%>>\%}} operator.

The parameters of this object can be changed after creation
using the function \code{\link{setHyperPars}}. The other
hyper-parameter manipulating functins, \code{\link{getHyperPars}}
and \code{\link{getParamSet}} similarly work as one expects.

If the \dQuote{id} parameter is given, the hyperparameters
will have this id as aprefix; this will, however, not change
the parameters of the creator function.
}

\section{Calling a \code{\link{CPOConstructor}}}{

CPO constructor functions are called with optional values of parameters, and additional \dQuote{special} optional values.
The special optional values are the \code{id} parameter, and the \code{affect.*} parameters. The \code{affect.*} parameters
enable the user to control which subset of a given dataset is affected. If no \code{affect.*} parameters are given, all
data features are affected by default.
}

\seealso{
Other CPOs: 
\code{\link{cpoApplyFunRegrTarget}()},
\code{\link{cpoApplyFun}()},
\code{\link{cpoAsNumeric}()},
\code{\link{cpoCache}()},
\code{\link{cpoCollapseFact}()},
\code{\link{cpoDropConstants}()},
\code{\link{cpoDropMostlyConstants}()},
\code{\link{cpoDummyEncode}()},
\code{\link{cpoFilterAnova}()},
\code{\link{cpoFilterCarscore}()},
\code{\link{cpoFilterChiSquared}()},
\code{\link{cpoFilterFeatures}()},
\code{\link{cpoFilterGainRatio}()},
\code{\link{cpoFilterInformationGain}()},
\code{\link{cpoFilterKruskal}()},
\code{\link{cpoFilterLinearCorrelation}()},
\code{\link{cpoFilterMrmr}()},
\code{\link{cpoFilterOneR}()},
\code{\link{cpoFilterPermutationImportance}()},
\code{\link{cpoFilterRankCorrelation}()},
\code{\link{cpoFilterRelief}()},
\code{\link{cpoFilterRfCImportance}()},
\code{\link{cpoFilterRfImportance}()},
\code{\link{cpoFilterRfSRCImportance}()},
\code{\link{cpoFilterRfSRCMinDepth}()},
\code{\link{cpoFilterSymmetricalUncertainty}()},
\code{\link{cpoFilterUnivariate}()},
\code{\link{cpoFilterVariance}()},
\code{\link{cpoFixFactors}()},
\code{\link{cpoIca}()},
\code{\link{cpoImpactEncodeClassif}()},
\code{\link{cpoImpactEncodeRegr}()},
\code{\link{cpoImputeConstant}()},
\code{\link{cpoImputeHist}()},
\code{\link{cpoImputeLearner}()},
\code{\link{cpoImputeMax}()},
\code{\link{cpoImputeMean}()},
\code{\link{cpoImputeMedian}()},
\code{\link{cpoImputeMin}()},
\code{\link{cpoImputeMode}()},
\code{\link{cpoImputeNormal}()},
\code{\link{cpoImputeUniform}()},
\code{\link{cpoImpute}()},
\code{\link{cpoLogTrafoRegr}()},
\code{\link{cpoMakeCols}()},
\code{\link{cpoMissingIndicators}()},
\code{\link{cpoModelMatrix}()},
\code{\link{cpoOversample}()},
\code{\link{cpoPca}()},
\code{\link{cpoProbEncode}()},
\code{\link{cpoQuantileBinNumerics}()},
\code{\link{cpoRegrResiduals}()},
\code{\link{cpoResponseFromSE}()},
\code{\link{cpoSample}()},
\code{\link{cpoScaleMaxAbs}()},
\code{\link{cpoScaleRange}()},
\code{\link{cpoScale}()},
\code{\link{cpoSelect}()},
\code{\link{cpoSmote}()},
\code{\link{cpoSpatialSign}()},
\code{\link{cpoTransformParams}()},
\code{\link{cpoWrap}()},
\code{\link{makeCPOCase}()},
\code{\link{makeCPOMultiplex}()}

Other special CPOs: 
\code{\link{cpoTransformParams}()},
\code{\link{cpoWrap}()},
\code{\link{makeCPOCase}()},
\code{\link{makeCPOMultiplex}()}
}
\concept{CPOs}
\concept{special CPOs}
