% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPO_subsample.R
\name{cpoSample}
\alias{cpoSample}
\title{Sample Data from a Task}
\usage{
cpoSample(rate = NULL, size = NULL, replace = FALSE, id,
  export = "export.default")
}
\arguments{
\item{rate}{[\code{numeric(1)} | \code{NULL}]\cr
How many samples to take, relative to the task size. Default is \code{NULL}:
Not using relative sampling rate. Exactly one of this or \code{size} must be
non-\code{NULL}.}

\item{size}{[\code{integer(1)} | \code{NULL}]\cr
How many samples to take. Default is \code{NULL}: Not using absolute size.
Exactly one of this or \code{size} must be non-\code{NULL}.}

\item{replace}{[\code{logical(1)}]\cr
Whether to sample with replacement. Default is \code{FALSE}.}

\item{id}{[\code{character(1)}]\cr
id to use as prefix for the CPO's hyperparameters. this
must be used to avoid name clashes when composing two
CPOs of the same type, or with learners or other CPOS
with hyperparameters with clashing names.}

\item{export}{[\code{character}]\cr
Either a character vector indicating the parameters to
export as hyperparameters, or one of the special values
\dQuote{export.all} (export all parameters),
\dQuote{export.default} (export all parameters that are exported by default),
\dQuote{export.set} (export all parameters that were set during construction),
\dQuote{export.default.set} (export the intersection of the \dQuote{default} and \dQuote{set} parameters),
\dQuote{export.unset} (export all parameters that were \emph{not} set during construction) or
\dQuote{export.default.unset} (export the intersection of the \dQuote{default} and \dQuote{unset} parameters).
Default is \dQuote{export.default}.}
}
\value{
[\code{\link{CPO}}].
}
\description{
This is a \code{\link{CPOConstructor}} to be used to create a
\code{\link{CPO}}. It is called like any R function and returns
the created \code{\link{CPO}}.

Takes samples from a task to decrease (or possibly increase) its size. This
can be used to reduce training time, or to implement bootstrapping.
}
\section{General CPO info}{

This function creates a CPO object, which can be applied to
\code{\link{Task}}s, \code{data.frame}s, \code{link{Learner}}s
and other CPO objects using the \code{\link{\%>>\%}} operator.

The parameters of this object can be changed after creation
using the function \code{\link{setHyperPars}}. The other
hyper-parameter manipulating functins, \code{\link{getHyperPars}}
and \code{\link{getParamSet}} similarly work as one expects.

If the \dQuote{id} parameter is given, the hyperparameters
will have this id as aprefix; this will, however, not change
the parameters of the creator function.
}

\section{Calling a \code{\link{CPOConstructor}}}{

CPO constructor functions are called with optional values of parameters, and additional \dQuote{special} optional values.
The special optional values are the \code{id} parameter, and the \code{affect.*} parameters. The \code{affect.*} parameters
enable the user to control which subset of a given dataset is affected. If no \code{affect.*} parameters are given, all
data features are affected by default.
}

\seealso{
Other CPOs: \code{\link{cpoApplyFunRegrTarget}},
  \code{\link{cpoApplyFun}}, \code{\link{cpoAsNumeric}},
  \code{\link{cpoCache}}, \code{\link{cpoCbind}},
  \code{\link{cpoCollapseFact}},
  \code{\link{cpoDropConstants}},
  \code{\link{cpoDummyEncode}},
  \code{\link{cpoFilterAnova}},
  \code{\link{cpoFilterCarscore}},
  \code{\link{cpoFilterChiSquared}},
  \code{\link{cpoFilterFeatures}},
  \code{\link{cpoFilterGainRatio}},
  \code{\link{cpoFilterInformationGain}},
  \code{\link{cpoFilterKruskal}},
  \code{\link{cpoFilterLinearCorrelation}},
  \code{\link{cpoFilterMrmr}}, \code{\link{cpoFilterOneR}},
  \code{\link{cpoFilterPermutationImportance}},
  \code{\link{cpoFilterRankCorrelation}},
  \code{\link{cpoFilterRelief}},
  \code{\link{cpoFilterRfCImportance}},
  \code{\link{cpoFilterRfImportance}},
  \code{\link{cpoFilterRfSRCImportance}},
  \code{\link{cpoFilterRfSRCMinDepth}},
  \code{\link{cpoFilterSymmetricalUncertainty}},
  \code{\link{cpoFilterUnivariate}},
  \code{\link{cpoFilterVariance}},
  \code{\link{cpoFixFactors}}, \code{\link{cpoIca}},
  \code{\link{cpoImpactEncodeClassif}},
  \code{\link{cpoImpactEncodeRegr}},
  \code{\link{cpoImputeConstant}},
  \code{\link{cpoImputeHist}},
  \code{\link{cpoImputeLearner}},
  \code{\link{cpoImputeMax}}, \code{\link{cpoImputeMean}},
  \code{\link{cpoImputeMedian}},
  \code{\link{cpoImputeMin}}, \code{\link{cpoImputeMode}},
  \code{\link{cpoImputeNormal}},
  \code{\link{cpoImputeUniform}}, \code{\link{cpoImpute}},
  \code{\link{cpoLogTrafoRegr}}, \code{\link{cpoMakeCols}},
  \code{\link{cpoMissingIndicators}},
  \code{\link{cpoModelMatrix}},
  \code{\link{cpoOversample}}, \code{\link{cpoPca}},
  \code{\link{cpoProbEncode}},
  \code{\link{cpoQuantileBinNumerics}},
  \code{\link{cpoRegrResiduals}},
  \code{\link{cpoResponseFromSE}},
  \code{\link{cpoScaleMaxAbs}},
  \code{\link{cpoScaleRange}}, \code{\link{cpoScale}},
  \code{\link{cpoSelect}}, \code{\link{cpoSmote}},
  \code{\link{cpoSpatialSign}},
  \code{\link{cpoTransformParams}}, \code{\link{cpoWrap}},
  \code{\link{makeCPOCase}}, \code{\link{makeCPOMultiplex}}
}
