% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionSurv.R
\name{PredictionSurv}
\alias{PredictionSurv}
\title{Prediction Object for Survival}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3:Prediction]{mlr3::Prediction}.}
\description{
This object stores the predictions returned by a learner of class \link{LearnerSurv}.

The \code{task_type} is set to \code{"surv"}.
}
\section{Construction}{
\preformatted{PredictionSurv$new(task = NULL, row_ids = task$row_ids, truth = task$truth(),
                   crank = NULL, distr = NULL, lp = NULL, response = NULL)
}
\itemize{
\item \code{task} :: \link{TaskSurv}\cr
Task, used to extract defaults for \code{row_ids} and \code{truth}.
\item \code{row_ids} :: (\code{integer()} | \code{character()})\cr
Row ids of the task. Per default, these are extracted from the \code{task}.
\item \code{truth} :: \code{survival::Surv()}\cr
Observed survival times. Per default, these are extracted from the \code{task}.
\item \code{crank} :: \code{numeric()}\cr
Vector of continuous ranks. One element for each observation in the test set.
For a pair of continuous ranks, a higher rank indicates that the observation is more likely
to experience the event.
Used in discrimination measures like \link[=mlr_measures_surv.harrellC]{surv.harrellC}.
\item \code{distr} :: \code{distr6::Distribution()}\cr
\link[distr6:VectorDistribution]{VectorDistribution} from \CRANpkg{distr6}.
Each individual distribution in the vector represents the random variable 'survival time' for
an individual observation.
Used in measures like \link[=mlr_measures_surv.graf]{surv.graf}.
\item \code{lp} :: \code{numeric()}\cr
Vector of linear predictor scores. One element for each observation in the test set.
\eqn{lp = X\beta} where \eqn{X} is a matrix of covariates and \eqn{\beta} is a vector of estimated coefficients.
Used in discrimination measures like \link[=mlr_measures_surv.harrellC]{surv.harrellC}.
\item \code{response} :: \code{numeric()}\cr
Vector of survival times. One element for each observation in the test set.
Used in distance measures like \link[=mlr_measures_surv.rmse]{surv.rmse}.
}
}

\section{Fields}{

See \link[mlr3:Prediction]{mlr3::Prediction}.

The field \code{task_type} is set to \code{"surv"}.
}

\examples{
library(mlr3)
task = tgen("simsurv")$generate(20)
learner = mlr_learners$get("surv.rpart")
p = learner$train(task)$predict(task)
head(as.data.table(p))
}
\concept{Prediction}
