% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurvGlmboost.R
\name{LearnerSurvGlmboost}
\alias{LearnerSurvGlmboost}
\alias{mlr_learners_surv.glmboost}
\title{Gradient Boosting with Component-wise Linear Models Survival Learner}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{LearnerSurv}.}
\description{
Calls \code{\link[mboost:glmboost]{mboost::glmboost()}}.
\itemize{
\item lp is predicted by \code{\link[mboost:predict.mboost]{mboost::predict.mboost()}}
\item distr is predicted by \code{\link[mboost:survFit]{mboost::survFit()}} which assumes a PH fit with a Breslow estimator
\item \code{crank} is identical to \code{lp}
}

The \code{dist} parameter is specified slightly differently than in \CRANpkg{mboost}. Whereas the latter
takes in objects, in this learner instead a string is specified in order to identify which distribution
to use. As the default in \CRANpkg{mboost} is the Gaussian family, which is not compatible with
survival models, instead we have by default \code{"coxph"}.

If the value given to the \code{Family} parameter is "custom.family" then an object of class
\code{\link[mboost:Family]{mboost::Family()}} needs to be passed to the \code{custom.family} parameter.
}
\section{Construction}{
\preformatted{LearnerSurvGlmboost$new()
mlr_learners$get("surv.glmboost")
lrn("surv.glmboost")
}
}

\section{Meta Information}{

\itemize{
\item Type: "surv"
\item Predict Types: \verb{distr, crank, lp}
\item Feature Types: \verb{integer, numeric, factor, logical}
\item Packages: \CRANpkg{mboost} \CRANpkg{distr6} \CRANpkg{survival}
}
}

\examples{
library(mlr3)
task = tgen("simsurv")$generate(20)
learner = lrn("surv.glmboost")
resampling = rsmp("cv", folds = 3)
resample(task, learner, resampling)
}
\references{
\cite{mlr3proba}{buehlmann_2003}

\cite{mlr3proba}{buehlmann_2006}

\cite{mlr3proba}{buehlmann_2007}

\cite{mlr3proba}{hothorn_2010}

\cite{mlr3proba}{hofner_2012}
}
\seealso{
Other survival learners: 
\code{\link{LearnerSurvBlackboost}},
\code{\link{LearnerSurvCVGlmnet}},
\code{\link{LearnerSurvCoxPH}},
\code{\link{LearnerSurvFlexible}},
\code{\link{LearnerSurvGBM}},
\code{\link{LearnerSurvGamboost}},
\code{\link{LearnerSurvGlmnet}},
\code{\link{LearnerSurvKaplan}},
\code{\link{LearnerSurvMboost}},
\code{\link{LearnerSurvNelson}},
\code{\link{LearnerSurvObliqueRSF}},
\code{\link{LearnerSurvParametric}},
\code{\link{LearnerSurvPenalized}},
\code{\link{LearnerSurvRandomForestSRC}},
\code{\link{LearnerSurvRanger}},
\code{\link{LearnerSurvRpart}},
\code{\link{LearnerSurvSVM}}
}
\concept{survival learners}
