% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerSurv.R
\name{LearnerSurv}
\alias{LearnerSurv}
\title{Survival Learner}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3:Learner]{mlr3::Learner}.}
\description{
This Learner specializes \link[mlr3:Learner]{mlr3::Learner} for survival problems.
Predefined learners can be found in the \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} \link[mlr3:mlr_learners]{mlr3::mlr_learners}.
}
\section{Construction}{
\preformatted{LearnerSurv$new(id, param_set = ParamSet$new(),
     predict_types = character(),
     feature_types = character(), properties = character(),
     packages = character())
}

For a description of the arguments, see \link[mlr3:Learner]{mlr3::Learner}.
\code{task_type} is set to \code{"surv"}.
Possible values for \code{predict_type} are \code{"distr"}, \code{"lp"}, \code{"crank"}, and \code{"response"}.
}

\section{Fields}{

See \link[mlr3:Learner]{mlr3::Learner}.
}

\section{Methods}{

See \link[mlr3:Learner]{mlr3::Learner}.
}

\examples{
library(mlr3)
ids = mlr_learners$keys("^surv")
ids

# get a specific learner from mlr_learners:
lrn = mlr_learners$get("surv.rpart")
print(lrn)
}
\concept{Learner}
