% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_acc.R
\name{acc}
\alias{acc}
\title{Classification Accuracy}
\usage{
acc(truth, response, ...)
}
\arguments{
\item{truth}{:: \code{factor()}\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{response}{:: \code{factor()}\cr
Predicted response labels.
Must have the same levels and length as \code{truth}.}

\item{...}{:: \code{any}\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Classification measure defined as \deqn{
  \frac{1}{n} \sum_{i=1}^n \left( t_i = r_i \right).
}{
  mean(t == r).
}
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
response = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
acc(truth, response)
}
\seealso{
Other Classification Measures: 
\code{\link{bacc}()},
\code{\link{ce}()},
\code{\link{logloss}()},
\code{\link{mauc_aunu}()},
\code{\link{mbrier}()}
}
\concept{Classification Measures}
\concept{classification_measure}
