% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measure_operators.R
\name{setMeasurePars}
\alias{setMeasurePars}
\title{Set parameters of performance measures}
\usage{
setMeasurePars(measure, ..., par.vals = list())
}
\arguments{
\item{measure}{(\link{Measure})\cr
Performance measure.}

\item{...}{(any)\cr
Named (hyper)parameters with new settings. Alternatively these can be passed
using the \code{par.vals} argument.}

\item{par.vals}{(\link{list})\cr
Optional list of named (hyper)parameter settings. The arguments in
\code{...} take precedence over values in this list.}
}
\value{
\link{Measure}.
}
\description{
Sets hyperparameters of measures.
}
\seealso{
Other performance: \code{\link{ConfusionMatrix}},
  \code{\link{calculateConfusionMatrix}},
  \code{\link{calculateROCMeasures}},
  \code{\link{estimateRelativeOverfitting}},
  \code{\link{makeCostMeasure}},
  \code{\link{makeCustomResampledMeasure}},
  \code{\link{makeMeasure}}, \code{\link{measures}},
  \code{\link{performance}}, \code{\link{setAggregation}}
}
