% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steadySingleSpecies.R
\name{steadySingleSpecies}
\alias{steadySingleSpecies}
\title{Set initial abundances to single-species steady state abundances}
\usage{
steadySingleSpecies(
  params,
  species = NULL,
  keep = c("egg", "biomass", "number")
)
}
\arguments{
\item{params}{A MizerParams object}

\item{species}{The species to be selected. Optional. By default all target
species are selected. A vector of species names, or a numeric vector with
the species indices, or a logical vector indicating for each species
whether it is to be selected (TRUE) or not.}

\item{keep}{A string determining which quantity is to be kept constant. The
choices are "egg" which keeps the egg density constant, "biomass" which
keeps the total biomass of the species constant and "number" which keeps
the total number of individuals constant.}
}
\value{
A MizerParams object in which the initial abundances of the selected
species are changed to their single-species steady state abundances.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This first calculates growth and death rates that arise from the current
initial abundances. Then it uses these growth and death rates to
determine the steady-state abundances of the selected species.
}
\details{
The result of applying this function is of course not a multi-species steady
state, because after changing the abundances of the selected species the
growth and death rates will have changed.
}
