% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.duplicated.R
\name{df.duplicated}
\alias{df.duplicated}
\alias{df.unique}
\title{Extract Duplicated or Unique Rows}
\usage{
df.duplicated(x, ..., first = TRUE, keep.all = TRUE,
              from.last = FALSE, keep.row.names = TRUE,
              check = TRUE)

df.unique(x, ..., keep.all = TRUE,
          from.last = FALSE, keep.row.names = TRUE,
          check = TRUE)
}
\arguments{
\item{x}{a matrix or data frame.}

\item{...}{a variable or multiple variables which are specified without
quotes \code{''} or double quotes \code{""} used to determine
duplicated or unique rows. By default, all variables in \code{x}
are used.}

\item{first}{logical: if \code{TRUE}, the \code{df.duplicated()} function
will return duplicated rows including the first of identical
rows.}

\item{keep.all}{logical: if \code{TRUE}, the function will return all variables
in \code{x} after extracting duplicated or unique rows based
on the variables specified in the argument \code{...}.}

\item{from.last}{logical: if \code{TRUE}, duplication will be considered
from the reversed side, i.e., the last of identical rows
would correspond to \code{duplicated = FALSE}.
Note that this argument is only used when \code{first = FALSE}.}

\item{keep.row.names}{logical: if \code{TRUE}, the row names from \code{x} are kept,
otherwise they are set to \code{NULL}.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns duplicated or unique rows of the matrix or data frame in \code{x}.
}
\description{
This function extracts duplicated or unique rows from a matrix or data frame.
}
\details{
Note that \code{df.unique(x)} is equivalent to \code{unique(x)}. That is, the
main difference between the \code{df.unique()} and the \code{unique()} function is
that the \code{df.unique()} function provides the \code{...} argument to
specify a variable or multiple variables which are used to determine unique rows.
}
\examples{
dat <- data.frame(x1 = c(1, 1, 2, 1, 4),
                  x2 = c(1, 1, 2, 1, 6),
                  x3 = c(2, 2, 3, 2, 6),
                  x4 = c(1, 1, 2, 2, 4),
                  x5 = c(1, 1, 4, 4, 3))

#--------------------------------------
# df.duplicated() function

# Extract duplicated rows based on all variables
df.duplicated(dat)

# Extract duplicated rows based on x4
df.duplicated(dat, x4)

# Extract duplicated rows based on x2 and x3
df.duplicated(dat, x2, x3)

# Extract duplicated rows based on all variables
# exclude first of identical rows
df.duplicated(dat, first = FALSE)

# Extract duplicated rows based on x2 and x3
# do not return all variables
df.duplicated(dat, x2, x3, keep.all = FALSE)

# Extract duplicated rows based on x4
# consider duplication from the reversed side
df.duplicated(dat, x4, first = FALSE, from.last = TRUE)

# Extract duplicated rows based on x2 and x3
# set row names to NULL
df.duplicated(dat, x2, x3, keep.row.names = FALSE)

#--------------------------------------
# df.unique() function

# Extract unique rows based on all variables
unique(dat)

# Extract unique rows based on x4
df.unique(dat, x4)

# Extract unique rows based on x1, x2, and x3
df.unique(dat, x1, x2, x3)

# Extract unique rows based on x2 and x3
# do not return all variables
df.unique(dat, x2, x3, keep.all = FALSE)

# Extract unique rows based on x4
# consider duplication from the reversed side
df.unique(dat, x4, from.last = TRUE)

# Extract unique rows based on x2 and x3
# set row names to NULL
df.unique(dat, x2, x3, keep.row.names = FALSE)
}
\references{
Becker, R. A., Chambers, J. M. and Wilks, A. R. (1988) \emph{The New S Language}.
Wadsworth & Brooks/Cole.
}
\seealso{
\code{\link{df.unique}}, \code{\link{df.merge}}, \code{\link{df.rbind}},
\code{\link{df.rename}}, \code{\link{df.sort}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
