% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemons.R
\name{serialization}
\alias{serialization}
\title{Custom Serialization Functions}
\usage{
serialization(fns, class, vec = FALSE)
}
\arguments{
\item{fns}{\strong{either} a list comprising 2 functions: \cr serialization
function: must accept a reference object (or list of objects) inheriting
from \sQuote{class} and return a raw vector.\cr unserialization function:
must accept a raw vector and return a reference object (or list of
reference objects).\cr \strong{or else} NULL to reset.}

\item{class}{the class of reference object (as a character string) that these
functions are applied to, e.g. 'ArrowTabular' or 'torch_tensor'.}

\item{vec}{[default FALSE] if FALSE the functions must accept and return
reference objects individually e.g. \code{arrow::write_to_raw} and
\code{arrow::read_ipc_stream}. If TRUE, the functions are vectorized and
must accept and return a list of reference objects, e.g.
\code{torch::torch_serialize} and \code{torch::torch_load}.}
}
\value{
Invisibly, a list comprising 'fns', class', and 'vec', or else NULL
    if supplied to 'fns'.
}
\description{
Registers custom serialization and unserialization functions for sending and
    receiving reference objects.
}
\details{
Registering new functions replaces any existing registered functions.

    This function may be called prior to or after setting daemons, with the
    registered functions applying across all compute profiles.

    Calling without any arguments returns a list comprising the registered
    values for 'fns', class', and 'vec', or else NULL if not registered.
}
\examples{
reg <- serialization(
  list(function(x) serialize(x, NULL), base::unserialize),
  class = "example_class"
)
reg

serialization(NULL)
print(serialization())

}
