% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohesion.R
\name{cohesion}
\alias{cohesion}
\alias{graph_density}
\alias{graph_reciprocity}
\alias{graph_transitivity}
\alias{graph_equivalency}
\title{Cohesion for one-, two-, and three- mode networks}
\usage{
graph_density(object)

graph_reciprocity(object)

graph_transitivity(object)

graph_equivalency(object, object2 = NULL)
}
\arguments{
\item{object}{A one-mode or two-mode matrix, igraph, or tidygraph}

\item{object2}{Optionally, a second (two-mode) matrix, igraph, or tidygraph}
}
\description{
These functions offer methods for summarising the cohesion in one-, two-, and three-mode networks.
}
\details{
For one- and two-mode networks, \code{graph_density} summarises the ratio of ties
to the number of possible ties.

For one-mode networks, shallow wrappers of igraph versions exist via
\code{graph_reciprocity} and \code{graph_transitivity}.

For two-mode networks, \code{graph_equivalence} calculates the proportion of three-paths in the network
that are closed by fourth tie to establish a "shared four-cycle" structure.

For three-mode networks, \code{graph_equivalence} calculates the proportion of three-paths spanning the two two-mode networks
that are closed by a fourth tie to establish a "congruent four-cycle" structure.
}
\examples{
graph_density(mpn_elite_mex)
graph_density(mpn_elite_usa_advice)
graph_reciprocity(southern_women)
graph_transitivity(southern_women)
graph_equivalency(southern_women)
}
\references{
Robins, Garry L, and Malcolm Alexander. 2004.
Small worlds among interlocking directors: Network structure and distance in bipartite graphs.
\emph{Computational & Mathematical Organization Theory} 10 (1): 69–94.

Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}.
Cambridge University Press. Cambridge University Press.
}
\seealso{
Other one-mode measures: 
\code{\link{node_constraint}()}

Other two-mode measures: 
\code{\link{centrality}},
\code{\link{centralization}},
\code{\link{node_constraint}()},
\code{\link{node_smallworld}()}
}
\concept{one-mode measures}
\concept{three-mode measures}
\concept{two-mode measures}
