% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_census.R
\name{brokerage_census}
\alias{brokerage_census}
\alias{node_brokerage_census}
\alias{network_brokerage_census}
\title{Censuses of brokerage motifs}
\usage{
node_brokerage_census(object, membership, standardized = FALSE)

network_brokerage_census(object, membership, standardized = FALSE)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{membership}{A vector of partition membership as integers.}

\item{standardized}{Whether the score should be standardized
into a \emph{z}-score indicating how many standard deviations above
or below the average the score lies.}
}
\description{
Censuses of brokerage motifs
}
\section{Functions}{
\itemize{
\item \code{node_brokerage_census()}: Returns the Gould-Fernandez brokerage
roles played by nodes in a network.

\item \code{network_brokerage_census()}: Returns the Gould-Fernandez brokerage
roles in a network.

}}
\examples{
node_brokerage_census(ison_networkers, "Discipline")
network_brokerage_census(ison_networkers, "Discipline")
}
\references{
Gould, R.V. and Fernandez, R.M. 1989.
“Structures of Mediation: A Formal Approach to Brokerage in Transaction Networks.”
\emph{Sociological Methodology}, 19: 89-126.
}
\seealso{
Other motifs: 
\code{\link{network_census}},
\code{\link{node_census}}
}
\concept{motifs}
