% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_mirna.R
\name{plot_target_mir_scatter}
\alias{plot_target_mir_scatter}
\title{Plot targets and corresponding miRNAs as a scatter plot}
\usage{
plot_target_mir_scatter(
  df,
  mir = NULL,
  target = NULL,
  top = NULL,
  threshold = NULL,
  filter_for = "target",
  col.target = Target,
  col.mir = miRNA,
  col.topic = Topic,
  col.pmid = PMID,
  title = NULL,
  height = 0.05,
  width = 0.05,
  alpha = 0.6
)
}
\arguments{
\item{df}{Data frame containing targets and miRNA names.}

\item{mir}{String or character vector. Specifies which miRNAs to plot.}

\item{target}{String or character vector. Specifies which targets to plot.}

\item{top}{Numeric. Specifies number of top targets/miRNA names to be plotted.}

\item{threshold}{Numeric. Specifies how often a target/miRNA name must be in
\code{df} to be plotted.}

\item{filter_for}{String. Must either be \code{"target"} or \code{"miRNA"}. Specifies if
\code{threshold}/\code{top} shall be applied to targets or miRNA names.}

\item{col.target}{Symbol. Column containing miRNA targets.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.topic}{Symbol. Column containing topic names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}

\item{height}{Double. Specifies height of jitter.}

\item{width}{Double. Specifies width of jitter.}

\item{alpha}{Double. Specifies opacity of points.}
}
\value{
Scatter plot with targets and corresponding miRNAs.
}
\description{
Plot targets and corresponding miRNAs as a scatter plot.
}
\details{
Plot targets and corresponding miRNAs as a scatter plot.
With \code{filter_for}, it can be determined if the focus shall be
on the top targets to plot their corresponding miRNAs,
or if the focus
shall be on the top miRNA names to plot their corresponding targets.
What "top targets" or "top miRNA names" mean can be determined via the
\code{top} and \code{threshold} arguments.
\itemize{
\item If \code{top} is given, \code{df} is filtered for the most frequent targets/miRNA
names.
\item If \code{threshold} is given, data frame is filtered for all targets/miRNA names
mentioned at least \code{threshold} times.
\item If neither \code{top} nor \code{threshold} is given, \code{top} is automatically set
to \code{5}.
}

By plotting miRNAs
against their targets, it is visualized if one miRNA regulates many targets,
or if one target is regulated by many miRNAs. Furthermore, the miRNA-target
interactions are labelled according to their topic in \code{col.topic}, thereby
facilitating comparison of miRNA-target interactions across different topics.
}
\seealso{
\code{\link[=join_targets]{join_targets()}}

Other target functions: 
\code{\link{count_target}()},
\code{\link{join_mirtarbase}()},
\code{\link{join_targets}()},
\code{\link{plot_target_count}()}
}
\concept{target functions}
