% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lengthNonZeros.R
\name{lengthNonZeros}
\alias{lengthNonZeros}
\title{Calculate the species richness of a vector from a CDM}
\usage{
lengthNonZeros(input.vector)
}
\arguments{
\item{input.vector}{A vector from a community data matrix of abundances.}
}
\value{
A named vector of species richness.
}
\description{
Given a vector of abundances or presence/absences from a community data matrix, will
calculate the species richness of that vector.
}
\details{
An internal function to calculate richness of a cdm.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

#note that with this example, each community in the cdm will be labeled by its richness
apply(cdm, 1, lengthNonZeros)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

